<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.reports">
<div class="need-attention-detail" data-ng-controller="NeedsAttentionInfrastructureController as ctrl" >
	<h2><fmt:message key="infra.detail.title"/></h2>
	<div data-ng-repeat="server in ctrl.data.servers">
		<div class="detail-row row">
			<div class="col-lg-2 col-md-2 col-sm-2">
				<div class="entity-name"  title="{{server.clientName}}"> <img data-ng-src="{{ctrl.serverImg}}"/> <a data-ng-href="{{server.detailsLink}}"> {{server.clientName}}</a></div>
			</div>
			<div class="col-lg-4 col-md-4 col-sm-4 prop-col">
				<span class="prop-label"><fmt:message key="servers.detail.reason"/></span>
				<span class="prop-value">{{server.reason}}</span>
			</div>
			<div class="col-lg-3 col-md-3 col-sm-3 prop-col">
				<span class="prop-label"><fmt:message key="infra.detail.role"/></span>
				<span class="prop-value">{{server.formattedType}}</span>
			</div>
			<div class="col-lg-3 col-md-3 col-sm-3 prop-col">
				<span class="prop-label">{{server.countLabel}}</span>
				<span data-ng-if="detail.drillURL" class="prop-value"><a href="{{server.drillURL}}">{{server.formattedCount}}</a></span>
				<span data-ng-if="!detail.drillURL" class="prop-value">{{server.formattedCount}}</span>
			</div>
		</div>
	</div>
	<cv-reports-show-loader show-loader="ctrl.data.showLoader"></cv-reports-show-loader>
	<cv-reports-no-data data-ng-if="ctrl.data.noData" no-data="ctrl.data.noData"></cv-reports-no-data>
</div>
</fmt:bundle>