<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header data-ng-if="!!slaCtrl.showTitle" title="slaCtrl.data.title" title-details-link="slaCtrl.data.titleDetailsLink">
		</cv-reports-pane-header>
		<div class="dash-pane-content sla-content">
			<div class="row" data-ng-if="slaCtrl.entities.length > 0">
				<a data-ng-class="{'col-lg-6 col-md-6 col-sm-6 col-xs-6 no-padding-left-right': !!slaCtrl.showBoth, 'col-lg-12 col-md-12 col-sm-12': !slaCtrl.showBoth}"  
				ng-repeat="entity in slaCtrl.entities" 
				ng-href="{{slaCtrl.href}}">
					<div class="sla-content-wrapper">
						<div class="sla-chart-title">{{::entity.title}}</div>
						<highchart config="entity.chartConfig" class="sla-chart-container" ></highchart>
					</div>
					<div class="custom-legend-wrapper">
						<span class="custom-legend">
							<span class="legend-box background-color-success"></span>
							<span class="legend-name">{{::entity.data.met.name}}:</span><span class="legend-val">{{::entity.data.met.dispValue}}</span>
						</span>
						<span class="custom-legend">
							<span class="legend-box background-color-critical"></span>
							<span class="legend-name">{{::entity.data.missed.name}}:</span><span class="legend-val">{{::entity.data.missed.dispValue}}</span>
						</span>
					</div>	
				</a>
			</div>
			<cv-reports-show-loader show-loader="slaCtrl.data.showLoader"></cv-reports-show-loader>
			<cv-reports-no-data data-ng-if="slaCtrl.noData" no-data="slaCtrl.noData"></cv-reports-no-data>
			<div>
				<span>
					<a class="doc-link" href="{{slaCtrl.docLink}}" target="_blank">
						<cv:msg key="sla.howToImproveSla" bundle="reports"/>
					</a>
				</span>
			</div>
		</div>
	</div>
</div>