<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="innerContent.html">
	<highchart config="entity.chartConfig" class="sla-chart-container" ></highchart>
	<div class="custom-legend-wrapper">
		<span class="custom-legend">
			<span data-ng-if="!slaCtrl.slaData.showAsSmaller" class="legend-box background-color-success"></span>
			<span data-ng-class="{'legend-name':!slaCtrl.slaData.showAsSmaller, 'legend-name color-success':slaCtrl.slaData.showAsSmaller}" >{{::entity.data.met.name}}:</span><span class="legend-val">{{::entity.data.met.dispValue}}</span>
		</span>
		<span class="custom-legend">
			<span data-ng-if="!slaCtrl.slaData.showAsSmaller" class="legend-box background-color-critical"></span>
			<span data-ng-class="{'legend-name':!slaCtrl.slaData.showAsSmaller, 'legend-name color-critical':slaCtrl.slaData.showAsSmaller}" >{{::entity.data.missed.name}}:</span><span class="legend-val">{{::entity.data.missed.dispValue}}</span>
		</span>
	</div>	

</script>
<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header data-ng-if="!!slaCtrl.showTitle" title="slaCtrl.data.title" titletooltip="slaCtrl.data.titletooltip" title-details-link="slaCtrl.data.detailsLink" details-link-new-page="slaCtrl.data.detailsLinkNewPage" >
		</cv-reports-pane-header>
		<div class="dash-pane-content sla-content">
			<div class="row" data-ng-if="slaCtrl.entities.length > 0">
				<a data-ng-class="{'col-lg-6 col-md-6 col-sm-6 col-xs-6 no-padding-left-right': !!slaCtrl.showBoth, 'col-lg-12 col-md-12 col-sm-12': !slaCtrl.showBoth}"  
				ng-repeat="entity in slaCtrl.entities" 
				ng-href="{{slaCtrl.data.detailsLinkModified}}" 
				target="{{slaCtrl.data.detailsLinkNewPage ? '_blank' : ''}}" 
				data-ng-if="!slaCtrl.data.breakDown">
					<div data-ng-include="'innerContent.html'">
					</div>
				</a>
				<a data-ng-class="{'col-lg-6 col-md-6 col-sm-6 col-xs-6 no-padding-left-right': !!slaCtrl.showBoth, 'col-lg-12 col-md-12 col-sm-12': !slaCtrl.showBoth}"  
				cv-call-out
				ng-repeat="entity in slaCtrl.entities" 
				template-path="{{slaCtrl.calloutTemplate}}" 
				params="slaCtrl.data.breakDown"
				data-ng-if="slaCtrl.data.breakDown">
					<div data-ng-include="'innerContent.html'">
					</div>
				</a>
			</div>
			<cv-reports-show-loader show-loader="slaCtrl.data.showLoader"></cv-reports-show-loader>
			<cv-reports-no-data data-ng-if="slaCtrl.noData" no-data="slaCtrl.noData"></cv-reports-no-data>
			<div data-ng-class="{ 'sla-other-info': !slaCtrl.slaData.showAsSmaller }" >
				<span data-ng-if="slaCtrl.showDocLink && slaCtrl.slaData.dashboardType !== 'Replication'"><a class="doc-link" href="{{slaCtrl.docLink}}" target="_blank"><cv:msg key="sla.howToImproveSla"  bundle="reports"/></a></span>
				<span data-ng-if="slaCtrl.excludedClients > 0" data-ng-class="{ 'sla-exclude-clients-note': slaCtrl.excludedClients > 0 }">{{slaCtrl.excludedClientsStr}}</span>
			</div>
		</div>
	</div>
</div>