<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<div class="dash-pane largestX">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header data-title="largestCtrl.largestHypervisors.title" title-details-link="largestCtrl.largestHypervisors.titleDetailsLink">
		</cv-reports-pane-header>
		<cv-reports-show-loader show-loader="largestCtrl.largestHypervisors.showLoader"></cv-reports-show-loader>
		<div class="dash-pane-content largest-server-pane largest-server-content">
			<div data-ng-if="!!(largestCtrl.largestHypervisors.data.rows.length > 0)">
				<ul class="row servers-entity-header">
					<li data-ng-repeat="header in largestCtrl.largestHypervisors.data.headers" class="{{::largestCtrl.largestHypervisors.classes[$index]}}">
						<label data-ng-bind="::header"/>
					</li>
				</ul>
				<div class="row server-entities" data-ng-class="{odd: ($index % 2) !=0, even: ($index % 2) == 0}"
					data-ng-repeat="row in largestCtrl.largestHypervisors.data.rows">
					<ul>
						<li data-ng-repeat="column in row" class="{{::largestCtrl.largestHypervisors.classes[$index]}}">
							<div data-ng-if="column.href">
								<label title="{{::column.value}}" class="column">
									<a href="{{::column.href}}">
										<span data-ng-bind="::column.value"/>
									</a>
								</label>
							</div>
							<div data-ng-if="!column.href">
								<label title="{{::column.value}}" data-ng-bind="::column.value" class="value"/>
							</div>
						</li>
					</ul>
				</div>
			</div>
			<div data-ng-if="largestCtrl.largestHypervisors.noData">
				<cv-reports-no-data no-data="largestCtrl.largestHypervisors.noData"/>
			</div>
		</div>
	</div>
</div>