<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.reports">
<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header title="reportsLargestServersCtrl.data.title" titletooltip="reportsLargestServersCtrl.data.titletooltip">
		</cv-reports-pane-header>
		<div class="dash-pane-content largest-server-content">
			<table>
				<thead>
					<tr class="servers-entity-header">
						<th><fmt:message key="dashboard.top5LargestServers.name"/></th>
						<th><fmt:message key="dashboard.top5LargestServers.size"/></th>
						<th data-ng-if="reportsLargestServersCtrl.data.showLastBackColumn"><fmt:message key="dashboard.top5LargestServers.lastBackup"/></th>
					</tr>
				</thead>
				<tbody>
					<tr  class="server-entities"  data-ng-class="{odd: ($index % 2) !=0, even: ($index % 2) == 0}"  data-ng-repeat="entity in reportsLargestServersCtrl.data.entities">
						<td title="{{entity.name}}">{{entity.name}} </td>
						<td title="{{entity.size}}">{{entity.size}} </td>
						<td data-ng-if="reportsLargestServersCtrl.data.showLastBackColumn" title="{{entity.lastBackup}}">{{entity.lastBackup}} </td>
					</tr>
				</tbody>
			</table>
			<cv-reports-show-loader show-loader="reportsLargestServersCtrl.data.showLoader"></cv-reports-show-loader>
			<cv-reports-no-data data-ng-if="reportsLargestServersCtrl.data.noData" no-data="reportsLargestServersCtrl.data.noData"></cv-reports-no-data>
		</div>
</div>
</div>
</fmt:bundle>
