<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>

<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header  title="ctrl.tileTitle"></cv-reports-pane-header>

		<div class="dash-pane-content appliance-content">
			<div class="system-content">
				<div class="col-lg-6 col-md-6 col-sm-6 no-padding">
					<div class="center sub-title">
						<span>
							<a data-ng-href="{{ctrl.systemData.detailsLink}}">
								<cv:msg key='appliance.system' bundle='reports'/>
							</a>
							</span>
						</div>
						<div class="col-lg-6 col-md-6 col-sm-6 no-padding system-entities {{entity.type}}"   data-ng-repeat="entity in ctrl.systemData.entities">
							<div class="system-chart-title">{{entity.title}}
							</div>
							<a data-ng-href="{{ctrl.systemData.detailsLink}}">
									<highchart class="chart-container" config="entity.chartConfig"></highchart>
							</a>
							<div class="custom-legend-wrapper">
									<div data-ng-if="entity.customLegend.length == 0" class="no-system-error">
										<span><cv:msg key="appliance.system.allGood" bundle="reports"/></span>
									</div>
									<div data-ng-if="entity.customLegend.length > 0" class="custom-legend row">
										<div data-ng-class="{'col-sm-6': entity.customLegend.length ==2, 'col-sm-12': entity.customLegend.length ==1}">
											<span class="legend-value">{{entity.customLegend[0].value}}</span>
											<span class="legend-label">{{entity.customLegend[0].label}}</span>
										</div>
										<div data-ng-if="entity.customLegend.length ==2" class="col-sm-6">
											<span class="legend-value">{{entity.customLegend[1].value}}</span>
											<span class="legend-label">{{entity.customLegend[1].label}}</span>
										</div>
									</div>
							</div>
							<div data-ng-if="entity.type == 'memory'">
									<div class="usage-wrapper">
										<span class="usage-text"><cv:msg key="appliance.system.using" bundle="reports"/>:</span><span class="usage-values">{{ctrl.memoryUsage.used.value}}<span class="usage-unit">{{ctrl.memoryUsage.used.unit}}</span>/{{ctrl.memoryUsage.total.value}}<span class="usage-unit">{{ctrl.memoryUsage.total.unit}}</span></span>
									</div>
							</div>
						</div>

						<cv-reports-show-loader show-loader="ctrl.systemData.showLoader"></cv-reports-show-loader>
						<cv-reports-no-data data-ng-if="ctrl.systemData.noData" no-data="ctrl.systemData.noData"></cv-reports-no-data>
					</div>
				</div>

				<div class="col-lg-6 col-md-6 col-sm-6 no-padding">
					<div class="hardware-content">
						<div class="center sub-title">
							<span><a data-ng-href="{{ctrl.hwData.detailsLink}}">
								<cv:msg key="appliance.hardware.title" bundle="reports" /></a>
							</span>
						</div>

						<table class="hw-comp-table">
							<tr class="hardware-entities" data-ng-repeat="entity in ctrl.hwData.entities">
									<td class="hw-comp-icon">
												<span><img data-ng-src="{{entity.imgSrc}}"/></span>
												<span data-ng-if="entity.offlineCount > 0" class="hardware-red-dot"><img data-ng-src="{{entity.criticalImgSrc}}"/></span>
									</td>
									<td class="hw-comp-name">
												<span class="hardware-name">{{entity.name}}</span>
									</td>
											<td class="hw-comp-status">
												<span data-ng-if="entity.offlineCount == 0"><span><cv:msg key="appliance.hardware.allGood" bundle="reports"/></span>
												</span>
												<span data-ng-if="entity.offlineCount > 0" ><a data-ng-href="{{entity.detailsLink}}" data-ng-bind-html="entity.errorMsg"></a>
												</span>
											</td>
							</tr>
						</table>

						<cv-reports-show-loader show-loader="ctrl.hwData.showLoader"></cv-reports-show-loader>
						<cv-reports-no-data data-ng-if="ctrl.hwData.noData" no-data="ctrl.hwData.noData"></cv-reports-no-data>
					</div>
				</div>
				<div class="clearFloat doc-link" dta-ng-show="ctrl.offlineNotes">
					<span data-ng-bind="ctrl.offlineNotes"></span>
				</div>
			</div>
		</div>
	</div>
