<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.reports">
<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header data-title="reportsHardwareCtrl.data.title"  title-details-link="reportsHardwareCtrl.data.titleDetailsLink">
		</cv-reports-pane-header>
		<div class="dash-pane-content hardware-content">
			<div class="hardware-entities row" data-ng-repeat="entity in reportsHardwareCtrl.data.entities">
					<div class="col-md-1 col-sm-1">
						<span><img data-ng-src="{{entity.imgSrc}}"/></span>
						<span data-ng-if="entity.offlineCount > 0" class="hardware-red-dot"><img data-ng-src="{{entity.criticalImgSrc}}"/></span>
					</div>
					<div class="col-md-5 col-sm-5 hardware-name">
						{{entity.name}}
					</div>
					<div class="col-md-5 col-sm-5 hardware-status">
						<div data-ng-if="entity.offlineCount == 0">
							<span><fmt:message key="appliance.hardware.allGood"></fmt:message></span>
						</div>
						<div data-ng-if="entity.offlineCount > 0" class="row" data-ng-bind-html="entity.errorMsg">
						</div>
					</div>
			</div>
			<cv-reports-show-loader show-loader="reportsHardwareCtrl.data.showLoader"></cv-reports-show-loader>
			<cv-reports-no-data data-ng-if="reportsHardwareCtrl.data.noData" no-data="reportsHardwareCtrl.data.noData"></cv-reports-no-data>
		</div>
	</div>
</div>
</fmt:bundle>