<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.security"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.reports">
<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header title="reportsDiskSpaceCtrl.data.title" title-details-link="reportsDiskSpaceCtrl.data.titleDetailsLink">
		</cv-reports-pane-header>
		<div class="{{reportsDiskSpaceCtrl.customClass}} dash-pane-content disk-space-content">
			<table>
				<thead>
					<tr class="disk-entity-header">
						<th data-ng-if="reportsDiskSpaceCtrl.isCometApp"><cv:msg key="label.commCell" bundle="security" /></th>
						<th>{{reportsDiskSpaceCtrl.diskLibColTitle}}</th>
						<th><fmt:message key="dashboard.diskspace.type"/></th>
						<th><fmt:message key="dashboard.diskspace.totalSpace"/></th>
						<th><fmt:message key="dashboard.diskspace.usedSpace"/></th>
						<th><fmt:message key="dashboard.diskspace.dateFull"/></th>
					</tr>
				</thead>
				<tbody>
					<tr  class="disk-entities" data-ng-repeat="entity in reportsDiskSpaceCtrl.data.entities">
						<td data-ng-click="entity.onClick()" data-ng-if="reportsDiskSpaceCtrl.isCometApp" title="{{entity.commcellName}}"><a data-ng-bind="entity.commcellName"></a></td>
						<td title="{{entity.library}}" data-ng-class='{"more-padding": reportsDiskSpaceCtrl.data.entities.length < 8}'>{{entity.library}} </td>
						<td title="{{entity.type}}">{{entity.type}} </td>
						<td title="{{entity.totalSpace}}">{{entity.totalSpace}} </td>
						<td title="{{entity.usedSpace}}">{{entity.usedSpace}} </td>
						<td title="{{entity.fullDate}}" data-ng-class='{"critical-status": reportsDiskSpaceCtrl.isCriticalStatus(entity.fullStatus), "warning-status": reportsDiskSpaceCtrl.isWarningStatus(entity.fullStatus) }'>{{entity.fullDate}} </td>
					</tr>
				</tbody>
			</table>
			<cv-reports-show-loader show-loader="reportsDiskSpaceCtrl.data.showLoader"></cv-reports-show-loader>
			<cv-reports-no-data data-ng-if="reportsDiskSpaceCtrl.data.noData" no-data="reportsDiskSpaceCtrl.data.noData"></cv-reports-no-data>
		</div>
</div>
</div>
</fmt:bundle>