<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>

<div class="setup-title">
	<h3><cv:msg key="dashboard.security" bundle="reports" /></h3>
</div>

<div class="setup-content security-modal dashboard-security-modal remove-top-padding">
	<span class="server-message {{securityCtrl.serverMessage.type}}" data-ng-bind="securityCtrl.serverMessage.message"></span>

	<div>
		<label class="modal-note"><cv:msg key="dashboard.security.subTitle" bundle="reports"/></label>
	</div>

	<div class="add-users group extra-top-padding margin-left-10">
		<div class="user-and-group-select-wrapper user-suggestion-single-select-wrapper">
			<input id="userList" name="userList" data-ng-model="securityCtrl.user.userOrGroupInfo.userOrGroupInfo" data-ng-change="securityCtrl.userSelectionChanged()" class="add-user-type">
		</div>
		<button data-ng-click="securityCtrl.addNewUserOrGroup()" data-ng-disabled="!securityCtrl.isUserSelected()" class="btn btn-primary"><cv:msg key="Add" bundle="messages" /></button>
	</div>

	<div data-ng-if="securityCtrl.securityAssociations.length > 0">
		<div class="peopleInfos ownerInfo modal-version">
			<div class="users-list limit-modal-height">
				<ul>
					<li class="users-list__user group" data-ng-repeat="user in securityCtrl.securityAssociations track by $index">
						<span class="{{user.cssName}}">
							<label data-id="{{user.entityId}}" class="ellipsis-parent ellipsis-content user"  data-ng-class="{inheritedSecurityAssociation: user.isCreator}" data-ng-bind="user.entityName" title="{{user.entityName}}"></label>
							<span data-ng-if="!user.isCreator" class="k-icon k-i-x delete-row" data-ng-click="securityCtrl.removeUser(user)" title="<cv:msg key='Delete' bundle='messages'/> {{user.entityName}}"> </span>
						</span>
					</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="button-container">
		  <button class="btn btn-default cvBusyOnAjax" data-ng-click="securityCtrl.modalClose()"><cv:msg key="Cancel" bundle="messages" /></button>
		  <button class="btn btn-primary cvBusyOnAjax" data-ng-click="securityCtrl.updateSecurityAssociations()"><cv:msg key="Save" bundle="messages" /></button>
	</div>

</div>

