import 'modules/reports/js/services/reports.svc.js';
import { reportsDashboardModule } from 'common/js/modules';

reportsDashboardModule.factory('reportsDashboardFactory', [
	'$log',
	'$q',
	'cvLoc',
	'cvToaster',
	'reportsDashboardService',
	'DashboardSettings',
	'$uibModal',
	'$compile',
	'settingsService',
	'$window',
	'multiCommcellFactory',
	function reportsDashboardFactory(
		$log,
		$q,
		cvLoc,
		cvToaster,
		reportsDashboardService,
		DashboardSettings,
		$modal,
		$compile,
		settingsService,
		$window,
		multiCommcellFactory
	) {
		var Bytes = 1;
		var KB = 1024;
		var MB = KB * 1024;
		var GB = MB * 1024;
		var TB = GB * 1024;
		var PB = TB * 1024;
		var EB = PB * 1024;
		var THOUSAND = 1000;
		var MILLION = THOUSAND * THOUSAND;
		var BILLION = MILLION * THOUSAND;
		var TRILLION = BILLION * THOUSAND;
		var needsAttentionDetailTabs = {
			SERVERS: {
				title: cvLoc('entity.label.servers'),
				baseUrl: '/needsAttention/servers',
				url: '',
				tabIndex: 0
			},
			INFRASTRUCTURES: {
				title: cvLoc('entity.label.infrastructures'),
				baseUrl: '/needsAttention/infrastructures',
				url: '',
				tabIndex: 1
			},
			JOBS: {
				title: cvLoc('entity.label.jobs'),
				baseUrl: '/needsAttention/jobs',
				url: '',
				tabIndex: 2
			}
		};
		var commUniId;
		var commcellInfo;
		var dashboardType = '';

		var cachedInfo = {};
		var activeDashboardTiles = [];

		var cachedInfo = {};
		const sizeUnits = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
		const countUnits = ['h', 'K', 'M', 'B', 'T', 'Qa', 'Qi']; //Kilo, Million, Billion, Trillion,quadrillion,Quintillion
		const isPureAppliance = cv.csEnvironmentInfo.isApplianceCS || cv.csEnvironmentInfo.isCSWithApplianceNode;
		const isHwMonitoringSupported =
			cv.csEnvironmentInfo.isApplianceCS ||
			cv.csEnvironmentInfo.isCSWithApplianceNode ||
			cv.csEnvironmentInfo.isHwMonitoringSupportedOnAnyNode;

		return {
			getFormattedNumberNA: getFormattedNumberNA,
			getJsonFromDSResult: getJsonFromDSResult,
			autoConvertFromMB: autoConvertFromMB,
			getSizeAndUnits: getSizeAndUnits,
			getCountMinFactor: getCountMinFactor,
			getCountUnitStringFull: getCountUnitStringFull,
			tbToHigher: tbToHigher,
			gbToHigher: gbToHigher,
			autoConvertCount: autoConvertCount,
			createPaneEntitiesInput: createPaneEntitiesInput,
			getDataset: getDataset,
			showSuccessMessage: showSuccessMessage,
			showErrorMessage: showErrorMessage,
			getNeedsAttentionTabs: getNeedsAttentionTabs,
			getMetricsCommUniId: getMetricsCommUniId,
			getCommCellInfo: getCommCellInfo,
			convertDecimalToHex: convertDecimalToHex,
			getDashboardType: getDashboardType,
			setDashboardType: setDashboardType,
			applyDashboardSizeOverrides: applyDashboardSizeOverrides,
			formatBytes,
			formatNumber,
			noDataBuilder,
			getDefaultDashboardTiles,
			displayIndividualCommCellDetails,
			getStorageUsage
		};

		function getFormattedNumberNA(val) {
			if (val == undefined) {
				return '';
			}
			val = val.toString();
			var pattern = /(-?\d+)(\d{3})/;
			while (pattern.test(val)) {
				val = val.replace(pattern, '$1,$2');
			}
			return val;
		}

		function getJsonFromDSResult(result) {
			var columns = [];
			var records = [];
			angular.forEach(result.columns, function(col, i) {
				columns.push(col.name);
			});
			angular.forEach(result.records, function(record, r) {
				var row = {};
				angular.forEach(record, function(val, c) {
					row[columns[c]] = val;
				});
				records.push(row);
			});
			return records;
		}

		function convert(value) {
			var valueStr = value.toString();

			if (valueStr.toLowerCase().indexOf('e') != -1) {
				valueStr = value.toFixed(20);
			} else if (valueStr.indexOf('.') != -1) {
				valueStr = roundNumber(value, 2);
			}

			return valueStr;
		}

		function roundNumber(num, dec) {
			var result = Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
			return result;
		}

		function autoConvertFromMB(val, acceptNegative) {
			var vNeg = false;
			var retval = '';
			if (acceptNegative && val < 0) {
				vNeg = true;
				val = -val;
			}
			if (val < 0) {
				retval = 'N/A';
			} else if (val == 0) {
				retval = '0 Bytes';
			} else if (val < KB) {
				retval = val + ' MB';
			} else if (val < MB) {
				retval = convert(val / KB) + ' GB';
			} else if (val < GB) {
				retval = convert(val / MB) + ' TB';
			} else if (val < TB) {
				retval = convert(val / GB) + ' PB';
			} else {
				retval = convert(val / TB) + ' EB';
			}
			if (vNeg) {
				retval = '-' + retval;
			}
			return retval;
		}

		function getSizeAndUnits(val) {
			var size = {};
			size.value = val;
			var valueStr = val + '';
			var valArr = valueStr.split(' ');
			if (valArr.length > 1) {
				size.value = valArr[0];
				size.unit = valArr[1];
			}
			return size;
		}

		function getCountMinFactor(val) {
			if (val < 99999) {
				return 1;
			}
			if (val < MILLION) {
				return THOUSAND;
			}
			if (val < BILLION) {
				return MILLION;
			}
			if (val < TRILLION) {
				return BILLION;
			}
			return TRILLION;
		}
		function getCountUnitStringFull(val) {
			if (val < 99999) {
				return '';
			}
			if (val < MILLION) {
				return 'Thousands';
			}
			if (val < BILLION) {
				return 'Millions';
			}
			if (val < TRILLION) {
				return 'Billions';
			}
			return 'Trillions';
		}
		function tbToHigher(valInTB) {
			var obj = {};
			obj.value = valInTB;
			obj.units = ' TB';
			if (valInTB > 1024) {
				if (valInTB > 1048576) {
					valInTB = valInTB / 1048576;
					obj.value = valInTB.toFixed(2);
					obj.units = ' EB';
				} else {
					valInTB = valInTB / 1024;
					obj.value = valInTB.toFixed(2);
					obj.units = ' PB';
				}
			}
			obj.value = parseFloat(obj.value).toFixed(2);
			return obj;
		}

		function gbToHigher(valInGB) {
			var obj = {};
			obj.value = valInGB;
			obj.units = ' GB';
			if (valInGB > 1024) {
				valInGB = valInGB / 1024;
				return tbToHigher(valInGB);
			}
			obj.value = parseFloat(obj.value).toFixed(2);
			return obj;
		}

		function autoConvertCount(val) {
			val = cvFormatters.formatNumberToString(val, 0) + '';
			//val = val + '';
			var valArr = val.split(' ');
			var unit = '';
			if (valArr.length > 1) {
				val = valArr[0];
				unit = valArr[1];
			}
			return { value: val, unit: unit };
		}

		/*
		 * Sends the request to fetch the dataset and creates the inputs entities for the pane. The entity
		 * input values are filled up in the entityObject.paneData.entities
		 */
		function createPaneEntitiesInput(entityObject) {
			if (entityObject && entityObject.expectedColumns && entityObject.datasetName) {
				getDataset(entityObject.datasetName)
					.success(function(data) {
						const datasetNameofVms = 'VMSummary';
						const vmType = 'protectedvms';
						const protectedByBackupValidation = 'protectedbybackupvalidation';
						const protectedByBackupValidationAndFailed = 'protectedbybackupvalidationandfailed';
						entityObject.paneData.showLoader = false;
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							data.columns.forEach(function(column, index) {
								var trimmedColumnName = removeSpaces(column.name.toLowerCase());
								var found = entityObject.expectedColumns[trimmedColumnName];
								if (found) {
									let entitySubtitle = {};
									if (entityObject.datasetName === datasetNameofVms && trimmedColumnName === vmType) {
										data.columns.forEach(function(columnInfo, indexValue) {
											if (columnInfo.name === cvLoc('label.severity.warning')) {
												entitySubtitle = {
													name: columnInfo.name,
													value: data.records[0][indexValue]
												};
											}
											if (found.hasSubEntityDetail) {
												let subEntityLink = getSubEntityDetailsLink(found, columnInfo.name);
												if (subEntityLink) {
													entitySubtitle.subEntityHref = subEntityLink;
												}
											}
										});
									}

									//show the protectedByBackupValidationAndFailed field even if its zero, when protectedByBackupValidation is >  0, as we wanted to give entry point to customer to see validation result report (success/failure) always.
									if (
										entityObject.datasetName === datasetNameofVms &&
										trimmedColumnName === protectedByBackupValidationAndFailed
									) {
										data.columns.forEach(function(columnInfo, indexValue) {
											if (_.get(columnInfo, 'name', '').toLowerCase() === protectedByBackupValidation) {
												const protectedByBackupValidationValue = data.records[0][indexValue]
													? data.records[0][indexValue]
													: 0;
												if (protectedByBackupValidationValue > 0) {
													found.includeZeros = true;
												}
											}
										});
									}

									var columnValue = data.records[0][index] ? data.records[0][index] : 0;
									if (columnValue > 0 || !!entityObject.includeZeros || !!found.includeZeros) {
										var entity = createPaneEntityInputs(trimmedColumnName, columnValue, entityObject);
										if (entityObject.datasetName === datasetNameofVms && trimmedColumnName === vmType) {
											entity.change = [entitySubtitle];
										}
										entityObject.paneData.entities ? '' : (entityObject.paneData.entities = []);
										entityObject.paneData.entities.push(entity);
									}
								}
							});
							if (entityObject.paneData.entities.length > 0) {
								entityObject.sort && entityObject.sort();
								entityObject.paneData.entities.splice(entityObject.entitiesToShow || 4);

								if (entityObject.datasetName === datasetNameofVms) {
									let notProtectedTemp = '';
									for (let i = 0; i <= entityObject.paneData.entities.length - 1; i++) {
										if (entityObject.paneData.entities[i].title.value === cvLoc('entity.notprotectedvms.title')) {
											notProtectedTemp = entityObject.paneData.entities[i];
											entityObject.paneData.entities.splice(i, 1);
											entityObject.paneData.entities.push(notProtectedTemp);
											break;
										}
									}
								}
								// Remove the seperator of the last entity
								entityObject.paneData.entities[entityObject.paneData.entities.length - 1].addSeperator = false;
								entityObject.paneData.paneLinks = !!entityObject.getPaneLinks ? entityObject.getPaneLinks() : null;
							} else {
								entityObject.paneData.noData = entityObject.noData;
							}
						} else {
							entityObject.paneData.noData = entityObject.noData;
						}
					})
					.error(function(e) {
						entityObject.paneData.showLoader = false;
						entityObject.paneData.noData = {
							text: entityObject.error
						};
						showErrorMessage(e && e.errorMessage ? e.errorMessage : cvLoc('generic_error'));
					});
			}
		}

		function getSubEntityDetailsLink(columnInfo, columnName) {
			let url = null;
			if (!columnInfo.subEntityLinks) {
				return null;
			}

			columnInfo.subEntityLinks.forEach(function(entity) {
				if (entity.name === columnName) {
					url = entity.href;
					return;
				}
			});

			return url;
		}

		/*
		 * Creates the input entity required for the entityObject.paneData.entities
		 */
		function createPaneEntityInputs(columnName, entityValue, entityObject) {
			return {
				value: entityValue,
				title: {
					value: cvLoc('entity.' + columnName + '.title'),
					placement: entityObject.titlePlacement
				},
				type: entityObject.type,
				imgSrc: !!entityObject.expectedColumns[columnName].getImgSrc
					? entityObject.expectedColumns[columnName].getImgSrc(entityValue)
					: entityObject.expectedColumns[columnName].imgSrc,
				detailsLink: entityObject.expectedColumns[columnName].href,
				addSeperator: true,
				entityClass: entityObject.expectedColumns[columnName].entityClass,
				tooltip: entityObject.expectedColumns[columnName].tooltip
			};
		}

		/*
		 * For the given dataset name, fetches the dataset value
		 */
		function getDataset(datasetName) {
			return reportsDashboardService.getDataset(datasetName);
		}

		function removeSpaces(str) {
			return str.replace(/ /g, '');
		}

		function showSuccessMessage(msg) {
			cvToaster.showSuccessMessage({
				ttl: 10000,
				message: msg
			});
		}

		function showErrorMessage(msg, prefix) {
			if (msg) {
				var msgStr;
				if (angular.isString(msg)) {
					msgStr = msg;
				} else if (angular.isString(msg.errorMessage)) {
					msgStr = msg.errorMessage;
				} else {
					msgStr = cvLoc('generic_error');
				}
				if (prefix) {
					msgStr = prefix + ': ' + msgStr;
				}
				cvToaster.showErrorMessage({
					ttl: 5000,
					message: msgStr
				});
			}
		}

		function getNeedsAttentionTabs() {
			var tabs = {};
			for (var tab in needsAttentionDetailTabs) {
				tabs[tab] = needsAttentionDetailTabs[tab];
				tabs[tab].url = tabs[tab].baseUrl + '?nav={nav}';
			}

			return tabs;
		}

		function getMetricsCommUniId() {
			var deferred = $q.defer();
			if (commUniId > 0) {
				deferred.resolve(commUniId);
			} else {
				reportsDashboardService
					.getMetricsCommUniqId()
					.success(function(data) {
						data = getJsonFromDSResult(data);
						if (data.length > 0) {
							commUniId = data[0].MetricsCommUniqId;
							deferred.resolve(commUniId);
						} else {
							console.log('getMetricsCommUniqId::Received empty commUniId.');
							deferred.resolve(0);
						}
					})
					.error(function(err) {
						console.log('getMetricsCommUniqId::');
						console.log(err);
						deferred.reject(0);
					});
			}
			return deferred.promise;
		}

		function getCommCellInfo() {
			var deferred = $q.defer();
			if (!commcellInfo) {
				reportsDashboardService
					.getCommCellInfo()
					.success(function(data) {
						data = getJsonFromDSResult(data);
						if (data.length > 0) {
							var info = data[0];
							commcellInfo = {};
							commcellInfo.version = info['Version'];
							commcellInfo.ccName = info['CommCellName'];
							commcellInfo.ccId = convertDecimalToHex(info['CommCellID']);
							deferred.resolve(commcellInfo);
						} else {
							console.log('getCommCellInfo::Received empty commcell info.');
							deferred.resolve(null);
						}
					})
					.error(function(err) {
						console.log('getCommCellInfo::');
						console.log(err);
						deferred.reject(err);
					});
			} else {
				deferred.resolve(commcellInfo);
			}
			return deferred.promise;
		}

		function convertDecimalToHex(d, padding) {
			var hex = Number(d).toString(16);
			if (hex == -1) {
				return 'FFFFFFFF';
			}
			padding = typeof padding === 'undefined' || padding === null ? (padding = 2) : padding;
			while (hex.length < padding) {
				hex = '0' + hex;
			}
			return hex.toUpperCase();
		}

		function getDashboardType() {
			return dashboardType;
		}

		function setDashboardType(type) {
			dsahboardType = type;
		}

		function applyDashboardSizeOverrides(tiles, sizeOverrides) {
			if (!sizeOverrides) {
				return;
			}
			angular.forEach(tiles, function(tile) {
				let tileSetting = sizeOverrides[tile.tileType];
				if (tileSetting) {
					angular.forEach(tileSetting, function(prop) {
						tile[prop.name] = prop.value;
					});
				}
			});
		}

		function formatBytes(bytes, decimal = 2) {
			if (bytes === 0) {
				return '0 Bytes';
			}
			const index = Math.floor(Math.log(bytes) / Math.log(KB));
			const convertedVal = parseFloat((bytes / Math.pow(KB, index)).toFixed(decimal));
			return `${convertedVal} ${sizeUnits[index]}`;
		}

		function formatNumber(number, decimal = 2) {
			if (number === undefined || number === null) {
				return 0;
			}
			const ret = number;
			const numStr = new String(number);
			const base = 1000;
			try {
				if (numStr.length > 3) {
					number = parseInt(number);
					if (number !== 0) {
						const countGroup = parseInt(log10(number) / log10(base));
						const countUnitStr = countUnits[countGroup];
						const roundOff = (number / Math.pow(base, countGroup)).toFixed(decimal);
						return roundOff + ' ' + countUnitStr;
					}
				}
			} catch (err) {
				// console.error(err);
			}
			return ret;
		}

		function log10(val) {
			return Math.log(val) / Math.LN10;
		}

		function noDataBuilder(noDataText, link, linkText) {
			return {
				text: noDataText,
				href: {
					href: link ? link : '#',
					text: linkText ? linkText : ''
				}
			};
		}

		function getDefaultDashboardTiles(dashboardId) {
			if (dashboardId === 'hyperscale' && isHwMonitoringSupported) {
				dashboardId = 'hyperscalepure';
			}
			return DashboardSettings.defaultTiles[dashboardId];
		}

		/**
		 * Expects options to be { isCallout: use callout instead of grid [ will be default soon ] columns:
		 * title of each column, perCommcellData: [{ array with list of data, each item is a row commcellName:
		 * this will be used as content of first column rowData: [{ array with the row of items, (excluding
		 * commcellName) value: value of the column link: link to follow for the column target: target of
		 * href, whether to open in new tab or not }] }] }
		 */
		function displayIndividualCommCellDetails(options, scope) {
			if (options.isCallout && scope) {
				scope.options = options;
				// Compile needs
				return $compile(`<div class="perCommcellCallout">
					<div data-ng-bind="isCallout"></div>
					{{isCallout}}
				</div>`)(scope);
			} else {
				return $modal.open({
					templateUrl: appUtil.appRoot + 'modules/reports/partials/reportsCometBreakdown.jsp',
					windowClass: 'small-size',
					controllerAs: 'ctrl',
					controller: [
						'$scope',
						function($scope) {
							$scope.gridOptions = options;
						}
					]
				});
			}
		}

		function getStorageUsage(dashboardType, callback) {
			var diskPromise = reportsDashboardService.getDiskSpaceData(dashboardType, 0); //Disk
			var cloudPromise = reportsDashboardService.getDiskSpaceData(dashboardType, 2); //Cloud
			$q.all([diskPromise, cloudPromise]).then(function(data) {
				callback(data);
			});
		}
	}
]);
export default reportsDashboardModule;
