import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsVsaSla', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsVSASLA.jsp',
		bindToController: {
			slaData: '='
		},
		controller: 'DashboardVSASLAController',
		controllerAs: 'slaCtrl'
	};
});
app.controller('DashboardVSASLAController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'ChartColors',
	'cvToaster',
	function DashboardSLAController(cvLoc, reportsDashboardService, reportsDashboardFactory, ChartColors, cvToaster) {
		var self = this;
		this.$onInit = function() {
			self.docLink =
				'http://documentation.commvault.com/commvault/v11/article?p=features/reports/metrics/health_check_settings.htm#improving_sla';
			self.data = {
				title: cvLoc('sla.title'),
				titleDetailsLink: appUtil.appRoot + '#/reportDetails?name=Recovery Readiness&app=ADMIN_CONSOLE'
			};
			if (!!self.slaData) {
				self.showTitle = self.slaData.showTitle == undefined || self.slaData.showTitle ? true : false;
				self.showRpo = self.slaData.showRpo == undefined || self.slaData.showRpo ? true : false;
				self.showRto = self.slaData.showRto == undefined || self.slaData.showRto ? true : false;
			} else {
				self.showTitle = true;
				self.showRpo = true;
				self.showRto = true;
			}
			self.showBoth = self.showRpo && self.showRto;

			self.href = '#/reportDetails?name=Recovery Readiness&app=ADMIN_CONSOLE';
			if (self.slaData.clientId) {
				self.href += '&input.ClientID=' + self.slaData.clientId;
			}
			if (self.slaData.subclientId) {
				self.href += '&input.SubClientID=' + self.slaData.subclientId;
			}

			var SLA_TYPE = {
				RPO: 1,
				RTO: 2,
				BOTH: 3
			};

			self.getFormattedNumberNA = function(val) {
				return reportsDashboardFactory.getFormattedNumberNA(val);
			};
			if (self.showBoth) {
				getSLAInfo(SLA_TYPE.BOTH);
			} else if (self.showRpo) {
				getSLAInfo(SLA_TYPE.RPO);
			} else if (self.showRto) {
				getSLAInfo(SLA_TYPE.RTO);
			}

			function getSLAInfo(type) {
				self.data.showLoader = true;
				if (self.slaData.dashboardType == 'serverDetails' || self.slaData.dashboardType === 'colletionDetails') {
					reportsDashboardService
						.getVSASLAInfo(self.slaData.clientId, self.slaData.subclientId)
						.success(function(data) {
							onSuccess(data, type);
						})
						.error(function(err) {
							onError(err);
						});
				} else {
					reportsDashboardService
						.getSLAInfo(self.slaData.dashboardType, type)
						.success(function(data) {
							onSuccess(data, type);
						})
						.error(function(err) {
							onError(err);
						});
				}
			}

			function onSuccess(data, type) {
				self.data.showLoader = false;
				//console.log(data);
				data = reportsDashboardFactory.getJsonFromDSResult(data);
				//console.log(data);
				if (data.length > 0) {
					var sla_rpo = {
						protectedClients: 0,
						unprotectedClients: 0
					};
					var sla_rto = {
						protectedClients: 0,
						unprotectedClients: 0
					};

					var weeklySla = {
						protectedClients: 0,
						unprotectedClients: 0
					};

					angular.forEach(data, function(row, r) {
						if (row.SLAStatus == 'MetSLA') {
							if (type == SLA_TYPE.BOTH || type == SLA_TYPE.RPO) {
								sla_rpo.protectedClients = row.RPOCount;
							}
							if (type == SLA_TYPE.BOTH || type == SLA_TYPE.RTO) {
								sla_rto.protectedClients = row.RTOCount;
							}
							//weeklySla.protectedClients = row.LastWeekCount;
						} else if (row.SLAStatus == 'MissedSLA') {
							if (type == SLA_TYPE.BOTH || type == SLA_TYPE.RPO) {
								sla_rpo.unprotectedClients = row.RPOCount;
							}
							if (type == SLA_TYPE.BOTH || type == SLA_TYPE.RTO) {
								sla_rto.unprotectedClients = row.RTOCount;
							}
							//weeklySla.unprotectedClients = row.LastWeekCount;
						}
					});
					if (
						!(
							sla_rpo.protectedClients <= 0 &&
							sla_rpo.unprotectedClients <= 0 &&
							sla_rto.protectedClients <= 0 &&
							sla_rto.unprotectedClients <= 0
						)
					) {
						if (type == SLA_TYPE.BOTH || type == SLA_TYPE.RPO) {
							buildSLAData(SLA_TYPE.RPO, sla_rpo, weeklySla);
						}
						if (type == SLA_TYPE.BOTH || type == SLA_TYPE.RTO) {
							buildSLAData(SLA_TYPE.RTO, sla_rto, weeklySla);
						}
					} else {
						self.noData = { text: cvLoc('sla.msg.no_data_available') };
					}
				} else {
					self.noData = { text: cvLoc('sla.msg.no_data_available') };
				}
			}

			function onError(err) {
				self.data.showLoader = false;
				cvToaster.showErrorMessage({
					message: self.data.title + ': ' + err ? err.errorMessage : cvLoc('generic_error')
				});
				self.noData = { text: cvLoc('dashboard.error.server') };
			}

			function buildSLAData(type, sla, weeklySla) {
				sla = calcSLAPercent(sla);
				weeklySla = calcSLAPercent(weeklySla);
				var diff = sla.slaPercent - weeklySla.slaPercent;
				var slaData = {
					sla: sla,
					weeklySla: weeklySla,
					trend: {
						diff: diff,
						dispVal: Math.abs(diff),
						symbol: diff > 0 ? '+' : diff < 0 ? '-' : ''
					}
				};
				slaData.type = type;
				if (type == SLA_TYPE.RPO) {
					slaData.title = cvLoc('sla.label.rpo').toUpperCase();
				} else {
					slaData.title = cvLoc('sla.label.rto').toUpperCase();
				}
				processData(slaData);
			}
			function calcSLAPercent(data) {
				var slapercent = 0;
				if (data.protectedClients > 0 || data.unprotectedClients > 0) {
					slapercent = parseFloat(
						(data.protectedClients / (data.protectedClients + data.unprotectedClients)) * 100
					).toFixed(2);
					slapercent = Math.floor(slapercent);
				}

				data.slaPercent = slapercent;
				data.failPercent = 100 - slapercent;

				return data;
			}
			function processData(data) {
				var sla = {
					met: {
						name: cvLoc('sla.label.met').toUpperCase(),
						y: data.sla.protectedClients,
						slaPercent: data.sla.slaPercent,
						dispValue: reportsDashboardFactory.getFormattedNumberNA(data.sla.protectedClients),
						cls: 'background-color-success'
					},
					missed: {
						name: cvLoc('sla.label.missed').toUpperCase(),
						y: data.sla.unprotectedClients,
						slaPercent: data.sla.failPercent,
						dispValue: reportsDashboardFactory.getFormattedNumberNA(data.sla.unprotectedClients),
						cls: 'background-color-critical',
						details: true
					}
				};
				var trendClass = data.trend.diff >= 0 ? 'color-success' : 'color-critical';
				var chartData = [];
				chartData.push(sla.met);
				chartData.push(sla.missed);

				var dialColors = [ChartColors.SUCCESS, ChartColors.FAILURE];
				var chartConfig = {
					options: {
						chart: {
							type: 'pie',
							margin: [0, 0, 0, 0],
							spacingTop: 0,
							spacingBottom: 30,
							spacingLeft: 0,
							spacingRight: 0
						},
						tooltip: {
							headerFormat: '',
							useHTML: true,
							style: {
								fontSize: '0.875em'
							},
							formatter: function() {
								return this.point.name + ': <b>' + this.point.dispValue + ' (' + this.point.slaPercent + '%)</b>';
							}
						},
						plotOptions: {
							pie: {
								//startAngle: 0,
								//allowPointSelect: true,
								cursor: 'pointer',
								dataLabels: {
									enabled: false
								},
								showInLegend: true,
								point: {
									events: {
										click: function() {
											if (this.options.details) {
											}
										},
										mouseOver: function(jqEvent) {
											if (this.options.details) {
												this.graphic.element.style.cursor = 'pointer';
											}
										}
									}
								}
							},
							series: {
								states: {
									hover: {
										enabled: false
									}
								}
							}
						},
						legend: {
							enabled: false
						},
						exporting: {
							enabled: false
						},

						colors: dialColors
					},
					title: {
						text: ''
					},
					subtitle: {
						text:
							'<div class="dial-center-wrapper"><div class="dial-center-percent">' +
							sla.met.slaPercent +
							'%</div></div>',
						x: 0,
						y: 52,
						floating: true,
						useHTML: true
					},
					credits: {
						enabled: false
					},

					series: [
						{
							colorByPoint: true,
							animation: true,
							innerSize: '85%',
							data: chartData
						}
					],
					size: {
						width: 110,
						height: 110
					}
				};

				self.entities = self.entities || [];
				self.entities.push({
					type: data.type,
					title: data.title,
					chartConfig: chartConfig,
					data: sla
				});
			}
		};
	}
]);

export default app;
