import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsSystem', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsSystem.jsp',
		bindToController: {
			systemData: '='
		},
		controller: 'DashboardSystemController',
		controllerAs: 'systemCtrl'
	};
});

app.controller('DashboardSystemController', [
	'cvLoc',
	'reportsDashboardService',
	'ChartColors',
	'AnomalyTypes',
	'cvToaster',
	'reportsDashboardFactory',
	function DashboardSystemController(
		cvLoc,
		reportsDashboardService,
		ChartColors,
		AnomalyTypes,
		cvToaster,
		reportsDashboardFactory
	) {
		var self = this;
		this.$onInit = function() {
			self.data = {
				title: cvLoc('appliance.system'),
				titleDetailsLink:
					appUtil.appRoot + '#/reportDetails?name=Infrastructure%20Load&app=ADMIN_CONSOLE&nav=applianceDashboard'
			};

			var COLORCODES = {
				GOOD: ChartColors.SUCCESS,
				WARNING: ChartColors.WARNING,
				CRITICAL: ChartColors.FAILURE
			};

			processData();

			function processData() {
				var anomalyType = 0;
				anomalyType = anomalyType | AnomalyTypes.HighCPUUsage;
				anomalyType = anomalyType | AnomalyTypes.HighMemoryUsage;
				anomalyType = anomalyType | AnomalyTypes.MemoryLeak;

				//testdata
				//				var tempData = {
				//						HighCPUUsageBasedAnomalousCountWarning: 12,
				//						HighCPUUsageBasedAnomalousCountCritical: 4 ,
				//						HighMemoryUsageBasedAnomalousCountWarning: 3,
				//						HighMemoryUsageBasedAnomalousCountCritical:2,
				//						TotalClientsForAnomalyAnalysis: 20
				//				};
				//
				//				var formattedData = formatData(tempData);
				//				drawChart(formattedData.memory, cvLoc("appliance.system.memory"), "memory.svg", "memory");
				//				drawChart(formattedData.cpu, cvLoc("appliance.system.cpu"), "cpu.svg", "cpu");
				//end testdata

				self.data.showLoader = true;
				reportsDashboardService
					.getCPUandMemoryUsage(anomalyType)
					.success(function(data) {
						if (!data || !data.HighMemoryUsage || data.HighMemoryUsage.Total <= 0) {
							self.data.showLoader = false;
							self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
							return;
						}
						if (data.HighMemoryUsage && data.HighMemoryUsage.Total > 0 && data.HighMemoryUsage.TotalDetected <= 0) {
							self.data.showLoader = false;
							self.data.noData = { text: cvLoc('appliance.system.nodes.offiline.msg') };
							return;
						}
						var memoryUsage = { total: { value: 0, unit: 'GB' }, used: { value: 0, unit: 'GB' } };
						if (data.MemoryConsumption) {
							if (data.MemoryConsumption.Total) {
								memoryUsage.total = reportsDashboardFactory.getSizeAndUnits(
									reportsDashboardFactory.autoConvertFromMB(data.MemoryConsumption.Total / 1024)
								);
							}
							if (data.MemoryConsumption.TotalDetected) {
								memoryUsage.used = reportsDashboardFactory.getSizeAndUnits(
									reportsDashboardFactory.autoConvertFromMB(data.MemoryConsumption.TotalDetected / 1024)
								);
							}
						}
						self.memoryUsage = memoryUsage;

						var formattedData = formatData(data);
						drawChart(formattedData.memory, cvLoc('appliance.system.memory'), 'memory.svg', 'memory');
						drawChart(formattedData.cpu, cvLoc('appliance.system.cpu'), 'cpu.svg', 'cpu');

						self.data.showLoader = false;
					})
					.error(function(err) {
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.error.server') };
						reportsDashboardFactory.showErrorMessage(err, self.data.title);
					});
			}

			function formatData(rawData) {
				var data = {};
				data.memory = {
					critical: 0,
					warning: 0,
					good: 0,
					total: 0
				};

				data.cpu = {
					critical: 0,
					warning: 0,
					good: 0,
					total: 0
				};
				if (rawData.HighMemoryUsage) {
					data.memory.total = rawData.HighMemoryUsage.Total;
					if (rawData.HighMemoryUsage.Critical) {
						data.memory.critical = rawData.HighMemoryUsage.Critical;
					}
					if (rawData.HighMemoryUsage.Warning) {
						data.memory.warning = rawData.HighMemoryUsage.Warning;
					}
					data.memory.good = rawData.HighMemoryUsage.TotalDetected - (data.memory.critical + data.memory.warning);
				}
				if (rawData.HighCPUUsage) {
					rawData.HighCPUUsage.TotalDetected = rawData.HighMemoryUsage.TotalDetected;
					data.cpu.total = rawData.HighCPUUsage.Total;
					if (rawData.HighCPUUsage.Critical) {
						data.cpu.critical = rawData.HighCPUUsage.Critical;
					}
					if (rawData.HighCPUUsage.Warning) {
						data.cpu.warning = rawData.HighCPUUsage.Warning;
					}
					data.cpu.good = rawData.HighCPUUsage.TotalDetected - (data.cpu.critical + data.cpu.warning);
				}

				return data;
			}

			function drawChart(data, title, image, type) {
				var chartData = [
					{
						name: cvLoc('appliance.system.good'),
						y: data.good
					},
					{
						name: cvLoc('appliance.system.warning'),
						y: data.warning
					},
					{
						name: cvLoc('appliance.system.critical'),
						y: data.critical
					}
				];

				var dialColors = [COLORCODES['GOOD'], COLORCODES['WARNING'], COLORCODES['CRITICAL']];
				var total = data.good + data.warning + data.critical;

				var chartConfig = {
					options: {
						chart: {
							type: 'pie',
							margin: [0, 0, 0, 0],
							spacingTop: 0,
							spacingBottom: 30,
							spacingLeft: 0,
							spacingRight: 0,
							outlineColor: ''
						},
						tooltip: {
							formatter: function() {
								return this.point.name + ': <b>' + this.point.y + '</b>';
							}
						},
						plotOptions: {
							pie: {
								startAngle: 0,
								allowPointSelect: false,
								cursor: 'pointer',
								dataLabels: {
									enabled: false
								},
								showInLegend: true,
								point: {
									events: {
										click: function() {
											if (this.options.details) {
											}
										}
									}
								}
							},
							series: {
								states: {
									hover: {
										enabled: false
									}
								}
							}
						},
						legend: {
							enabled: false
						},
						exporting: {
							enabled: false
						},

						colors: dialColors
					},
					title: {
						text: ''
					},
					subtitle: {
						text:
							'<div class="dial-center-wrapper"><div class="dial-center-value">' +
							total +
							'</div><div class="dial-center-label">' +
							cvLoc('appliance.system.nodes') +
							'</div></div>',
						x: 0,
						y: 55,
						floating: true,
						useHTML: true
					},
					credits: {
						enabled: false
					},

					series: [
						{
							colorByPoint: true,
							animation: true,
							innerSize: '85%',
							data: chartData
						}
					],
					size: {
						width: 125,
						height: 125
					}
				};

				var customLegend = [];
				if (data.warning > 0) {
					customLegend.push({
						value: data.warning,
						label: cvLoc('appliance.system.warning')
					});
				}

				if (data.critical > 0) {
					customLegend.push({
						value: data.critical,
						label: cvLoc('appliance.system.critical')
					});
				}

				self.data.entities = self.data.entities || [];
				self.data.entities.push({
					type: type,
					title: title,
					imgSrc: appUtil.appRoot + 'common/img/' + image,
					chartConfig: chartConfig,
					customLegend: customLegend
				});

				self.data.customLegend = [];
			}
		};
	}
]);

export default app;
