import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsStorageUsage', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsStorageUsage.jsp',
		bindToController: {
			slaData: '=',
			dashboardType: '='
		},
		controller: 'StorageUsageController',
		controllerAs: 'storageCtrl'
	};
});

app.controller('StorageUsageController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	'multiCommcellFactory',
	function StorageUsageController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster,
		multiCommcellFactory
	) {
		var self = this;
		self.$onInit = function() {
			self.data = {
				title: cvLoc('storageUsage.title'),
				titleDetailsLink: appUtil.appRoot + '#/reportDetails?name=Storage%20Utilization&app=ADMIN_CONSOLE'
			};
			var entitiesInfo = {
				disklibrary: {
					value: 0,
					title: {
						value: cvLoc('entity.label.diskLibrary').toUpperCase(),
						placement: 'top'
					},
					type: PaneEntityTypes.OVERVIEW,
					addSeperator: true,
					entityClass: 'storageUsage-entity',
					detailsLink: '#/reportDetails?name=Storage%20Utilization&app=ADMIN_CONSOLE',
					tooltip: cvLoc('entity.disklibrary.tooltip')
				},
				spacereduction: {
					value: 0,
					unit: '%',
					title: {
						value: cvLoc('entity.label.spaceReduction').toUpperCase(),
						placement: 'top'
					},
					type: PaneEntityTypes.OVERVIEW,
					addSeperator: false,
					entityClass: 'storageUsage-entity',
					detailsLink: '#/reportDetails?name=Storage%20Utilization&app=ADMIN_CONSOLE',
					tooltip: cvLoc('entity.space.reduction.tooltip')
				}
			};
			processDiskSpace();

			function removeDuplicates(data) {
				// CCTotalDataWrittenGB and CCTotalSavingsPercentage return summed data and not row wise data
				return _.uniqBy(data, 'Data Source');
			}

			function processDiskSpace() {
				self.data.showLoader = true;
				reportsDashboardService
					.getDiskSpaceData(self.dashboardType, 0)
					.then(function(data) {
						if (data) {
							data = data.data;
						}
						self.data.showLoader = false;
						data = reportsDashboardFactory.getJsonFromDSResult(data);

						if (data.length > 0) {
							let row = {};
							if (cv.isCometApp) {
								data = removeDuplicates(data);
								let totalData = _.reduce(_.map(data, 'CCTotalDataWrittenGB'), (sum, current) => sum + current);
								row = {
									CCTotalDataWrittenGB: totalData,
									// Removing negative space savings value
									CCTotalSavingsPercentage: _.max([
										_.round(
											_.reduce(
												data,
												(sum, current) => sum + current['CCTotalSavingsPercentage'] * current['CCTotalDataWrittenGB'],
												0
											) / totalData,
											2
										),
										0
									])
								};
							} else {
								row = data[0];
							}
							var disk = reportsDashboardFactory.autoConvertFromMB(row['CCTotalDataWrittenGB'] * 1024);
							var diskSizeObj = reportsDashboardFactory.getSizeAndUnits(disk);
							entitiesInfo.disklibrary.value = reportsDashboardFactory.getFormattedNumberNA(diskSizeObj.value);
							entitiesInfo.disklibrary.unit = diskSizeObj.unit;
							entitiesInfo.spacereduction.value = reportsDashboardFactory.getFormattedNumberNA(
								row['CCTotalSavingsPercentage']
							);
							self.data.entities = [entitiesInfo.disklibrary, entitiesInfo.spacereduction];

							if (cv.isCometApp) {
								self.calloutTemplate = appUtil.appRoot + 'modules/reports/partials/perDashboardCallout.jsp';
								_.each(data, row => {
									row.commcellName = row['Data Source'];
									row.commcellLink = cvUtil.modifyUrlForComet('#/dashboard/commcell', row.commcellName);
									row.spacereduction =
										reportsDashboardFactory.getFormattedNumberNA(row['CCTotalSavingsPercentage']) + ' %';
									let disk = reportsDashboardFactory.autoConvertFromMB(row['CCTotalDataWrittenGB'] * 1024);
									let diskSizeObj = reportsDashboardFactory.getSizeAndUnits(disk);
									row.disklibrary = diskSizeObj.value + ' ' + diskSizeObj.unit;
									row.rawValues = {
										disklibrary: row['CCTotalDataWrittenGB'] || 0,
										spacereduction: Math.max(row['CCTotalSavingsPercentage'] || 0, 0)
									};
									row.target = '_blank';
									row.diskLibraryLink = cvUtil.modifyUrlForComet(
										entitiesInfo.disklibrary.detailsLink,
										row.commcellName
									);
									row.spacereductionLink = cvUtil.modifyUrlForComet(
										entitiesInfo.spacereduction.detailsLink,
										row.commcellName
									);

									_.forEach(entitiesInfo, (entity, key) => {
										if (!entity.breakDown) {
											entity.breakDown = {
												isCallout: true,
												perCommcellData: []
											};
										}
										let rawValueData = row.rawValues[key];
										let clickFunction = multiCommcellFactory.redirectToCommcell;
										entity.breakDown.perCommcellData.push({
											commcellName: row.commcellName,
											rowData: [
												{
													columnName: key,
													value: row[key],
													rawValue: rawValueData,
													styledValue: true,
													link: cvUtil.modifyUrlForComet(entity.detailsLink, row.commcellName),
													target: '_blank'
												}
											],
											visible: rawValueData > 0,
											clickFunction
										});
										// sort comet breakdown data
										if (entity.breakDown) {
											_.set(
												entity.breakDown,
												'perCommcellData',
												_.orderBy(
													_.get(entity.breakDown, 'perCommcellData', []),
													['rowData[0].rawValue', 'commcellName'],
													['desc', 'asc']
												)
											);
											// If all rows are not visible set a new property noVisibleRows
											let countOfHiddenRows = _.countBy(entity.breakDown.perCommcellData, 'visible').false;
											if (
												entity.breakDown.perCommcellData &&
												countOfHiddenRows == entity.breakDown.perCommcellData.length
											) {
												_.set(entity.breakDown.perCommcellData, 'noVisibleRows', true);
											}
										}
									});
								});
								entitiesInfo.disklibrary.detailsLink = undefined;
								entitiesInfo.spacereduction.detailsLink = undefined;
							}
						} else {
							self.data.paneClass = 'overview-storage';
							self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						}
					})
					.catch(function(err) {
						if (err.xhrStatus !== 'abort') {
							self.data.showLoader = false;
							cvToaster.showErrorMessage({
								message: self.data.title + ': ' + err.errorMessage
							});
							self.data.paneClass = 'overview-storage';
							self.data.noData = { text: cvLoc('dashboard.error.server') };
						}
						console.log(err);
					});
			}
		};

		self.entityClicked = () => {
			if (cv.isCometApp) {
				reportsDashboardFactory.displayIndividualCommCellDetails(self.gridOptions);
			}
		};
	}
]);

export default app;
