//cv-reports-site-replication-directive.js
import 'modules/reports/js/directives/cv-reports-no-data-directive.js';

import { reportsDashboardModule } from 'common/js/modules';

reportsDashboardModule.directive('cvReportsSiteReplication', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsSiteReplication.jsp',
		require: [],
		bindToController: {
			dashboardId: '='
		},
		controller: 'reportsSiteReplicationController',
		controllerAs: 'siteRepCtrl'
	};
});

reportsDashboardModule.controller('reportsSiteReplicationController', [
	'reportsDashboardFactory',
	'cvLoc',
	'reportsDashboardService',
	function(reportsDashboardFactory, cvLoc, reportsDashboardService) {
		var self = this;

		self.$onInit = function() {
			self.siteReplication = {
				title: cvLoc('dashboard.largestHypervisors'),
				classes: ['col-md-3', 'col-md-3', 'col-md-3', 'col-md-3'],
				showLoader: true,
				expectedColumns: {
					sourcehypervisor: {
						index: -1
					},
					destinationhypervisor: {
						index: -1
					},
					replicatedvms: {
						index: -1
					},
					drvms: {
						index: -1
					},
					sourceclientid: {
						index: -1
					},
					destinationclientid: {
						index: -1
					},
					destinationtargetid: {
						index: -1
					},
					destinationtarget: {
						index: -1
					}
				},
				data: {
					headers: [
						cvLoc('label.sourceHypervisor'),
						cvLoc('label.destHypervisor'),
						cvLoc('entity.replicatedvms.title'),
						cvLoc('label.VMsonDr')
					],
					rows: [] // rows are filled up in the createSiteReplicationInputs function
				}
			};
			_createSiteReplicationInputs(self.dashboardId, self.siteReplication);

			function _createSiteReplicationInputs(dashboardId, entityObject) {
				reportsDashboardService
					.getSiteReplicationData(dashboardId)
					.then(function(data) {
						entityObject.showLoader = false;
						if (data) {
							data = data.data;
						}
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							data.columns.forEach(function(column, index) {
								let trimmedColumnName = column.name.replace(/ /g, '').toLowerCase();
								let found = entityObject.expectedColumns[trimmedColumnName];
								if (found) {
									entityObject.expectedColumns[trimmedColumnName].index = index;
								}
							});

							// Fetch the data for each column and fill it in the entityObject.data.rows
							let expectedColumns = entityObject.expectedColumns;
							data.records.forEach(function(record) {
								let row = [];
								row.push(
									{
										value: record[expectedColumns['sourcehypervisor'].index],
										href: '#/servers/' + record[expectedColumns['sourceclientid'].index]
									},
									{
										value:
											record[expectedColumns['destinationhypervisor'].index] === null
												? record[expectedColumns['destinationtarget'].index]
												: record[expectedColumns['destinationhypervisor'].index],
										href:
											record[expectedColumns['destinationclientid'].index] === null
												? '#/lifeCyclePolicyDetails/' + record[expectedColumns['destinationtargetid'].index]
												: '#/servers/' + record[expectedColumns['destinationclientid'].index]
									},
									{
										value: record[expectedColumns['replicatedvms'].index]
									},
									{
										value: record[expectedColumns['drvms'].index]
									}
								);
								entityObject.data.rows.push(row);
							});
						} else if (_.get(data, 'errorMessage')) {
							entityObject.noData = { text: data.errorMessage };
						} else {
							entityObject.noData = { text: cvLoc('noData.noSiteReplication') };
						}
					})
					.catch(function(e) {
						entityObject.showLoader = false;
						entityObject.noData = {
							text: cvLoc('error.siteReplication')
						};
						reportsDashboardFactory.showErrorMessage(e && e.errorMessage ? e.errorMessage : null);
					});
			}
		};
	}
]);

export default reportsDashboardModule;
