import 'modules/reports/js/directives/cv-reports-no-data-directive.js';

import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/directives/cv-reports-no-data-directive.js';
import 'modules/reports/js/factory/reports.factory.js';

/**
 * Shows the list of entities for the Dashboard report pane
 *
 * Usage <br>
 * ======<br>
 * <p>
 * Provide an entities input that has the following structure
 * </p>
 *
 * <code>
 * var entities = [array of entity]
 * var entity = {
 * 	value: 10, // integer input
 *  title: stringTitle || objectTitle, // See definition below
 *  type: PaneEntityTypes.EVENT,    // For the list of supported entities see paneEntityTypes.constants.js
 *  imgSrc: 'reports/input/img.png', // Provide the path of the image.
 *  svgSrc: BLR_SVG_CONSTANTS.TOTAL_PAIRS,//Provide a string with svg data (either imgSrc or svgSrc can be provided)
 *  change: [array of change], // Shows the changes at the bottom of the screen. See definition of change below
 *  addSeperator: true | false, // Adds a seperator between entities.
 *  entityClass: 'cssClass',	// The cssClass that has to be applied to each entity
 *  detailsLink: '#',	// The hyperlink for each entity
 *  noData: {}	// shown if no data is available. See cv-reports-no-data-directive.js for usage
 * }
 *
 *
 * var stringTitle = "Entity Title"
 * var objectTitle: { // Object input of title to handle additional parameters
 * 	value: 'Entity Title',
 * 	placement: 'top' || 'bottom' // Default - bottom
 * }
 *
 * var change = { name: 'DAY', change: 'increase', // valid values: increase / decrease value: 2 }
 * </code>
 * <p>
 * Notes: - Based on the number of entities, the entities are automatically distributed in the available
 * space. - Colours and fonts to be shown are based on the entity type
 * </p>
 */

reportsDashboardModule.directive('cvReportsPaneEntity', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsPaneEntity.jsp',
		require: [],
		bindToController: {
			entities: '=',
			showDataLoader: '=?',
			paneData: '=?'
		},
		controller: 'reportsPaneEntityController',
		controllerAs: 'reportsPaneEntityCtrl'
	};
});

reportsDashboardModule.controller('reportsPaneEntityController', [
	'cvLoc',
	'$sce',
	'reportsDashboardFactory',
	function(cvLoc, $sce, reportsDashboardFactory) {
		var self = this;
		this.$onInit = function() {
			if (!!self.entities) {
				var count = self.entities.length;
				var notesEntity,
					notesEntityIndex = -1;
				angular.forEach(self.entities, function(entity, i) {
					if (entity.svgSrc) {
						entity.svgTrusted = $sce.trustAsHtml(entity.svgSrc);
					}

					entity.hasImage = entity.svgSrc || entity.imgSrc;

					if (!!entity.type && !!entity.type.isNotesEntity) {
						notesEntity = entity;
						count--;
						notesEntityIndex = i;
						return;
					}

					// sort comet breakdown data
					if (entity.breakDown) {
						_.set(
							entity.breakDown,
							'perCommcellData',
							_.orderBy(
								_.get(entity.breakDown, 'perCommcellData', []),
								['rowData[0].value', 'commcellName'],
								['desc', 'asc']
							)
						);
						// If all rows are not visible set a new property noVisibleRows
						let countOfHiddenRows = _.countBy(entity.breakDown.perCommcellData, 'visible').false;
						if (entity.breakDown.perCommcellData && countOfHiddenRows == entity.breakDown.perCommcellData.length) {
							_.set(entity.breakDown.perCommcellData, 'noVisibleRows', true);
						}
					}
				});

				if (!!notesEntity && notesEntityIndex >= 0) {
					self.entities.splice(notesEntityIndex, 1);
					self.notesEntity = notesEntity;
				}

				if (count == 2) {
					self.entityColClass = 'col-lg-6 col-md-6 col-sm-6 col-xs-6';
				} else if (count == 3) {
					self.entityColClass = 'col-lg-4 col-md-4 col-sm-4 col-xs-4';
				} else if (count == 4) {
					self.entityColClass = 'col-lg-3 col-md-3 col-sm-6 col-xs-6';
				} else if (count == 6) {
					self.entityColClass = 'col-lg-2 col-md-4 col-sm-6 col-xs-6';
				} else {
					self.width = (1 / self.entities.length) * 100 + '%';
				}
				self.calloutTemplate = appUtil.appRoot + 'modules/reports/partials/perDashboardCallout.jsp';
			}
		};

		this.openModal = function() {
			reportsDashboardFactory.displayIndividualCommCellDetails(this.paneData.gridOptions);
		};
	}
]);

export default reportsDashboardModule;
