import { reportsDashboardModule } from 'common/js/modules';

/**
 * Creates a no data found pane
 *
 * Usage <br>
 * ========= <br>
 *
 * <code>
 * var noData: {
 * 		text: '', // Text to display if no data is available
 * 		href: {
 * 			href: '#',	// Link to go to if no data is available
 * 			text: ''	// Text to display for the link
 * 		}
 *  }
 * <code>
 *
 */

reportsDashboardModule.directive('cvReportsNoData', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsNoData.jsp',
		require: [],
		bindToController: {
			noData: '='
		},
		controller: 'reportsNoDataController',
		controllerAs: 'noDataCtrl'
	};
});

reportsDashboardModule.controller('reportsNoDataController', [
	'cvLoc',
	function(cvLoc) {
		var self = this;
	}
]);

export default reportsDashboardModule;
