import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsLastnJobsStats', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<cv-reports-pane pane-data="LastNJobsStatsCtrl.paneData" class="lastn-jobs-content"></cv-reports-pane>`,
		require: [],
		bindToController: {
			dashboardType: '=',
			serverGroupId: '='
		},
		controller: 'LastNJobsStatsController',
		controllerAs: 'LastNJobsStatsCtrl'
	};
});
app.controller('LastNJobsStatsController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	'multiCommcellFactory',
	function LastNJobsStatsController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster,
		multiCommcellFactory
	) {
		var self = this;
		this.$onInit = function() {
			self.paneData = {
				title: cvLoc('dashboard.lastDayJobs'),
				contentClass: 'overview-lastNjobs'
			};
			const upIcon = appUtil.appRoot + 'common/img/arrow-up.svg';
			const downIcon = appUtil.appRoot + 'common/img/arrow-down.svg';
			const anomalyCriteria = {
				failed: 96,
				completed: 102
			};

			var activeJobsUrl = '#/activeJobs';
			var completedJobsUrl = '#/jobs?showAdminJobs=true&status=Completed';
			var cweJobsUrl =
				'#/jobs?showAdminJobs=true&status=Completed%20w%2F%20one%20or%20more%20warnings,Completed%20w%2F%20one%20or%20more%20errors';
			var cwwJobsUrl =
				'#/jobs?showAdminJobs=true&status=Completed%20w%2F%20one%20or%20more%20warnings,Completed%20w%2F%20one%20or%20more%20errors';
			var cwewJobsUrl =
				'#/jobs?showAdminJobs=true&status=Completed%20w%2F%20one%20or%20more%20warnings,Completed%20w%2F%20one%20or%20more%20errors';
			var failedJobsUrl = '#/jobs?showAdminJobs=true&status=Failed,Failed%20to%20Start';
			var drDashboardCompletedJobs =
				'#/jobs?jobType=126,105,135&view=finishedJobs&status=Completed,Completed%20w%2F%20one%20or%20more%20errors&showAdminJobs=true';
			var drDashboardFailedJobs = '#/jobs?jobType=126,105,135&view=finishedJobs&status=Failed&showAdminJobs=true';
			var drCweewJobsUrl =
				'#/jobs?jobType=126,105,135&showAdminJobs=true&status=Completed%20w%2F%20one%20or%20more%20warnings';

			if (self.dashboardType == 'virtualization') {
				var vsaParam = 'applicationId=106';
				activeJobsUrl += '?' + vsaParam;
				completedJobsUrl += '&' + vsaParam;
				failedJobsUrl += '&' + vsaParam;
				cweJobsUrl += '&' + vsaParam;
				cwwJobsUrl += '&' + vsaParam;
				cwewJobsUrl += '&' + vsaParam;
			}

			if (self.dashboardType == 'endpoint') {
				var endpointParam = 'view=laptopJobs';
				activeJobsUrl += '?' + endpointParam;
				completedJobsUrl += '&' + endpointParam;
				failedJobsUrl += '&' + endpointParam;
				cweJobsUrl += '&' + endpointParam;
				cwwJobsUrl += '&' + endpointParam;
				cwewJobsUrl += '&' + endpointParam;
			}

			var entityMetaInfo = {
				running: getEntityObj(
					cvLoc('entity.label.running'),
					false,
					true,
					'runningJobs.svg',
					activeJobsUrl,
					cvLoc('last24hrs.running.tooltip')
				),
				completed: getEntityObj(
					cvLoc('entity.label.success'),
					true,
					true,
					'successfulJobs.svg',
					self.dashboardType === 'Replication' ? drDashboardCompletedJobs : completedJobsUrl,
					cvLoc('last24hrs.success.tooltip')
				),
				cwe: getEntityObj(
					cvLoc('entity.label.cwe'),
					true,
					true,
					'successfulJobs.svg',
					cweJobsUrl,
					cvLoc('last24hrs.cwe.tooltip')
				),
				cww: getEntityObj(
					cvLoc('entity.label.cww'),
					true,
					true,
					'successfulJobs.svg',
					cwwJobsUrl,
					cvLoc('last24hrs.cww.tooltip')
				),
				cwew: getEntityObj(
					cvLoc('entity.label.cwew'),
					true,
					true,
					'successfulJobs.svg',
					self.dashboardType === 'Replication' ? drCweewJobsUrl : cwewJobsUrl,
					cvLoc('last24hrs.cwew.tooltip')
				),
				failed: getEntityObj(
					cvLoc('entity.label.failed'),
					true,
					true,
					'failedJobs.svg',
					self.dashboardType === 'Replication' ? drDashboardFailedJobs : failedJobsUrl,
					cvLoc('last24hrs.failed.tooltip')
				),
				events: getEntityObj(
					cvLoc('entity.label.events'),
					false,
					false,
					'events.svg',
					'#/events?view=anomalous-events',
					cvLoc('last24hrs.events.tooltip')
				)
			};

			getLast24HrsStats();

			function getEntityObj(title, showTrend, addSeperator, icon, detailsLink, tooltip) {
				return {
					title: {
						value: title.toUpperCase(),
						placement: 'top'
					},
					type: PaneEntityTypes.OVERVIEW,
					value: 0,
					showTrend: showTrend,
					addSeperator: addSeperator,
					//imgSrc: appUtil.appRoot + 'common/img/'+icon,
					entityClass: 'lastNjobs-entity',
					detailsLink: detailsLink,
					tooltip: tooltip
				};
			}

			function getLast24HrsStats() {
				self.paneData.showLoader = true;
				reportsDashboardService
					.getLast24HrsStats(self.dashboardType === 'Replication' ? 'Replication' : self.dashboardType)
					.success(function(data) {
						if (cv.isAdmin && self.dashboardType == 'commcell') {
							reportsDashboardService
								.getJobsAnomalyData(self.dashboardType)
								.success(function(anomalyData) {
									if (cv.isCometApp && anomalyData.cometAnomalousList && anomalyData.cometAnomalousList.length) {
										let anomalies = {
											failed: [],
											completed: []
										};
										_.forEach(anomalyData.cometAnomalousList, commcellData => {
											_.forEach(commcellData.anomalousList, anomaly => {
												if (anomaly.criteria == anomalyCriteria.failed) {
													// FAILED
													anomalies.failed.push({
														commcell: commcellData.commcell,
														anomaly
													});
												} else if (anomaly.criteria == anomalyCriteria.completed) {
													// COMPLETED
													anomalies.completed.push({
														commcell: commcellData.commcell,
														anomaly
													});
												}
											});
										});
										const clickFunction = reportsDashboardFactory.redirectToCommcell;
										const target = cv.cometTarget;
										if (anomalies.failed.length) {
											entityMetaInfo.failed.anomaly = {
												currentCount: anomalies.failed.length,
												imgSrc: upIcon,
												lastHourText: cvLoc('anomaly.label.commcells'),
												text: '',
												breakDown: {
													perCommcellData: _.map(anomalies.failed, anomalyData => {
														const anomaly = anomalyData.anomaly;
														return {
															commcellName: anomalyData.commcell.commCellName,
															singleRowLink: true,
															commcellColumnName: cvLoc('label.commcell'),
															rowData: [
																{
																	columnName: cvLoc('anomaly.label.current'),
																	value: anomaly.currentCount,
																	link: cvUtil.modifyUrlForComet(
																		entityMetaInfo.failed.detailsLink,
																		anomalyData.commcell.commCellName
																	),
																	target
																},
																{
																	columnName: cvLoc('anomaly.label.expected'),
																	value: anomaly.expectedCount
																}
															],
															clickFunction
														};
													})
												}
											};
										}
										if (anomalies.completed.length) {
											entityMetaInfo.completed.anomaly = {
												currentCount: anomalies.completed.length,
												imgSrc: downIcon,
												lastHourText: cvLoc('anomaly.label.commcells'),
												text: '',
												breakDown: {
													perCommcellData: _.map(anomalies.completed, anomalyData => {
														const anomaly = anomalyData.anomaly;
														return {
															commcellName: anomalyData.commcell.commCellName,
															singleRowLink: true,
															commcellColumnName: cvLoc('label.commcell'),
															rowData: [
																{
																	columnName: cvLoc('anomaly.label.current'),
																	value: anomaly.currentCount,
																	link: cvUtil.modifyUrlForComet(
																		entityMetaInfo.completed.detailsLink,
																		anomalyData.commcell.commCellName
																	),
																	target
																},
																{
																	columnName: cvLoc('anomaly.label.expected'),
																	value: anomaly.expectedCount
																}
															],
															clickFunction
														};
													})
												}
											};
										}
									} else {
										if (anomalyData.anomalousList && anomalyData.anomalousList.length > 0) {
											_.forEach(anomalyData.anomalousList, function(anomaly, i) {
												var urlParams =
													'&input.fromTime=' +
													anomaly.fromTime +
													'&input.toTime=' +
													anomaly.toTime +
													'&input.threshold=' +
													anomaly.threshold +
													'&app=ADMIN_CONSOLE';
												anomaly.percentChange = anomaly.percentChange || -100;
												if (anomaly.criteria == anomalyCriteria.failed) {
													//Failed
													entityMetaInfo.failed.anomaly = {
														percentChange: anomaly.percentChange,
														currentCount: anomaly.currentCount,
														lastHourText: cvLoc('anomaly.label.last.hour.note'),
														text: cvLoc('anomaly.label.failed.note', anomaly.expectedCount),
														imgSrc: upIcon,
														detailsLink:
															appUtil.appRoot +
															'#/reportDetails?name=Unusual%20number%20of%20failed%20jobs&input.failedJobs=' +
															anomaly.currentCount +
															urlParams
													};
													entityMetaInfo.failed.tooltip = cvLoc('last24hrs.failed.anomaly.tooltip');
												} else if (anomaly.criteria == anomalyCriteria.completed) {
													//Success
													entityMetaInfo.completed.anomaly = {
														percentChange: anomaly.percentChange,
														currentCount: anomaly.currentCount,
														lastHourText: cvLoc('anomaly.label.last.hour.note'),
														text: cvLoc('anomaly.label.success.note', anomaly.expectedCount),
														imgSrc: downIcon,
														detailsLink:
															appUtil.appRoot +
															'#/reportDetails?name=Unusual%20number%20of%20succeeded%20jobs&input.succeededJobs=' +
															anomaly.currentCount +
															urlParams
													};
													entityMetaInfo.completed.tooltip = cvLoc('last24hrs.success.anomaly.tooltip');
												}
											});
										}
									}
									entityMetaInfo.failed.showTrend = !entityMetaInfo.failed.anomaly;
									entityMetaInfo.completed.showTrend = !entityMetaInfo.completed.anomaly;
									processData(reportsDashboardFactory.getJsonFromDSResult(data));
								})
								.error(function(err) {
									self.paneData.showLoader = false;
									cvToaster.showErrorMessage({
										message: 'Jobs anomaly: ' + (err.errorMessage ? err.errorMessage : err)
									});
									processData(reportsDashboardFactory.getJsonFromDSResult(data));
								});
						} else {
							processData(reportsDashboardFactory.getJsonFromDSResult(data));
						}
					})
					.error(function(err) {
						console.log(err);
						self.paneData.showLoader = false;
						reportsDashboardFactory.showErrorMessage(err, self.paneData.title);
						self.paneData.paneClass = 'overview-jobs';
						self.paneData.noData = { text: cvLoc('dashboard.error.server') };
					});
			}

			const cometImplementedPages = [];
			function getDetailsLink(entity, row) {
				if (cometImplementedPages.includes(row.Name.toLowerCase())) {
					return entity.detailsLink;
				}
				return cvUtil.modifyUrlForComet(entity.detailsLink, row['Data Source']);
			}

			function processData(data) {
				angular.forEach(data, function(row, i) {
					if (!entityMetaInfo[row.Name.toLowerCase()]) {
						return;
					}
					var entity = entityMetaInfo[row.Name.toLowerCase()];
					if (cv.isCometApp && row['Data Source'] != 'comet') {
						if (!entity.breakDown) {
							entity.breakDown = {
								perCommcellData: [],
								isCallout: true
							};
						}
						let target = cv.cometTarget;
						let clickFunction = multiCommcellFactory.redirectToCommcell;
						entity.breakDown.perCommcellData.push({
							commcellName: row['Data Source'],
							rowData: [
								{
									columnName: row.Name,
									value: row.CurrentCount,
									link: getDetailsLink(entity, row),
									target
								}
							],
							clickFunction
						});
						if (row.Name.toLowerCase() == 'cwe' || row.Name.toLowerCase() == 'cww') {
							if (!entityMetaInfo.cwew.breakDown) {
								entityMetaInfo.cwew.breakDown = {
									perCommcellData: [],
									isCallout: true
								};
							}
							let ccData = entityMetaInfo.cwew.breakDown.perCommcellData.find(
								x => x.commcellName == row['Data Source']
							);
							if (ccData) {
								ccData.rowData[0].value =
									parseInt(ccData.rowData[0].value) + parseInt(row.CurrentCount ? row.CurrentCount : 0);
							} else {
								entityMetaInfo.cwew.breakDown.perCommcellData.push({
									commcellName: row['Data Source'],
									rowData: [
										{
											columnName: row.Name,
											value: parseInt(row.CurrentCount ? row.CurrentCount : 0),
											link: getDetailsLink(entity, row),
											target
										}
									],
									clickFunction
								});
							}
						}
					} else {
						entity.value = row.CurrentCount ? reportsDashboardFactory.getFormattedNumberNA(row.CurrentCount) : 0;
						entity.currentCount = row.CurrentCount;
						if (entity.showTrend) {
							entity.change = [
								{
									name: cvLoc('dashboard.label.trend.day').toUpperCase(),
									value: reportsDashboardFactory.getFormattedNumberNA(Math.abs(row.CurrentCount - row.Yesterday)),
									changeVal: row.Yesterday,
									change: row.CurrentCount - row.Yesterday < 0 ? 'decrease' : 'increase'
								},
								{
									name: cvLoc('dashboard.label.trend.week').toUpperCase(),
									value: reportsDashboardFactory.getFormattedNumberNA(Math.abs(row.CurrentCount - row.Lastweek)),
									changeVal: row.Lastweek,
									change: row.CurrentCount - row.Lastweek < 0 ? 'decrease' : 'increase'
								}
							];
						}
					}
				});

				//Start - populate CWE/CWW data from individuals
				var totalCwew = parseInt(entityMetaInfo.cwe.currentCount) + parseInt(entityMetaInfo.cww.currentCount);
				entityMetaInfo.cwew.value = reportsDashboardFactory.getFormattedNumberNA(totalCwew);
				var cwewDayChange =
					totalCwew -
					(parseInt(entityMetaInfo.cwe.change[0].changeVal) + parseInt(entityMetaInfo.cww.change[0].changeVal));
				var cwewWeekChange =
					totalCwew -
					(parseInt(entityMetaInfo.cwe.change[1].changeVal) + parseInt(entityMetaInfo.cww.change[1].changeVal));
				entityMetaInfo.cwew.change = [
					{
						name: cvLoc('dashboard.label.trend.day').toUpperCase(),
						value: reportsDashboardFactory.getFormattedNumberNA(Math.abs(cwewDayChange)),
						change: cwewDayChange < 0 ? 'decrease' : 'increase'
					},
					{
						name: cvLoc('dashboard.label.trend.week').toUpperCase(),
						value: reportsDashboardFactory.getFormattedNumberNA(Math.abs(cwewWeekChange)),
						change: cwewWeekChange < 0 ? 'decrease' : 'increase'
					}
				];
				//End - populate CWE/CWW data from individuals

				var entities = [];
				entities.push(entityMetaInfo.running);
				entities.push(entityMetaInfo.completed);
				entities.push(entityMetaInfo.cwew);
				entities.push(entityMetaInfo.failed);
				entities.push(entityMetaInfo.events);
				self.paneData.showLoader = false;
				self.paneData.entities = entities;
			}
		};
	}
]);
