import 'modules/reports/js/directives/cv-reports-no-data-directive.js';

import { reportsDashboardModule } from 'common/js/modules';

/**
 * <p>
 * A directive to show the largest-x component
 * </p>
 * 
 * <p>
 * Eg:See the virtualizationDashboard.ctrl.js largestHypervisors for example usage
 * </p>
 * 
 * Usage <br>
 * ========= <br>
 * 
 * <p>
 * Provide an object input with the below structure
 * </p>
 * 
 * <code>
 * var x = {
 	title: '', // title for the pane
 	classes: ''
 * 	data = {
 * 		headers = [header],	// comma seperated list of values
 * 		rows = [columns]	//
 * 	}
 * }
 *
 * var rows = [column] // comma seperated list of values
 * var column = {
 *	value: '', // value to display for the column
 *  href: ''	// href to apply for each column
 * }
 *
 * </code>
 */

reportsDashboardModule.directive('cvReportsLargestX', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsLargestX.jsp',
		require: [],
		controller: 'reportsLargestXController',
		controllerAs: 'largestCtrl'
	};
});

reportsDashboardModule.controller('reportsLargestXController', [
	'reportsDashboardFactory',
	'cvLoc',
	function(reportsDashboardFactory, cvLoc) {
		var self = this;
		const virtualizationPage = '#/virtualization/hypervisors';

		self.$onInit = function() {
			self.largestHypervisors = {
				datasetName: 'LargestHypervisor',
				title: cvLoc('largestHypervisors.title'),
				classes: ['col-md-4', 'col-md-4', 'col-md-4'],
				showLoader: true,
				expectedColumns: {
					name: {
						index: -1
					},
					protectedvms: {
						index: -1
					},
					notprotectedvms: {
						index: -1
					},
					clientid: {
						index: -1
					}
				},
				data: {
					headers: [
						cvLoc('largestHypervisors.header.name'),
						cvLoc('largestHypervisors.header.protectedVMs'),
						cvLoc('largestHypervisors.header.notProtectedVMs')
					],
					rows: [] // rows are filled up in the createLargestHypervisorInputs() function
				},
				titleDetailsLink: virtualizationPage
			};
			reportsDashboardFactory.createPaneEntitiesInput(self.hypervisors);
			_createLargestHypervisorInputs(self.largestHypervisors);

			function _createLargestHypervisorInputs(entityObject) {
				reportsDashboardFactory
					.getDataset(entityObject.datasetName)
					.then(function(data) {
						entityObject.showLoader = false;
						if (data) {
							data = data.data;
						}
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							data.columns.forEach(function(column, index) {
								let trimmedColumnName = column.name.replace(/ /g, '').toLowerCase();
								let found = entityObject.expectedColumns[trimmedColumnName];
								if (found) {
									entityObject.expectedColumns[trimmedColumnName].index = index;
								}
							});

							// Fetch the data for each column and fill it in the entityObject.data.rows
							let expectedColumns = entityObject.expectedColumns;
							data.records.forEach(function(record) {
								let row = [];
								row.push(
									{
										value: record[expectedColumns['name'].index],
										href: '#/servers/' + record[expectedColumns['clientid'].index]
									},
									{
										value: record[expectedColumns['protectedvms'].index]
									},
									{
										value: record[expectedColumns['notprotectedvms'].index]
									}
								);
								entityObject.data.rows.push(row);
							});
						} else {
							entityObject.noData = reportsDashboardFactory.noDataBuilder(
								cvLoc('noData.hypervisors'),
								virtualizationPage,
								cvLoc('dashboard.configure')
							);
						}
					})
					.catch(function(e) {
						entityObject.showLoader = false;
						entityObject.noData = {
							text: cvLoc('error.hypervisors')
						};
						reportsDashboardFactory.showErrorMessage(e && e.errorMessage ? e.errorMessage : null);
					});
			}
		};
	}
]);

export default reportsDashboardModule;
