import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/directives/cv-reports-backupjobs-summary-directive.js';
import 'modules/reports/js/directives/cv-reports-largest-x-directive.js';
import 'modules/reports/js/directives/cv-reports-lastn-jobs-stats.directive.js';
import 'modules/reports/js/directives/cv-reports-pane-directive.js';
import 'modules/reports/js/directives/cv-reports-sla-directive.js';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/directives/cv-reports-commcell-info-directive.js';
import 'modules/reports/js/directives/cv-dashboard-title-dropdown.js';

import { reportsDashboardModule } from 'common/js/modules';

var app = reportsDashboardModule;

app.directive('cvReportsHypervisorsVms', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsHypervisorsVMs.jsp',
		bindToController: {
			dashboardType: '=',
			tileType: '='
		},
		controller: 'HypervisorsVMsController',
		controllerAs: 'hypervisorVMCtrl'
	};
});

app.controller('HypervisorsVMsController', [
	'cvLoc',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	function HypervisorsVMsController(cvLoc, reportsDashboardFactory, PaneEntityTypes) {
		var self = this;

		self.$onInit = function() {
			const hyperLinks = {
				virtualizationPage: '#/virtualization/hypervisors',
				vmsPage: '#/virtualization/vms?vmStatus=ALL'
			};
			self.showCommCellInfo = cv.isAdmin;
			// contains the data for the compute pane
			self.hypervisors = {
				paneData: {
					title: cvLoc('pane.hypervisors.title'),
					entities: [],
					titleDetailsLink: hyperLinks.virtualizationPage,
					paneClass: 'row1',
					showLoader: true
				},
				// Contains the list of all the possible values for the Compute pane
				expectedColumns: {
					amazon: {
						imgSrc: 'common/img/Amazon.svg'
					},
					azure: {
						imgSrc: 'common/img/Azure.svg'
					},
					googlecloud: {
						imgSrc: 'common/img/GoogleCloud.svg'
					},
					'hyper-v': {
						imgSrc: 'common/img/HyperV.svg'
					},
					openstack: {
						imgSrc: 'common/img/OpenStack.svg'
					},
					nutanix: {
						imgSrc: 'common/img/Nutanix.svg'
					},
					oraclecloud: {
						imgSrc: 'common/img/OracleCloudInfrastructure.svg'
					},
					vcloud: {
						imgSrc: 'common/img/VCloud.svg'
					},
					vmware: {
						imgSrc: 'common/img/VMWare.svg'
					},
					redhat: {
						imgSrc: 'common/img/RedHat.svg'
					},
					redhatopenshift: {
						imgSrc: 'common/img/RedHatOpenShift.svg'
					}
				},
				type: PaneEntityTypes.EVENT,
				titlePlacement: 'bottom',
				includeZeros: false,
				datasetName: 'HypervisorCountByType',
				entitiesToShow: 4,
				noData: noDataBuilder(cvLoc('noData.hypervisors'), hyperLinks.virtualizationPage, cvLoc('dashboard.configure')),
				error: cvLoc('error.hypervisors'),
				getPaneLinks: function() {
					/*
					 * Show the pane links only if the number of entities available is more than the number of
					 * entities shown on the screen
					 */
					if (this.paneData.entities && this.paneData.entities.length >= this.entitiesToShow) {
						return [
							{
								link: hyperLinks.virtualizationPage,
								text: cvLoc('dashboard.more')
							}
						];
					}
				},
				sort: function() {
					this.paneData.entities.sort(function(a, b) {
						return b.value - a.value;
					});
				}
			};

			self.vms = {
				paneData: {
					title: cvLoc('label.vms'),
					entities: [],
					paneClass: 'row1',
					showLoader: true
				},
				// Contains the list of all the possible values for this pane
				expectedColumns: {
					protectedvms: {
						imgSrc: 'common/img/Command_center_icons_Masterfile_Protected.svg',
						href: '#/virtualization/vms?vmStatus=PROTECTED',
						tooltip: cvLoc('tooltip.vms.protectedvms'),
						includeZeros: true,
						hasSubEntityDetail: true,
						subEntityLinks: [
							{
								name: cvLoc('label.severity.warning'),
								href: '#/virtualization/vms?vmStatus=WARNING'
							}
						]
					},
					protectedbybackupvalidationandfailed: {
						imgSrc: 'common/img/warning.svg',
						href: '#/reportDetails?reportId=Backup%20validation%20protected%20VMs&app=ADMIN_CONSOLE',
						tooltip: cvLoc('tooltip.vms.protectedbybackupvalidationandfailed'),
						includeZeros: false
					},
					notprotectedvms: {
						imgSrc: 'common/img/Command_center_icons_Masterfile_Not_protected.svg',
						href: '#/reportDetails?name=Unprotected%20VMs&app=ADMIN_CONSOLE',
						tooltip: cvLoc('tooltip.vms.notprotectedvms'),
						includeZeros: true
					},
					backedupwitherror: {
						getImgSrc: function(value) {
							return value === 0
								? 'common/img/AllGood.svg'
								: 'common/img/Command_center_icons_Masterfile_Not_protected.svg';
						},
						href: '#/virtualization/vms?vmStatus=BACKED_UP_WITH_ERROR',
						tooltip: cvLoc('tooltip.vms.backedupwitherror'),
						includeZeros: true
					},
					failed: {
						imgSrc: 'common/img/Command_center_icons_Masterfile_Failed.svg',
						href: '#/virtualization/vms?vmStatus=FAILED',
						tooltip: cvLoc('tooltip.vms.failed'),
						includeZeros: true
					}
				},
				type: PaneEntityTypes.EVENT,
				titlePlacement: 'bottom',
				datasetName: 'VMSummary',
				entitiesToShow: 4,
				noData: noDataBuilder(cvLoc('noData.vms'), hyperLinks.virtualizationPage, cvLoc('dashboard.configure')),
				error: cvLoc('error.vms')
			};

			self.sla = {
				dashboardType: 'virtualization',
				appGroup: 'VMS'
			};

			// Functions that are called when the page loads
			reportsDashboardFactory.createPaneEntitiesInput(self.hypervisors);
			reportsDashboardFactory.createPaneEntitiesInput(self.vms);

			function noDataBuilder(noDataText, link, linkText) {
				return {
					text: noDataText,
					href: {
						href: link ? link : '#',
						text: linkText ? linkText : ''
					}
				};
			}
		};
	}
]);

export default app;
