import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsDrEnvironement', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/drEnvironment.jsp',
		require: [],
		bindToController: {
			dashboardId: '='
		},
		controller: 'drEnvironmentController',
		controllerAs: 'drEnvrnmntCtrl'
	};
});
app.controller('drEnvironmentController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	'setupFactory',
	function drEnvironmentController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster,
		setupFactory
	) {
		var self = this;
		this.$onInit = function() {
			self.drEnvironment = {
				title: cvLoc('usageOverview.title')
			};

			self.drEnvironment.moreLink = {
				title: cvLoc('dashboard.more'),
				link: '#/replicationMonitor'
			};

			var links = {};
			links.vms = setupFactory.isAtLeastOneSetupComplete('VSA')
				? '#/replicationMonitor' + '?type=' + 'VSA'
				: '#/gettingStarted';
			links.databases = setupFactory.isAtLeastOneSetupComplete('DBS')
				? '#/replicationMonitor' + '?type=' + 'DB'
				: '#/gettingStarted';
			links.fileServers = setupFactory.isAtLeastOneSetupComplete('ADMIN_CONSOLE')
				? '#/replicationMonitor' + '?type=' + 'FS'
				: '#/gettingStarted';
			links.replicationGroups = '#/replicationGroups';

			drEnvironmentController();

			function getEntityObj(title, addSeperator, tooltip, dataValue, filterUrl) {
				return {
					title: {
						value: typeof title === 'number' ? title : title.toUpperCase(),
						placement: 'top'
					},
					type: PaneEntityTypes.OVERVIEW,
					addSeperator: addSeperator,
					entityClass: 'overview-env-entity',
					tooltip: title,
					value: { valueCount: dataValue },
					filteredUrl: {
						url: filterUrl
					}
				};
			}

			function drEnvironmentController() {
				reportsDashboardService
					.getDrOverviewData(self.dashboardId)
					.success(function(data) {
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							self.drEnvironment.dataAvailable = true;
							processData(data);
						} else if (_.get(data, 'errorCode')) {
							self.drEnvironment.dataAvailable = false;
							self.drEnvironment.noData = { text: data.errorMessage };
						} else {
							self.drEnvironment.dataAvailable = false;
							self.drEnvironment.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						}
					})
					.error(function(err) {
						self.drEnvironment.dataAvailable = false;
						self.drEnvironment.noData = { text: cvLoc('dashboard.error.server') };
					});
			}

			function processData(data) {
				self.entityMetaInfo = {};
				self.links = {};
				angular.forEach(data.records, function(row) {
					if (row[2] === 'Oracle') {
						self.entityMetaInfo.database = getEntityObj(
							cvLoc('label.oracle'),
							false,
							cvLoc('label.oracle'),
							row[3],
							links.databases
						);
					}
					if (row[2] === 'FS') {
						self.entityMetaInfo.fs = getEntityObj(
							cvLoc('label.fileServers'),
							true,
							cvLoc('label.fileServers'),
							row[3],
							links.fileServers
						);
					}
					if (row[2] === 'Replication Groups') {
						self.entityMetaInfo.replicationgroups = getEntityObj(
							cvLoc('entity.replicationgroups.title'),
							true,
							cvLoc('entity.replicationgroups.title'),
							row[3],
							links.replicationGroups
						);
					}
					if (row[2] === 'VMs') {
						self.entityMetaInfo.vms = getEntityObj(
							cvLoc('pane.vms.title'),
							true,
							cvLoc('pane.vms.title'),
							row[3],
							links.vms
						);
					}
					if (row[2] === 'SQL') {
						if (row[3] > 0) {
							self.showMoreLink = true;
						} else {
							self.showMoreLink = false;
						}
					}
				});

				var entities = [];
				entities.push(self.entityMetaInfo.replicationgroups);
				entities.push(self.entityMetaInfo.vms);
				entities.push(self.entityMetaInfo.fs);
				entities.push(self.entityMetaInfo.database);
				self.drEnvironment.entities = entities;
			}
		};
	}
]);
