import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory';

import { reportsDashboardModule } from 'common/js/modules';

var app = reportsDashboardModule;

app.directive('cvReportsDiskSpace', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsDiskSpace.jsp',
		require: [],
		bindToController: {
			customClass: '=',
			dashboardType: '='
		},
		controller: 'reportsDiskSpaceController',
		controllerAs: 'reportsDiskSpaceCtrl'
	};
});

app.controller('reportsDiskSpaceController', [
	'$location',
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvToaster',
	'multiCommcellFactory',
	function($location, cvLoc, reportsDashboardService, reportsDashboardFactory, cvToaster, multiCommcellFactory) {
		var self = this;
		this.$onInit = function() {
			var DP_FREE_SPACE_THRESHOLD = 100 - 95;
			var DS_DATE_FULL_CRITICAL_STATUS = 'Critical';
			var DS_DATE_FULL_WARNING_STATUS = 'Critical';

			var path = $location.path().substring(1);
			var detailsLink =
				'#/reportDetails?name=Storage%20Utilization&app=ADMIN_CONSOLE&input.i_DashboardType=' +
				self.dashboardType +
				'&nav=' +
				path;
			self.data = {
				title:
					self.dashboardType == 'appliance'
						? cvLoc('dashboard.diskspace.appliance.title')
						: cvLoc('dashboard.diskspace.title'),
				titleDetailsLink: appUtil.appRoot + detailsLink,
				entities: []
			};
			if (cv.isCometApp) {
				self.data.titleDetailsLink = '';
			}
			self.diskLibColTitle =
				self.dashboardType == 'appliance'
					? cvLoc('dashboard.diskspace.appliance.storageTarget')
					: cvLoc('dashboard.diskspace.diskLibrary');

			getLibraryData();

			function getLibraryData() {
				self.data.showLoader = true;
				reportsDashboardFactory.getStorageUsage(self.dashboardType, function(data) {
					self.data.showLoader = false;

					//Merging two data sets
					var rawData = angular.copy(data[0].data);
					rawData.columns.push({ name: 'Type', dataField: 'Type' });
					angular.forEach(rawData.records, function(record) {
						record.push('Disk'); //Disk type
					});
					if (data[1].data.records) {
						angular.forEach(data[1].data.records, function(rowData) {
							rowData.push('Cloud'); //cloud type
							rawData.records.push(rowData);
						});
					}
					rawData.totalRecordCount += data[1].data.totalRecordCount;
					console.log(rawData);
					if (rawData.totalRecordCount <= 0) {
						console.log('Records has no rows. Returning false.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}
					formatData(rawData);
				});
			}

			function formatData(rawData) {
				var FREE_SPACE_PERCENT_IDX = 0;
				var TOTAL_SPACE_IDX = 0;
				var FREE_SPACE_IDX = 0;
				var UNIX_TIME_IDX = 0;
				var HEALTH_STAT_IDX = 0;
				var LIBRARY_IDX = 0;
				var DATE_FULL_IDX = 0;
				var DATA_SOURCE_IDX = 0;
				var TYPE_IDX = 0;
				var entities = [];

				angular.forEach(rawData.columns, function(column, idx) {
					if (column.dataField == 'LibraryName') {
						LIBRARY_IDX = idx;
						return true;
					}

					if (column.dataField == 'Type') {
						TYPE_IDX = idx;
						return true;
					}

					if (column.dataField == 'TotalSpaceMB') {
						TOTAL_SPACE_IDX = idx;
						return true;
					}

					if (column.dataField == 'TotalFreeSpaceMB') {
						FREE_SPACE_IDX = idx;
						return true;
					}

					if (column.dataField == 'FreeSpacePercentage') {
						FREE_SPACE_PERCENT_IDX = idx;
						return true;
					}

					if (column.dataField == 'Date to be Full') {
						DATE_FULL_IDX = idx;
						return true;
					}

					if (column.dataField == 'HealthStatus') {
						HEALTH_STAT_IDX = idx;
						return true;
					}

					if (column.dataField == 'Data Source') {
						DATA_SOURCE_IDX = idx;
						return true;
					}
				});

				if (rawData.records) {
					rawData.records = _.sortBy(rawData.records, function(data) {
						return data[DATE_FULL_IDX];
					});
					if (rawData.records.length > 10 && cv.isCometApp) {
						rawData.records = _.slice(rawData.records, 0, 10);
					}
					angular.forEach(rawData.records, function(rowData) {
						var freeSpace = parseFloat(rowData[FREE_SPACE_IDX]);
						var usageStat = 'Good';
						var formattedTime = cvLoc('dashboard.diskspace.never'); //-1
						if (freeSpace < DP_FREE_SPACE_THRESHOLD) {
							usageStat = 'Warning';
						}

						var unixTime = parseInt(rowData[DATE_FULL_IDX]);
						if (unixTime > 0) {
							if (unixTime == 549755813887) {
								formattedTime = cvLoc('dashboard.diskspace.notApplicable');
							} else if (unixTime == 549755813886) {
								formattedTime = cvLoc('dashboard.diskspace.never');
							} else {
								formattedTime = moment(unixTime * 1000).format('MMM DD, YYYY');
							}
						}

						var row = {
							library: rowData[LIBRARY_IDX],
							type: rowData[TYPE_IDX],
							usageStatus: usageStat,
							usage: 100 - rowData[FREE_SPACE_IDX],
							fullDate: formattedTime,
							fullStatus: rowData[HEALTH_STAT_IDX],
							totalSpace: reportsDashboardFactory.autoConvertFromMB(rowData[TOTAL_SPACE_IDX]),
							usedSpace: reportsDashboardFactory.autoConvertFromMB(rowData[TOTAL_SPACE_IDX] - rowData[FREE_SPACE_IDX]),
							commcellName: rowData[DATA_SOURCE_IDX]
						};

						if (cv.isCometApp) {
							row.link = cvUtil.modifyUrlForComet(detailsLink, row.commcellName);
							row.onClick = () => multiCommcellFactory.openUrl(row.link, { commcellName: row.commcellName });
						}

						entities.push(row);
					});
				}
				self.data.entities = entities;

				self.isCometApp = cv.isCometApp;
			}

			self.isCriticalStatus = function(fullStatus) {
				return fullStatus === 'Critical';
			};

			self.isWarningStatus = function(fullStatus) {
				return fullStatus === 'Warning';
			};
		};
	}
]);

export default app;
