import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

const app = reportsDashboardModule;

app.directive('cvReportsCaseManagerOverview', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<cv-reports-pane pane-data="cmOverviewCtrl.overviewPane"></cv-reports-pane>`,
		require: [],
		bindToController: true,
		controller: 'CaseManagerOverviewController',
		controllerAs: 'cmOverviewCtrl'
	};
});
app.controller('CaseManagerOverviewController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	function CaseManagerOverviewController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster
	) {
		this.$onInit = function() {
			const entityClass = 'activate-report-pane-entity';
			const overviewEntitiesInfo = {
				totalCount: getEntityObj(
					cvLoc('entity.cmOverview.label.cases').toUpperCase(),
					true,
					`<svg  class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50">
					<path d="M35.1 0H23.5a8.3 8.3 0 0 0-8.1 7.1H9a8.3 8.3 0 0 0-8.3 8.3v26.3A8.3 8.3 0 0 0 9 50h21.4a8.2 8.2 0 0 0 7.8-5.6 16.6 16.6 0 0 1-2.4-.5 5.9 5.9 0 0 1-5.5 3.7H9a6 6 0 0 1-6-6V15.6a6 6 0 0 1 6-6h21.4a6 6 0 0 1 5.8 4.8l2.4-.5a8.3 8.3 0 0 0-8.2-6.6H17.8a6 6 0 0 1 5.8-4.8h11.5a6 6 0 0 1 5.9 6v12a16 16 0 0 1 2.4.3V8.3A8.3 8.3 0 0 0 35 0z"></path><path d="M7.8 18.6h15.8v1.8H7.8zM7.8 27.1H20v1.8H7.8zM7.8 35.5H20v1.8H7.8zM7.8 43.4h15.8v1.8H7.8zM45.5 40.8a2.3 2.3 0 0 0 3.3-3.3l-6.6-6.7a2.3 2.3 0 0 0-2.3-.5l-2-2a7.8 7.8 0 0 0 1.1-2 .7.7 0 0 1-.3-.2l-3.5-3.5-.2-.3a9 9 0 0 0-2.7 2 9.4 9.4 0 0 0-2 2.6l.5.2 3.4 3.5a1 1 0 0 1 .3.3 8.3 8.3 0 0 0 1.8-1.1l2 2a2.5 2.5 0 0 0 .7 2.4zM30.4 27.4H30a1.6 1.6 0 0 0-.9.3 1.5 1.5 0 0 0-.4.7.5.5 0 0 0 .2.6l2.4 2.4 1 1a.6.6 0 0 0 .5.2 1.6 1.6 0 0 0 .9-.4 1.3 1.3 0 0 0 .4-1 .3.3 0 0 0-.1-.3zM39.4 25.9a1.6 1.6 0 0 0 1-.4c.4-.4.5-1 .1-1.3l-1.1-1.1-2.3-2.3a.6.6 0 0 0-.5-.2 1.5 1.5 0 0 0-.8.4 1.3 1.3 0 0 0-.4 1.1v.2l3.5 3.5a.3.3 0 0 0 .2 0zM33 36.3h-7v1.3h7v-1.3zM27.7 38H26c-1.7.2-3 .8-3 2.8h13c0-2-1.2-2.6-3-2.8z">
					</path></svg>`,
					`#/caseManager`
				),
				totalEmails: getEntityObj(
					cvLoc('entity.cmOverview.label.emails').toUpperCase(),
					true,
					`<svg class="svg-primary-fill" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 60 60" xml:space="preserve"><style>.st0{fill:none}</style>
					<path class="st0" d="M12.7 39.2V20L5.3 38.4c-.1.2-.2.5-.3.8.2 0 .5-.1.7-.1h7zM37.2 37.7V18.3h-5.1c-1.7 0-3.1-1.4-3.1-3.1v-5.1H15.8c-.6 0-1 .5-1 1v28h22.3c0-.7.1-1.3.1-1.4zm-4.9-3.4H19.6c-.5 0-.8-.4-.8-1 0-.5.4-1 .8-1H32.4c.4 0 .8.5.7 1 0 .5-.4.9-.8 1zm.2-5.8H19.8c-.5 0-.8-.4-.8-1 0-.5.4-1 .8-1H32.6c.4 0 .8.5.7 1 0 .5-.3.9-.8 1zm0-5.6H19.8c-.5 0-.8-.4-.8-1 0-.5.4-1 .8-1H32.6c.4 0 .8.5.7 1 0 .6-.3 1-.8 1z"/>
					<path class="st0" d="M31.8 8.5l6.9 6.9H40.6c.4 0 .8.5.7 1 0 .5-.4.9-.8 1h-1.3V21H40.6c.4 0 .8.5.7 1 0 .5-.4.9-.8 1h-1.3v3.8H40.4c.4 0 .8.5.7 1 0 .5-.4.9-.8 1h-1.1v1.8h5.1c.6 0 1-.5 1-1V10.2h-5.1c-1.7 0-3.1-1.4-3.1-3.1v-5H23.9c-.6 0-1 .5-1 1v5.1H31c.3 0 .6.1.8.3z"/>
					<path class="st0" d="M39.2 32.2v7h16.1c.2 0 .5 0 .7.1-.1-.3-.2-.5-.3-.7L47 18v12c0 2.1-.5 2.2-2.3 2.2h-5.5zM54.9 41H5.8c-.8 0-1.4.8-1.4 1.7v13.6c-.1 1 .6 1.7 1.4 1.7h49.1c.8 0 1.4-.8 1.4-1.7V42.7c0-.9-.6-1.7-1.4-1.7zM34.5 51h-8.4c-.8 0-1.4-.7-1.4-1.5s.6-1.5 1.4-1.5h8.4c.8 0 1.4.7 1.4 1.5 0 .9-.6 1.5-1.4 1.5z"/>
					<path d="M34.5 48.1h-8.4c-.8 0-1.4.7-1.4 1.5s.6 1.5 1.4 1.5h8.4c.8 0 1.4-.7 1.4-1.5 0-.9-.6-1.5-1.4-1.5z"/>
					<path d="M57.1 37.3L49.5 19c-.4-1-1.2-1.9-2.2-2.6V8.2c0-.3-.1-.5-.3-.7L39.9.4c-.2-.3-.4-.4-.7-.4H23.9c-1.7 0-3.1 1.4-3.1 3.1v5.1h-5.1c-1.7 0-3.1 1.4-3.1 3.1v5.9c-.7.6-1.4 1.3-1.6 1.9L3.6 37.3c-.7 1.7-1.2 4.4-1.2 6.3v11.8c0 2.5 1.9 4.4 4.2 4.4h47.6c2.3 0 4.2-2 4.2-4.4V43.6c-.1-1.8-.6-4.6-1.3-6.3zM47 30V18l8.7 20.5c.1.2.2.5.3.7-.2 0-.5-.1-.7-.1H39.2v-7h5.5c1.8.1 2.3 0 2.3-2.1zM22.9 3.1c0-.6.5-1 1-1h13.2v5.1c0 1.7 1.4 3.1 3.1 3.1h5.1v19.3c0 .6-.5 1-1 1h-5.1v-1.8h1.1c.4 0 .8-.4.8-1 0-.5-.3-1-.7-1H39.2V23h1.3c.4 0 .8-.4.8-1 0-.5-.3-1-.7-1H39.2v-3.6h1.3c.4 0 .8-.4.8-1 0-.5-.3-1-.7-1H38.7l-6.9-6.9c-.2-.2-.5-.3-.7-.3H23V3.1zm-8.1 8.1c0-.6.5-1 1-1H29v5.1c0 1.7 1.4 3.1 3.1 3.1h5.1v19.3c0 .1 0 .8-.1 1.5H14.8v-28zM5.3 38.4L12.7 20V39.1h-7c-.2 0-.5 0-.7.1.1-.3.2-.5.3-.8zm51 17.9c0 .9-.6 1.7-1.4 1.7H5.8c-.8 0-1.4-.8-1.4-1.7V42.7c-.1-.9.6-1.7 1.4-1.7h49.1c.8 0 1.4.8 1.4 1.7v13.6z"/><path d="M32.6 20.9s-.1 0 0 0H19.9c-.5 0-.8.4-.8 1 0 .5.4 1 .8 1h12.7c.4 0 .8-.4.8-1 0-.5-.4-.9-.8-1zM32.6 26.5s-.1 0 0 0H19.9c-.5 0-.8.4-.8 1 0 .5.4 1 .8 1h12.7c.4 0 .8-.4.8-1 0-.5-.4-1-.8-1zM32.4 32.3c-.1 0-.1 0 0 0H19.7c-.5 0-.8.4-.8 1 0 .5.4 1 .8 1h12.7c.4 0 .8-.4.8-1-.1-.5-.4-1-.8-1z"/>
					</svg>`
				),
				totalCustodians: getEntityObj(
					cvLoc('entity.cmOverview.label.custodians').toUpperCase(),
					true,
					`<svg class="svg-primary-fill" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 64 64" xml:space="preserve"><style>.st0{fill:none}</style>
					<path class="st0" d="M46.1 54.9c-.1 0-.3 0-.4-.1L44.4 62l1.8.9L48 62l-1.3-7.1h-.6zM46.1 54.4c.1 0 .3-.1.5-.2h.1c.5-.3 1-1 1.2-1.4v-.1h-3.5v.1s.2.4.6.8c.4.5.8.8 1.1.8zM17 14.4c4 1.4 9.3 2.2 15 2.2 5.7 0 11-.8 15-2.2 3.7-1.3 5.8-3 5.8-4.7C52.8 8 50.7 6.3 47 5c-4-1.4-9.3-2.2-15-2.2-5.7 0-11 .8-15 2.2-3.7 1.3-5.8 3-5.8 4.7 0 1.7 2.1 3.4 5.8 4.7zM43.7 23.2c0 .5.4.9.9.9s.9-.4.9-.9-.4-.9-.9-.9-.9.4-.9.9z"/>
					<path d="M17 59c-3.7-1.3-5.8-3-5.8-4.7V42.8c1.2 1.1 2.9 2.1 5.2 2.9C20.6 47.2 26.1 48 32 48c1.6 0 3.2-.1 4.8-.2-.1-.1-.1-.3-.2-.4-.1-.4-.2-.8-.2-1.3-1.4.1-2.9.2-4.4.2-5.7 0-11-.8-15-2.2-3.7-1.3-5.8-3-5.8-4.7V28c1.2 1.1 2.9 2.1 5.2 2.9 4.2 1.5 9.7 2.3 15.6 2.3 1 0 2 0 2.9-.1-.1-.4-.2-.8-.2-1.2v-.6c-.9 0-1.8.1-2.8.1-5.7 0-11-.8-15-2.2-3.7-1.3-5.8-3-5.8-4.7V13.1c1.2 1.1 2.9 2.1 5.2 2.9 4.2 1.5 9.7 2.3 15.6 2.3s11.4-.8 15.6-2.3c2.3-.8 4-1.8 5.2-2.9v11.4c0 .2-.1.5-.1.7h1.9V9.7c0-2.5-2.5-4.7-6.9-6.3C43.4 1.8 37.9 1 32 1s-11.4.8-15.6 2.3C12 5 9.5 7.2 9.5 9.7v44.6c0 2.5 2.5 4.7 6.9 6.4 3.1 1.1 6.9 1.8 11 2.2-.2-.6-.2-1.2-.2-1.8-3.9-.4-7.4-1-10.2-2.1zm0-54c4-1.4 9.3-2.2 15-2.2 5.7 0 11 .8 15 2.2 3.7 1.3 5.8 3 5.8 4.7 0 1.7-2.1 3.4-5.8 4.7-4 1.4-9.3 2.2-15 2.2-5.7 0-11-.8-15-2.2-3.7-1.3-5.8-3-5.8-4.7C11.2 8 13.3 6.3 17 5z"/><path d="M39 24.5c-.1-.5-.5-.8-1-.8-2 .2-4 .3-6 .3-2.5 0-5-.2-7.5-.5-.5-.1-.9.3-1 .7-.1.5.3.9.7 1 2.6.3 5.2.5 7.8.5 2.1 0 4.1-.1 6.2-.3.5 0 .8-.4.8-.9zM24.5 52.8c-.5-.1-.9.3-1 .7-.1.5.3.9.7 1 1.5.2 3 .3 4.5.4 0-.2-.1-.4-.1-.6 0-.4 0-.8.1-1.2-1.4 0-2.8-.1-4.2-.3zM42 23.2c0 1.4 1.2 2.6 2.6 2.6 1.4 0 2.6-1.2 2.6-2.6 0-1.4-1.2-2.6-2.6-2.6-1.5 0-2.6 1.2-2.6 2.6zm3.4 0c0 .5-.4.9-.9.9s-.9-.4-.9-.9.4-.9.9-.9.9.4.9.9zM32 38.7c-2.5 0-5-.2-7.5-.5-.5-.1-.9.3-1 .7-.1.5.3.9.7 1 2.6.3 5.2.5 7.8.5 1.2 0 2.4 0 3.7-.1-.1-.1-.1-.3-.2-.4 0-.1-.1-.3-.1-.4-.1-.3-.1-.6-.1-.9-1.2 0-2.2.1-3.3.1z"/><path d="M59.8 54.7c-2.1-1.6-5.2-2.5-8-3.2-.5-.1-1.1-.9-1.4-1.9-.1-.6-.3-2 .8-2.9.8-.7 1.4-1.6 1.8-2.5 1.5-1.8 2.4-3.8 2.8-5.8.3-1.7.2-3.5-.3-5.4-.6-2.1-2.1-3.8-4.3-5-1.9-1-4.1-1.5-6.2-1.4-1.4.1-2.7.4-3.6.9-.9.5-1.5 1.2-1.9 2.1-1.5.2-2.7 1.1-3.4 2.5-.7 1.6-.7 3.9-.1 6.3.6 2.2 1.6 4.3 2.9 5.7.3.9.8 1.8 1.6 2.5 1.2 1 .9 2.5.8 3-.3 1-.9 1.8-1.3 1.9-2.8.7-5.9 1.6-8 3.2-2.1 1.6-3.1 3.9-3.1 6.8 0 .5.4.9.9.9l12.3-.1v-1.8H30.7c.2-1.9.9-3.3 2.3-4.4 1.4-1.1 3.6-2 7.3-2.9 1.2-.3 2.3-1.6 2.7-3.3.5-1.9-.1-3.7-1.4-4.9-1.4-1.2-1.4-3.3-1.4-5.4v-.5c.7-.8 1.4-2.4 1.7-4.4 1.1.5 2.6.8 4.6 1 1.4.1 3 .2 4.6.2.3.6.8 2.5.7 4.7-.1 1.4-.5 3.3-1.9 4.5-1.4 1.2-1.9 3-1.4 4.8.4 1.7 1.5 3 2.8 3.3 3.7.9 5.9 1.7 7.3 2.9 1.4 1.1 2.1 2.5 2.3 4.4H50v1.9h11.9c.5 0 .9-.4.9-.9.1-3-.9-5.2-3-6.8z"/><path d="M48.6 62l-1.4-7.5.6-.6c.4-.5.7-.9.7-.9.1-.2.1-.5 0-.6-.1-.2-.4-.3-.7-.3h-3.3c-.3 0-.6.1-.7.3-.1.2-.2.4 0 .6 0 0 .3.5.7.9l.6.6-1.5 7.5c0 .1 0 .2.2.3l2.1 1.1h.4l2.1-1.1c.2 0 .2-.1.2-.3zM45 53.6c-.4-.4-.6-.8-.6-.8v-.1h3.5v.1c-.2.4-.7 1.1-1.2 1.4h-.1c-.2.1-.3.2-.5.2-.3 0-.7-.3-1.1-.8zm1.1 9.3l-1.7-.9 1.3-7.1c.1 0 .3.1.4.1.1 0 .3 0 .4-.1l1.3 7.1-1.7.9z"/>
					</svg>`
				),
				totalSizeOfFiles: getEntityObj(
					cvLoc('entity.overview.label.size').toUpperCase(),
					false,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<g>
						<path fill="none" d="M32,14.419c-4.566,0-8.267,3.702-8.267,8.269s3.701,8.269,8.267,8.269c4.565,0,8.267-3.702,8.267-8.269
							C40.262,18.123,36.563,14.424,32,14.419z M32,27.856c-2.854,0-5.167-2.314-5.167-5.168c0.003-2.853,2.314-5.165,5.167-5.168
							c2.854,0,5.167,2.313,5.167,5.168S34.854,27.856,32,27.856z"></path>
						<circle fill="none" cx="32" cy="22.688" r="3.101"></circle>
						<path fill="none" d="M23.94,35.712l-2.791-3.721H3.067v28.941h57.867V36.125H24.767C24.441,36.125,24.135,35.972,23.94,35.712z"></path>
						<path fill="#CCCCCC" d="M42.333,22.688c0,0.777-0.088,1.533-0.251,2.261l9.124,1.834c0.285-1.342,0.431-2.714,0.427-4.095
							c-0.006-6.456-3.177-12.414-8.343-16.045l-5.885,7.236C40.361,15.697,42.333,18.962,42.333,22.688z"></path>
						<path d="M51.206,26.783l-9.124-1.834c-0.134,0.6-0.317,1.18-0.55,1.735l9.216,1.852
							C50.928,27.959,51.081,27.374,51.206,26.783z"></path>
						<path d="M37.405,13.878l5.885-7.236c-0.494-0.348-1.007-0.673-1.537-0.976l-6.009,7.388
							C36.325,13.281,36.881,13.556,37.405,13.878z"></path>
						<path d="M12.985,27.596c-1.893-7.366,0.637-15.163,6.493-20.014c5.856-4.851,13.986-5.883,20.868-2.65
							c0.482,0.227,0.95,0.473,1.407,0.734c0.53,0.303,1.043,0.628,1.537,0.976c5.166,3.631,8.337,9.59,8.343,16.045
							c0.004,1.381-0.142,2.753-0.427,4.095c-0.125,0.591-0.278,1.176-0.458,1.753c-0.29,0.93-0.649,1.84-1.078,2.722l1.86,0.901
							c1.437-2.95,2.179-6.189,2.17-9.471c-0.007-8.407-4.867-16.054-12.475-19.629c-7.607-3.574-16.594-2.433-23.067,2.93
							c-6.473,5.363-9.269,13.982-7.174,22.124L12.985,27.596z"></path>
						<path d="M32,17.52c-2.852,0.003-5.163,2.315-5.167,5.168c0,2.854,2.313,5.168,5.167,5.168s5.167-2.314,5.167-5.168
							S34.854,17.52,32,17.52z M32,25.789c-1.712,0-3.1-1.389-3.1-3.101c0-1.713,1.388-3.101,3.1-3.101s3.1,1.388,3.1,3.101
							C35.1,24.4,33.712,25.789,32,25.789z"></path>
						<path d="M42.082,24.949c0.163-0.728,0.251-1.484,0.251-2.261c0-3.726-1.972-6.991-4.928-8.81
							c-0.524-0.323-1.08-0.598-1.661-0.824c-1.161-0.452-2.423-0.703-3.744-0.703c-5.705,0.006-10.327,4.63-10.333,10.336
							c0,5.708,4.626,10.336,10.333,10.336c4.291,0,7.97-2.616,9.532-6.34C41.765,26.129,41.948,25.549,42.082,24.949z M32,30.957
							c-4.566,0-8.267-3.702-8.267-8.269s3.701-8.269,8.267-8.269c4.563,0.005,8.262,3.704,8.267,8.269
							C40.267,27.255,36.565,30.957,32,30.957z"></path>
						<path d="M61.967,23.722h-6.2v2.067h5.167v8.27h-35.65l-2.79-3.722c-0.195-0.26-0.501-0.413-0.827-0.413h-18.6
							v-4.135h5.167v-2.067h-6.2C1.463,23.722,1,24.184,1,24.755v37.21C1,62.537,1.463,63,2.033,63h59.934C62.537,63,63,62.537,63,61.966
							v-37.21C63,24.184,62.537,23.722,61.967,23.722z M60.934,60.933H3.067V31.991H21.15l2.791,3.721
							c0.194,0.26,0.501,0.413,0.826,0.413h36.167V60.933z"></path>
					</g>
					</svg>`
				)
			};
			function getEntityObj(title, addSeperator, image, detailsLink) {
				return {
					title: {
						value: title,
						placement: 'bottom'
					},
					type: PaneEntityTypes.OVERVIEW,
					entityClass: entityClass,
					addSeperator: addSeperator,
					svgSrc: image,
					detailsLink: detailsLink
				};
			}

			this.overviewPane = {
				title: cvLoc('caseManagerOverview.title'),
				titleDetailsLink: `#/caseManager`,
				entities: Object.values(overviewEntitiesInfo)
			};

			this.getOverviewStats = () => {
				this.overviewPane.showDataLoader = true;
				const entities = [];
				const summaryType = 'CaseManager';
				reportsDashboardService
					.getActivateSummary(summaryType)
					.success(data => {
						this.overviewPane.showDataLoader = false;
						if (data.genericActivateSummary && data.genericActivateSummary.length) {
							data = data.genericActivateSummary[0];
							Object.keys(overviewEntitiesInfo).forEach(key => {
								const entity = overviewEntitiesInfo[key] || {};
								entity.value =
									key === 'totalSizeOfFiles'
										? reportsDashboardFactory.formatBytes(data[key])
										: reportsDashboardFactory.formatNumber(data[key]);
								entities.push(entity);
							});
						}
						this.overviewPane.entities = entities;
					})
					.error(err => {
						cvToaster.showErrorMessage({
							message: err.errorMessage ? err.errorMessage : err
						});
					});
			};
			this.getOverviewStats();
		};
	}
]);
