import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsBackupJobSummary', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<div class="dash-pane">
						<div class="dash-pane-wrapper">
							<cv-reports-pane-header title="BackupJobCtrl.data.title" title-details-link="BackupJobCtrl.data.titleDetailsLink">
							</cv-reports-pane-header>
							<div class="dash-pane-content backupjobs-content {{BackupJobCtrl.customClass}}">
								<div class="chart-center" data-ng-if="!!BackupJobCtrl.chartConfig">
									<highchart class="backupjobs-chart" config="BackupJobCtrl.chartConfig"></highchart>
								</div>
								<div class="no-data-container" data-ng-if="BackupJobCtrl.showNoDataMsg"><span class="no-data-msg">{{BackupJobCtrl.noDataMsg}}</span></div>
							</div>
						</div>
					</div>`,
		require: [],
		bindToController: {
			dashboardType: '=',
			customClass: '=',
			serverGroupId: '='
		},
		controller: 'BackupJobSummaryController',
		controllerAs: 'BackupJobCtrl'
	};
});
app.controller('BackupJobSummaryController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'ChartColors',
	'cvToaster',
	function BackupJobSummaryController(cvLoc, reportsDashboardService, reportsDashboardFactory, ChartColors, cvToaster) {
		var self = this;
		this.$onInit = function() {
			var lastNdays = 8;

			//var endTime = moment().format('X');
			//var startTime = moment().subtract(lastNdays, "days").format('X');
			var detailsLink = appUtil.appRoot + '#/jobs?jobType=Backup';
			if (self.dashboardType == 'virtualization') {
				detailsLink += '&applicationId=106';
			}
			if (self.dashboardType == 'endpoint') {
				detailsLink += '&view=laptopJobs&jobStartTime=last1week';
			} else {
				detailsLink += '&view=finishedJobs7';
			}

			self.data = {
				title: cvLoc('backupjobs.title'),
				titleDetailsLink: detailsLink
			};

			getLastNBackupJobsSummary(self.dashboardType);

			function getLastNBackupJobsSummary(dashboardType) {
				reportsDashboardService
					.getLastNBackupJobsSummary(dashboardType, lastNdays)
					.success(function(data) {
						//console.log(data);
						data = reportsDashboardFactory.getJsonFromDSResult(data);
						processData(data);
					})
					.error(function(err) {
						console.log(err);
						self.data.showLoader = false;
						self.showNoDataMsg = true;
						self.noDataMsg = cvLoc('dashboard.error.server');
						reportsDashboardFactory.showErrorMessage(err, self.data.title);
					});
			}

			function processData(data) {
				var asof = new Array();
				var success = new Array();
				var failure = new Array();
				var warning = new Array();
				var maxValue = new Array();
				var killed = new Array();
				var maxDay = 10;

				if (data.length > 0) {
					//var showPoints = lastNdays;
					//var i = 0;
					//if (data.length > showPoints) {
					//	i = data.length - showPoints;
					//}
					//var j = 0;

					angular.forEach(data, function(row, i) {
						//if(j >= i){
						//	return;
						//}
						//j++;
						//asof.push(new Date((row["DayBeginDT"])).getTime()/1000);
						asof.push(parseInt(row['UnixTimeUTC']));
						success.push(parseInt(row['Completed']));
						failure.push(parseInt(row['Failed']));
						killed.push(parseInt(row['Killed']));
						//warning.push(parseInt(rows[row]["CompletedwithErrorsorWarnings"]));

						var dayTotal = parseInt(row['Completed']) + parseInt(row['Failed']) + parseInt(row['Killed']);
						if (dayTotal > maxDay) {
							maxDay = dayTotal;
						}
					});
				} else {
					success.push(parseInt(0));
					failure.push(parseInt(0));
					killed.push(parseInt(0));
					//warning.push(parseInt(0));
					maxValue.push(parseInt(0));
				}

				if (data.length > 0) {
					var labels = new Array();
					var popupLabels = new Array();
					for (var i = 0; i < asof.length; i++) {
						labels.push(cvFormatters.formatDate(asof[i], 'Custom', null, 'ddd DD'));
						popupLabels[i] = cvFormatters.formatDate(asof[i], 'Custom', null, 'ddd, MMM D');
					}
					var totalSeries = function(series) {
						var total = 0;
						for (var i in series) {
							total += series[i];
						}
						return total;
					};

					var seriesData = [];
					seriesData.push({
						name: cvLoc('backupjobs.label.killed'),
						legendName: cvLoc('backupjobs.label.killed'),
						statusParams: 'Killed',
						data: killed,
						maxPointWidth: 30
					});
					seriesData.push({
						name: cvLoc('backupjobs.label.failed'),
						legendName: cvLoc('backupjobs.label.failed'),
						statusParams: 'Failed,Failed%20to%20Start',
						data: failure,
						maxPointWidth: 30
					});
					//seriesData.push({
					//	name : cvLoc("Completed_with_Errors_or_Warnings"),
					//	legendName : cvLoc("cwew"),
					//	data : warning,
					//	maxPointWidth: 30
					//});
					seriesData.push({
						name: cvLoc('backupjobs.label.completed'),
						legendName: cvLoc('backupjobs.label.completed'),
						statusParams:
							'Completed,Completed%20w%2F%20one%20or%20more%20warnings,Completed%20w%2F%20one%20or%20more%20errors',
						data: success,
						maxPointWidth: 30
					});

					var successTotal = totalSeries(success);
					//var warningTotal = totalSeries(warning);
					var failureTotal = totalSeries(failure);
					var killedTotal = totalSeries(killed);
					var successObj = reportsDashboardFactory.autoConvertCount(successTotal);
					//var warningObj = reportsDashboardFactory.autoConvertCount(warningTotal);
					var failureObj = reportsDashboardFactory.autoConvertCount(failureTotal);
					var killedObj = reportsDashboardFactory.autoConvertCount(killedTotal);

					successObj['title'] = reportsDashboardFactory.getFormattedNumberNA(successTotal);
					//warningObj['title'] = reportsDashboardFactory.getFormattedNumberNA(warningTotal);
					failureObj['title'] = reportsDashboardFactory.getFormattedNumberNA(failureTotal);
					killedObj['title'] = reportsDashboardFactory.getFormattedNumberNA(killedTotal);

					var legendsArr = [killedObj, failureObj /* , warningObj */, successObj];
					//console.log(legendsArr);

					var colors = [
						ChartColors.KILLED,
						ChartColors.FAILURE,
						/* ChartColors.PARTIALSUCCESS, */
						ChartColors.SUCCESS
					];

					var yAxistitle = cvLoc('backupjobs.label.jobscount');
					var xAxistitle =
						cvFormatters.formatDate(asof[0], 'Custom', null, 'MMMM D') +
						' - ' +
						cvFormatters.formatDate(asof[asof.length - 1], 'Custom', null, 'MMMM D');
					var tickInterval = Math.ceil(maxDay / 3);

					var chartConfig = {
						options: {
							chart: {
								type: 'column',
								marginTop: 30
								//height: 400
								//width: 650,
								//margin: [50, 50, 50, 50]
							},
							exporting: {
								enabled: false
							},
							credits: {
								enabled: false
							},
							colors: colors,
							legend: {
								enabled: true,
								reversed: true,
								itemStyle: {
									fontWeight: 'normal'
								},
								symbolPadding: 0,
								symbolWidth: 0.1,
								symbolHeight: 0.1,
								symbolRadius: 0,
								useHTML: true,
								symbolWidth: 0,
								labelFormatter: function() {
									var legendItem = legendsArr[this.index];
									return (
										'<div class="custom-legend"><span class="legend-box" style="background-color:' +
										colors[this.index] +
										'"></span><span class="legend-name">' +
										this.userOptions.legendName +
										'</span>:<span class="legend-val" title="' +
										legendItem.title +
										'">' +
										(legendItem.value + (legendItem.unit ? legendItem.unit : '')) +
										'</span></div>'
									);
								}
							},
							tooltip: {
								formatter: function() {
									return (
										'<b>' +
										popupLabels[this.point.x] +
										'</b><br/>' +
										this.series.name +
										': <b>' +
										reportsDashboardFactory.getFormattedNumberNA(this.point.y) +
										'</b><br/>Total: <b>' +
										reportsDashboardFactory.getFormattedNumberNA(this.point.stackTotal) +
										'</b>'
									);
								}
							},
							plotOptions: {
								column: {
									stacking: 'normal',
									cursor: 'pointer',
									dataLabels: {
										enabled: false,
										color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'
									},
									events: {
										click: function() {
											window.location.href = self.data.titleDetailsLink + '&status=' + this.userOptions.statusParams;
										}
									}
								},
								series: {
									animation: true
								}
							}
						},
						title: {
							text: ''
						},
						subtitle: {
							text: ''
						},
						xAxis: {
							categories: labels,
							gridLineWidth: 0,
							title: {
								text: xAxistitle
							}
						},
						yAxis: {
							min: 0,
							//max : maxDay,
							//tickInterval : tickInterval,
							allowDecimals: false,
							title: {
								text: yAxistitle
							},
							stackLabels: {
								enabled: false,
								style: {
									fontWeight: 'bold',
									color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
								}
							}
						},
						//size: {
						//	width: 500,
						//	height: 250
						//},
						series: seriesData
					};
					self.chartConfig = chartConfig;
				} else {
					self.showNoDataMsg = true;
					self.noDataMsg = cvLoc('dashboard.msg.noDataAvailable');
					//No data
					//angular.element(div).html("<p class='nodata'><span class='sprite icon-info'></span> <span class='msg'>" +cvLoc("No_Data_Available") + "</span></p>");
				}
			}
		};
	}
]);
