import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

const app = reportsDashboardModule;

app.directive('cvReportsActivateOverview', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<cv-reports-pane pane-data="activateOverviewCtrl.overviewPane"></cv-reports-pane>`,
		require: [],
		bindToController: true,
		controller: 'ActivateOverviewController',
		controllerAs: 'activateOverviewCtrl'
	};
});
app.controller('ActivateOverviewController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	function UsageOverviewController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster
	) {
		const self = this;
		this.$onInit = function() {
			const entityClass = 'activate-env-entity';
			const overviewEntitiesInfo = [
				getEntityObj(cvLoc('entity.overview.label.dataSources').toUpperCase(), true, 'N/A'),
				getEntityObj(cvLoc('entity.overview.label.documents').toUpperCase(), true, 'N/A'),
				getEntityObj(cvLoc('entity.overview.label.size').toUpperCase(), true, 'N/A'),
				getEntityObj(cvLoc('entity.overview.label.indexServers').toUpperCase(), false, 'N/A')
			];
			function getEntityObj(title, addSeperator, value) {
				return {
					title: {
						value: title,
						placement: 'top'
					},
					value: value,
					type: PaneEntityTypes.OVERVIEW,
					entityClass: entityClass,
					addSeperator: addSeperator
				};
			}

			this.overviewPane = {
				title: cvLoc('usageOverview.title')
			};

			this.getOverviewStats = () => {
				//this.overviewPane.showLoader = true;
				const entities = [];
				this.overviewPane.entities = overviewEntitiesInfo;
			};
			this.getOverviewStats();
		};
	}
]);
