import 'modules/reports/js/directives/cv-reports-pane-directive.js';
import 'modules/reports/js/directives/cv-reports-pane-highchart-directive.js';
import 'modules/reports/js/factory/reports.factory.js';

import { reportsDashboardModule } from 'common/js/modules';

/**
 * Shows the Dashboard for Orchestration
 */

reportsDashboardModule.controller('storagePane', [
	'cvLoc',
	'reportsDashboardFactory',
	function(cvLoc, reportsDashboardFactory) {
		var self = this;

		var storageType = [];
		var dataStoredTB = [];

		var storagePaneData = {
			isHighChart: true,
			showLoader: true,
			paneClass: 'row3',
			title: cvLoc('pane.storage.title'),
			titleDetailsLink: '#/storage',
			config: {
				options: {
					colors: ['#1ebe50'],
					chart: {
						type: 'bar'
					},
					useHighStocks: false,
					exporting: false,
					plotOptions: {
						series: {
							pointWidth: 25
						},
						bar: {
							dataLabels: {
								enabled: true,
								format: '{y} TB'
							}
						}
					},
					legend: {
						enabled: false
					}
				},
				tooltip: {
					valueSuffix: ' millions'
				},
				series: [
					{
						name: 'Storage',
						data: dataStoredTB
					}
				],
				title: {
					text: null
				},
				loading: false,
				xAxis: {
					categories: storageType,
					title: {
						text: null
					}
				},
				yAxis: {
					min: 0,
					title: {
						text: null
					}
				},
				size: {
					width: 500,
					height: 250
				}
			}
		};

		self.storage = {
			dataFetched: false,
			expectedColumns: {
				storagetype: {
					index: -1
				},
				datastoredtb: {
					index: -1
				}
			},
			paneData: storagePaneData,
			datasetName: 'CloudStorageUsage',
			noData: {
				text: cvLoc('noData.storage')
			},
			error: cvLoc('error.storage')
		};

		createInputs(self.storage);

		/*
		 * Gets the dataset and extracts the inputs required for the highchart Look at the response of the dataset
		 * to understand the function
		 */
		function createInputs(entityObject) {
			if (entityObject && entityObject.expectedColumns && entityObject.datasetName) {
				reportsDashboardFactory
					.getDataset(entityObject.datasetName)
					.success(function(data) {
						entityObject.paneData.showLoader = false;
						entityObject.dataFetched = true;
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							data.columns.forEach(function(column, index) {
								var found = entityObject.expectedColumns[column.name.toLowerCase()];
								if (found) {
									entityObject.expectedColumns[column.name.toLowerCase()].index = index;
								}
							});

							data.records.forEach(function(record, index) {
								var type = removeSpaces(record[self.storage.expectedColumns['storagetype'].index]).toLowerCase();
								storageType.push(cvLoc('label.' + type));
								dataStoredTB.push(record[self.storage.expectedColumns['datastoredtb'].index] || 0);
							});
						} else {
							entityObject.paneData.noData = entityObject.noData;
						}
					})
					.error(function(e) {
						entityObject.paneData.showLoader = false;
						reportsDashboardFactory.showErrorMessage(e ? e.errorMessage : cvLoc('generic_error'));
						entityObject.paneData.noData = {
							text: entityObject.error
						};
					});
			}
		}

		function removeSpaces(str) {
			return str.replace(/ /g, '');
		}
	}
]);

export default reportsDashboardModule;
