import 'modules/reports/js/directives/cv-reports-pane-directive.js';
import 'modules/reports/js/directives/cv-reports-pane-highchart-directive.js';
import 'modules/reports/js/factory/reports.factory.js';

import { reportsDashboardModule } from 'common/js/modules';

/**
 * Shows the Dashboard for Orchestration
 */

reportsDashboardModule.controller('cloudBackupThroughputPane', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	function(cvLoc, reportsDashboardService, reportsDashboardFactory) {
		var self = this;

		var seriesData = [];
		var seriesMap = new Map();
		var cloudBackupPaneData = {
			isHighChart: true,
			showLoader: true,
			paneClass: 'row3',
			title: cvLoc('pane.cloudBackupThroughput.title'),
			config: {
				title: {
					text: ''
				},
				xAxis: {
					type: 'datetime',
					dateTimeLabelFormats: {
						month: "%b '%y",
						year: '%Y'
					},
					title: {
						text: ''
					}
				},
				yAxis: {
					title: {
						text: cvLoc('cloudBackupThroughput.yAxis.title')
					}
				},
				legend: {
					layout: 'vertical',
					align: 'bottom',
					verticalAlign: 'middle'
				},
				plotOptions: {
					series: {
						label: {
							connectorAllowed: false
						}
					}
				},
				series: seriesData,
				options: {
					exporting: false
				},
				size: {
					width: 500,
					height: 250
				}
			}
		};

		self.cloudBackup = {
			dataFetched: false,
			expectedColumns: {
				date: {
					index: -1
				},
				type: {
					index: -1
				},
				throughput: {
					index: -1
				}
			},
			paneData: cloudBackupPaneData,
			datasetName: 'CloudBackupThroughput',
			noData: {
				text: cvLoc('noData.cloudBackup')
			},
			error: cvLoc('error.cloudBackup')
		};

		createInputs(self.cloudBackup);

		/*
		 * Gets the dataset and extracts the inputs required for the highchart Look at the response of the dataset
		 * to understand the function
		 */
		function createInputs(entityObject) {
			if (entityObject && entityObject.expectedColumns && entityObject.datasetName) {
				reportsDashboardFactory
					.getDataset(entityObject.datasetName)
					.success(function(data) {
						entityObject.paneData.showLoader = false;
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							data.columns.forEach(function(column, index) {
								var found = entityObject.expectedColumns[column.name.toLowerCase()];
								if (found) {
									entityObject.expectedColumns[column.name.toLowerCase()].index = index;
								}
							});

							var expectedColumns = entityObject.expectedColumns;
							data.records.forEach(function(record, index) {
								var key = record[expectedColumns['type'].index];
								var date = getDate(record[expectedColumns['date'].index]);
								var value = record[expectedColumns['throughput'].index];
								var value = [date, value];
								if (seriesMap.get(key)) {
									seriesMap.get(key).push(value);
								} else {
									seriesMap.set(key, [value]);
								}
							});

							seriesMap.forEach(function(value, key) {
								seriesData.push({
									name: cvLoc('label.' + removeSpaces(key.toLowerCase())),
									data: value
								});
							});
						} else {
							entityObject.paneData.noData = entityObject.noData;
						}
					})
					.error(function(e) {
						entityObject.paneData.showLoader = false;
						reportsDashboardFactory.showErrorMessage(e.errorMessage);
						entityObject.paneData.noData = {
							text: entityObject.error
						};
					});
			}
		}

		function getDate(dateStr) {
			if (dateStr.indexOf('-') > -1) {
				var split = dateStr.split('-');
				if (split.length == 3) {
					return Date.UTC(split[0], split[1], split[2]);
				} else {
					return '';
				}
			} else {
				return '';
			}
		}

		function removeSpaces(str) {
			return str.replace(/ /g, '');
		}
	}
]);

export default reportsDashboardModule;
