import { reportsDashboardModule } from 'common/js/modules';

reportsDashboardModule.controller('NewDashboardModalController', [
	'$scope',
	'$uibModalInstance',
	'$state',
	'reportsDashboardFactory',
	'cvLoc',
	'cvUtil',
	'userPrefService',
	'reportService',
	'DashboardSettings',
	'ReportsConstants',
	'REGEX',
	'data',
	function(
		$scope,
		$modalInstance,
		$state,
		reportsDashboardFactory,
		cvLoc,
		cvUtil,
		userPrefService,
		reportService,
		DashboardSettings,
		ReportsConstants,
		REGEX,
		data
	) {
		const numberOnlyPattern = REGEX.NUMBER_ONLY;
		const alphaNumericPattern = REGEX.ALPHANUMERIC;

		$scope.model = {
			dashboardName: data.defaultName ? data.defaultName : '',
			defaultDashboards: data.defaultDashboard,
			dropdownLocal: cvUtil.getIStevenLocLabels(),
			selectedDashboard: []
		};

		$scope.model.dropdownLocal.nothingSelected = cvLoc('dashboard.selectDashboardToDuplicate');
		$scope.nameError = false;
		$scope.dashboardError = false;
		if (data.defaultDashboard && data.defaultDashboard.length > 0) {
			data.defaultDashboard[0].selected = true;
			$scope.model.selectedDashboard.push(data.defaultDashboard[0]);
		}
		$scope.modalParams = data;
		//		$scope.saveAsMode = data.saveAsMode;
		$scope.cloneMode = data.cloneMode;
		if (data.cloneMode) {
			$scope.headerInfo = cvLoc('dashboard.saveAsInfo') + ' ' + cvLoc('dashboard.newDashNote');
		} else {
			$scope.headerInfo = cvLoc('dashboard.cloneInfo');
		}
		$scope.modalOptions = {
			headerText: $scope.modalParams.modalTitle,
			headerInfo: $scope.headerInfo,
			cancelButtonText: cvLoc('dashboard.cancel'),
			okButtonText: cvLoc('OK'),
			cloneDashboard: function() {
				if (
					!$scope.model.dashboardName ||
					($scope.cloneMode && $scope.model.dashboardName === $scope.modalParams.origName)
				) {
					$scope.nameError = true;
				} else if (!$scope.model.selectedDashboard) {
					$scope.dashboardError = true;
				} else {
					if (numberOnlyPattern.test($scope.model.dashboardName)) {
						$scope.nameError = true;
						return;
					}

					let dTiles = [];
					let dashType;
					if ($scope.cloneMode) {
						angular.copy($scope.modalParams.tiles, dTiles);
						dashType = $scope.modalParams.dashboardType;
					} else {
						let selectedDashboard = $scope.model.selectedDashboard[0];
						dashType = selectedDashboard.dashboardType;

						if (selectedDashboard.category === ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN) {
							let dashData = reportsDashboardFactory.getDefaultDashboardTiles(selectedDashboard.dashboardId);
							angular.copy(dashData.tiles, dTiles);
							reportsDashboardFactory.applyDashboardSizeOverrides(dTiles, dashData.sizeOverrides);
						} else {
							let params = {
								includeDrafts: true,
								reportName: '',
								reportId: selectedDashboard.dashboardId
							};

							if (
								selectedDashboard.category === ReportsConstants.DASHBOARD_CATEGORIES.CUSTOM_BUILT_IN &&
								cv.sessionContext[ReportsConstants.SESSION_DASHBOARD_OVERRIDES]
							) {
								let overrides = cv.sessionContext[ReportsConstants.SESSION_DASHBOARD_OVERRIDES];
								if (overrides[selectedDashboard.dashboardId]) {
									params.reportId = overrides[selectedDashboard.dashboardId];
								}
							}

							reportService
								.getCustomReport(params)
								.then(function(data) {
									if (data) {
										data = data.data;
									}
									if (data && data.pages && data.pages.length > 0) {
										let dashboardData = JSON.parse(data.pages[0].body);
										angular.copy(dashboardData.tiles, dTiles);
										$scope.processClone($scope.model.dashboardName, dashType, dTiles);
									} else {
										console.log('Error fetching tiles');
										reportsDashboardFactory.showErrorMessage(cvLoc('generic_error'));
									}
								})
								.catch(function(err) {
									console.log('Error fetching dashboard data');
									reportsDashboardFactory.showErrorMessage(cvLoc('generic_error'));
								});
							return;
						}
					}

					$scope.processClone($scope.model.dashboardName, dashType, dTiles);
				}
			},
			close: function() {
				$modalInstance.dismiss();
			}
		};

		$scope.processClone = function(dName, dType, dTiles) {
			let dashboardData = {
				dashboardName: dName,
				dashboardType: dType,
				tiles: dTiles
			};

			let guid = cvUtil.generateUUID();
			let reportData = {
				report: {
					customReportName: dName
				},
				userReportId: guid,
				guid: guid,
				type: '3',
				reportDescription: 'Command Center Custom Dashboard', //do not localize
				reportTitle: {
					text: dName
				},
				pages: [
					{
						body: JSON.stringify(dashboardData)
					}
				]
			};

			let tileProp = {
				dashboardType: dType
			};
			reportData.tileProperties = JSON.stringify(tileProp);

			reportService
				.saveReport(reportData)
				.then(function(data) {
					if (data) {
						data = data.data;
					}

					reportService
						.deployReport(data.report.customReportId)
						.then(function() {
							$modalInstance.close();
							cv.sessionContext[ReportsConstants.SESSION_EDITDASHBOARD_MODE] = true;
							$state.go('dashboard', { dashboardId: data.userReportId });
						})
						.catch(function(err) {
							if (err.xhrStatus !== 'abort') {
								console.log('Deploy error');
								console.log(err);
								reportsDashboardFactory.showErrorMessage(cvLoc('dashboard.error.saveAndDeploy'));
							}
						});
				})
				.catch(function(err) {
					console.log('Save error');
					console.log(err);
					reportsDashboardFactory.showErrorMessage(cvLoc('dashboard.error.saveAndDeploy'));
				});
		};

		$scope.validateNameInput = function(event) {
			let charCode = event.charCode || event.which;
			//space
			if (charCode == 32) {
				return;
			}

			let key = String.fromCharCode(charCode);

			if (!alphaNumericPattern.test(key)) {
				event.preventDefault();
			}
		};
	}
]);

export default reportsDashboardModule;
