import { reportsDashboardModule } from 'common/js/modules';

import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/constants/reports.constants.js';
import 'modules/reports/js/directives/cv-reports-no-data-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';

var app = reportsDashboardModule;

app.controller('NeedsAttentionServersController', [
	'$state',
	'$stateParams',
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvBreadcrumbsTabsFactory',
	'tabService',
	'cvToaster',
	function NeedsAttentionServersController(
		$state,
		$stateParams,
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		cvBreadcrumbsTabsFactory,
		tabService,
		cvToaster
	) {
		var self = this;
		self.data = {};

		self.serverImg = appUtil.appRoot + 'common/img/servers.svg';

		var tabs = reportsDashboardFactory.getNeedsAttentionTabs();
		let pageTabs = [];
		pageTabs.push(tabs.SERVERS);
		if (_.has(cv, 'sessionContext.loggedInUserRole') && cv.sessionContext.loggedInUserRole !== 'Role_Tenant_User') {
			pageTabs.push(tabs.INFRASTRUCTURES);
		}

		tabService.init({
			tabs: pageTabs,
			actions: [],
			onActionItemSelect: function() {},
			activeTab: tabs.SERVERS.tabIndex
		});

		angular.element('.content-page').addClass('need-attention-detail');
		var navSource = $stateParams['nav'];
		tabService.setParam('nav', navSource);

		var navs = [];
		if (navSource) {
			navs = navSource.split(',');
		}

		//add breadcrumb

		let title = 'title.' + navs[0];
		if (navs[0].indexOf('dashboard') != -1) {
			title = 'title.dashboard';
		}
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc(title),
				link: '#/' + navs[0]
			}
		]);

		//secondary page
		if (navs.length > 1) {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('title.' + navs[1]),
					link: '#/' + navs[1] + '/?nav=' + navs[0]
				}
			]);
		}

		var AnomalyTypesToReason = {
			0: cvLoc('servers.detail.allBad'),
			1: cvLoc('servers.detail.failedJob'),
			2: cvLoc('servers.detail.missedSLA'),
			4: cvLoc('servers.detail.highCPUUsage'),
			8: cvLoc('servers.detail.highMemoryUsage'),
			16: cvLoc('servers.detail.memoryLeak'),
			32: cvLoc('servers.detail.unreachable')
		};

		var AnomalyType = {
			FailedJob: 1,
			Unreachable: 32,
			DrClient: 64
		};

		processData();

		function processData() {
			self.data.showLoader = true;

			let drDashboradFilter = '';
			if ($stateParams['nav'] === 'dashboard/disasterRecovery') {
				drDashboradFilter = AnomalyType.DrClient;
			}
			var anomaly = AnomalyType.FailedJob | AnomalyType.Unreachable;

			reportsDashboardService
				.getServerNeedsAttentionData(anomaly, drDashboradFilter)
				.success(function(data) {
					if (!data) {
						console.log('No records found for servers.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					if (!data.anomalousClients || data.anomalousClients.length <= 0) {
						console.log('Records has no rows. Returning false.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					self.data.showLoader = false;
					formatData(data);
				})
				.error(function(err) {
					console.log(err);
					self.data.showLoader = false;
					self.data.noData = { text: cvLoc('dashboard.error.server') };
					cvToaster.showErrorMessage({
						message: 'Needs Attention - Servers: ' + err.errorMessage
					});
				});
		}

		function formatData(rawData) {
			angular.forEach(rawData.anomalousClients, function(rowData) {
				rowData.detailsLink = '#/clientDetails/' + rowData.entity.clientId;
				angular.forEach(rowData.anomalyDetails, function(detail) {
					detail.reason = AnomalyTypesToReason[detail.type];
					if (detail.type == 1) {
						detail.countLabel = cvLoc('servers.detail.jobsAffected') + ':';
						detail.formattedCount = detail.currentCount;
						var serverIdParam = '';
						if (rowData.entity.clientId) {
							serverIdParam = '&serverId=' + rowData.entity.clientId;
						}
						detail.drillURL = '#/jobs?view=finishedJobs1' + serverIdParam;
					} else if (detail.type == 32) {
						detail.countLabel = '';
						detail.formattedCount = detail.currentCount;
					}
				});
			});

			self.data.servers = rawData.anomalousClients;
		}
	}
]);

export default app;
