import { reportsDashboardModule } from 'common/js/modules';

reportsDashboardModule.constant('ChartColors', {
	SUCCESS: '#1ebe50',
	FAILURE: '#ee4743',
	PARTIALSUCCESS: '#FF9800',
	KILLED: '#777777',
	SKIPPED: '#348ab4',
	WITHIN_CAPACITY: '#03C04A',
	OVER_CAPACITY: '#F1453D',
	WARNING: '#FF9800',
	LOANED_CAPACITY: '#AAA8A8',
	LICENSE_NOT_APPLIED: '#868686',
	CAPACITY_TOTAL: '#ededed'
});

reportsDashboardModule.constant('AnomalousEntityTypes', {
	All: 0,
	Events: 1,
	Jobs: 2,
	Servers: 4,
	Infrastructure: 8,
	drServers: 16,
	drJobs: 32,
	drInfrastructure: 64
});

reportsDashboardModule.constant('AnomalyTypes', {
	All: 0,
	FailedJob: 1,
	MissedSLA: 2,
	HighCPUUsage: 4,
	HighMemoryUsage: 8,
	MemoryLeak: 16,
	Unreachable: 32
});

const ENVIRONMENT = {
	tileType: 'ENVIRONMENT',

	sizeX: 6,
	sizeY: 2
};

const NEED_ATTENTION = {
	tileType: 'NEED_ATTENTION',
	sizeX: 6,
	sizeY: 2
};

const SLA = {
	tileType: 'SLA',
	sizeX: 3,
	sizeY: 4
};

const JOB_STATUS = {
	tileType: 'JOB_STATUS',
	sizeX: 7,
	sizeY: 4
};

const HEALTH = {
	tileType: 'HEALTH',
	sizeX: 2,
	sizeY: 4
};

const CURRENT_CAPACITY = {
	tileType: 'CURRENT_CAPACITY',
	sizeX: 3,
	sizeY: 6
};

const DISK_SPACE = {
	tileType: 'DISK_SPACE',
	sizeX: 4,
	sizeY: 6
};

const LARGEST_SERVERS = {
	tileType: 'LARGEST_SERVERS',
	sizeX: 3,
	sizeY: 6
};

const STORAGE = {
	tileType: 'STORAGE',
	sizeX: 2,
	sizeY: 6
};

const HYPERVISORS = {
	tileType: 'HYPERVISORS',
	sizeX: 6,
	sizeY: 3
};

const VMS = {
	tileType: 'VMS',
	sizeX: 6,
	sizeY: 3
};

const JOB_SUMMARY = {
	tileType: 'JOB_SUMMARY',
	sizeX: 6,
	sizeY: 6
};

const LARGEST_HYPERVISORS = {
	tileType: 'LARGEST_HYPERVISORS',
	sizeX: 6,
	sizeY: 6
};

const LAPTOP_LOCATION = {
	tileType: 'LAPTOP_LOCATION',
	sizeX: 6,
	sizeY: 6
};

const LAPTOP_COUNT = {
	tileType: 'LAPTOP_COUNT',
	sizeX: 4,
	sizeY: 2
};

const USER_COUNT = {
	tileType: 'USER_COUNT',
	sizeX: 4,
	sizeY: 2
};

const ALERT_COUNT = {
	tileType: 'ALERT_COUNT',
	sizeX: 4,
	sizeY: 2
};

const SYSTEM = {
	tileType: 'SYSTEM',
	sizeX: 4,
	sizeY: 4
};

const HYPERSCALE_HARDWARE = {
	tileType: 'HYPERSCALE_HARDWARE',
	sizeX: 6,
	sizeY: 5
};

const CUSTOM_REPORT = {
	tileType: 'CUSTOM_REPORT',
	sizeX: 6,
	sizeY: 6,
	reportId: 0,
	reportName: ''
};

const SDA = {
	tileType: 'ACTIVATE_SDA',
	sizeX: 6,
	sizeY: 3
};
const REQUEST_MANAGER = {
	tileType: 'ACTIVATE_REQ_MANAGER',
	sizeX: 6,
	sizeY: 3
};

const FSO = {
	tileType: 'ACTIVATE_FSO',
	sizeX: 6,
	sizeY: 3
};

const CASE_MANAGER = {
	tileType: 'ACTIVATE_CASE_MANAGER',
	sizeX: 6,
	sizeY: 3
};

const LAST_MONTH_STATS = {
	tileType: 'LAST_MONTH_STATS',
	sizeX: 6,
	sizeY: 5
};

const SITE_REPLICATION = {
	tileType: 'SITE_REPLICATION',
	sizeX: 6,
	sizeY: 5
};

const DRENVIRONMENT = {
	tileType: 'DRENVIRONMENT',

	sizeX: 6,
	sizeY: 2
};

reportsDashboardModule.constant('DashboardSettings', {
	allTiles: {
		ENVIRONMENT: ENVIRONMENT,
		NEED_ATTENTION: NEED_ATTENTION,
		SLA: SLA,
		JOB_STATUS: JOB_STATUS,
		HEALTH: HEALTH,
		CURRENT_CAPACITY: CURRENT_CAPACITY,
		DISK_SPACE: DISK_SPACE,
		LARGEST_SERVERS: LARGEST_SERVERS,
		STORAGE: STORAGE,
		HYPERVISORS: HYPERVISORS,
		VMS: VMS,
		JOB_SUMMARY: JOB_SUMMARY,
		LARGEST_HYPERVISORS: LARGEST_HYPERVISORS,
		LAPTOP_LOCATION: LAPTOP_LOCATION,
		LAPTOP_COUNT: LAPTOP_COUNT,
		USER_COUNT: USER_COUNT,
		ALERT_COUNT: ALERT_COUNT,
		HYPERSCALE_HARDWARE: HYPERSCALE_HARDWARE,
		SYSTEM: SYSTEM,
		ACTIVATE_SDA: SDA,
		ACTIVATE_REQ_MANAGER: REQUEST_MANAGER,
		ACTIVATE_FSO: FSO,
		ACTIVATE_CASE_MANAGER: CASE_MANAGER,
		LAST_MONTH_STATS: LAST_MONTH_STATS,
		SITE_REPLICATION: SITE_REPLICATION,
		DRENVIRONMENT: DRENVIRONMENT
	},
	defaultTiles: {
		hyperscalepure: {
			tiles: [ENVIRONMENT, NEED_ATTENTION, SLA, JOB_STATUS, LARGEST_SERVERS, HYPERSCALE_HARDWARE, DISK_SPACE],
			sizeOverrides: {
				SLA: [
					{
						name: 'sizeX',
						value: 3
					}
				],
				JOB_STATUS: [
					{
						name: 'sizeX',
						value: 6
					}
				],
				LARGEST_SERVERS: [
					{
						name: 'sizeX',
						value: 3
					},
					{
						name: 'sizeY',
						value: 4
					}
				],
				DISK_SPACE: [
					{
						name: 'sizeX',
						value: 6
					},
					{
						name: 'sizeY',
						value: 5
					}
				]
			}
		},
		hyperscale: {
			tiles: [ENVIRONMENT, NEED_ATTENTION, SLA, JOB_STATUS, SYSTEM, HEALTH, DISK_SPACE, LARGEST_SERVERS],
			sizeOverrides: {
				SLA: [
					{
						name: 'sizeX',
						value: 2
					}
				],
				JOB_STATUS: [
					{
						name: 'sizeX',
						value: 6
					}
				],
				SYSTEM: [
					{
						name: 'sizeX',
						value: 4
					},
					{
						name: 'sizeY',
						value: 4
					}
				],
				HEALTH: [
					{
						name: 'sizeX',
						value: 3
					},
					{
						name: 'sizeY',
						value: 6
					}
				],
				DISK_SPACE: [
					{
						name: 'sizeX',
						value: 6
					}
				],
				LARGEST_SERVERS: [
					{
						name: 'sizeX',
						value: 3
					}
				]
			}
		},
		commcell: {
			tiles: [
				ENVIRONMENT,
				NEED_ATTENTION,
				SLA,
				JOB_STATUS,
				HEALTH,
				CURRENT_CAPACITY,
				DISK_SPACE,
				LARGEST_SERVERS,
				STORAGE
			]
		},
		hyperscalecommcell: {
			tiles: [
				ENVIRONMENT,
				NEED_ATTENTION,
				SLA,
				JOB_STATUS,
				HEALTH,
				CURRENT_CAPACITY,
				DISK_SPACE,
				LARGEST_SERVERS,
				STORAGE
			]
		},
		tenant: {
			tiles: [ENVIRONMENT, NEED_ATTENTION, SLA, JOB_STATUS, JOB_SUMMARY, LARGEST_SERVERS],
			sizeOverrides: {
				SLA: [
					{
						name: 'sizeX',
						value: 4
					}
				],
				JOB_STATUS: [
					{
						name: 'sizeX',
						value: 8
					}
				],
				LARGEST_SERVERS: [
					{
						name: 'sizeX',
						value: 6
					}
				]
			}
		},
		virtualization: {
			tiles: [HYPERVISORS, VMS, SLA, JOB_STATUS, JOB_SUMMARY, LARGEST_HYPERVISORS],
			sizeOverrides: {
				SLA: [
					{
						name: 'sizeX',
						value: 4
					}
				],
				JOB_STATUS: [
					{
						name: 'sizeX',
						value: 8
					}
				]
			}
		},
		endpoint: {
			tiles: [LAPTOP_COUNT, USER_COUNT, ALERT_COUNT, SLA, JOB_STATUS, JOB_SUMMARY, LAPTOP_LOCATION],
			sizeOverrides: {
				SLA: [
					{
						name: 'sizeX',
						value: 5
					}
				]
			}
		},
		activate: {
			tiles: [SDA, REQUEST_MANAGER, FSO, CASE_MANAGER]
		},
		disasterRecovery: {
			tiles: [DRENVIRONMENT, NEED_ATTENTION, SLA, JOB_STATUS, LAST_MONTH_STATS, SITE_REPLICATION],
			sizeOverrides: {
				SLA: [
					{
						name: 'sizeX',
						value: 4
					}
				],
				JOB_STATUS: [
					{
						name: 'sizeX',
						value: 8
					}
				]
			}
		}
	}
});

reportsDashboardModule.constant('ReportsConstants', {
	DASHBOARD_DATASET: 'b7d18c11-c4d8-435c-a978-16ef7c36fef8',
	REPORT_ID_INDEX: 2,
	USER_REPORT_ID_INDEX: 3,
	REPORT_NAME_INDEX: 4,
	FLAGS_INDEX: 14,
	PROPS_INDEX: 25,
	DASHBOARD_CATEGORIES: {
		CLASSIC: 'classic',
		BUILT_IN: 'builtin',
		CUSTOM: 'custom',
		CUSTOM_BUILT_IN: 'custom_builtin'
	},
	SESSION_EDITDASHBOARD_MODE: 'editDashboardMode',
	SESSION_DASHBOARD_OVERRIDES: 'dashboardOverrides',
	ENTITY_TYPES_ID: {
		//As defined in CVEntities.EntityType
		USER_ENTITY: 13,
		USERGROUP_ENTITY: 15,
		EXTERNAL_GROUP_ENTITY: 62,
		CUSTOM_ENTITY: 150,
		PERMISSION_ENTITY: 122,
		REPORT_PLUS_ENTITY: 131
	},
	REPORT_EXECUTE_CAPABILITY_ID: 132,
	REPORT_PERMISSION_CATEGORY_ID: 112,
	DASHBOARD_TYPES: {
		COMMCELL: 'commcell',
		SERVER: 'server',
		APPLIANCE: 'appliance',
		APPLIANCE_COMMCELL: 'appliancecommcell',
		VIRTUALIZATION: 'virtualization',
		ORCHESTRATION: 'orchestration',
		ENDPOINT: 'endpoint',
		ACTIVATE: 'activate',
		DISASTER_RECOVERY: 'disasterRecovery'
	},
	GX_GLOBAL_PARAMS: {
		FORCE_SCRUB_FILES: 'SendLogsForceScrubFiles'
	},
	USER_PREFS: {
		SEND_LOGS_OPTIONS: 'sendLogsOptions'
	}
});

export default reportsDashboardModule;
