<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div >
		<div class="setup-title">
			<h1><fmt:message key="pageHeader.editAssociation" /></h1>
		</div>

		<form name="editAssociationForm" novalidate data-cv-submit="saveAssociation()" autocomplete="off" class="add-collection-form edit-association-form">
			<div class="setup-content padding-bottom-10">
				<div class="row">
						<div class="col-md-12">

							<span>
								<input type="checkbox" name="dissociateBackupSet" id="dissociateBackupSet" data-ng-model="dissociateBackupsets" />
								<label class="checkbox-label" for="dissociateBackupSet"><cv:msg key="label.dissociateBackupSet" bundle="collections"/>
									<cv-help-component help-text='<cv:msg key="helpText.dissociateBackupSet" bundle="collections"/>'></cv-help-component>
								</label>
							</span>

						</div>
				</div>
				<h4 class="text-left margin-left-5 col-lg-9"><cv:msg key="label.selectAssociations" bundle="schedule" /></h4>
			</div>

			<cv-entity-selection-tree-component class="policy-modal-custom-tree-margin"
					data-mode="edit"
					data-tree-options="associationsTreeParams">
			</cv-entity-selection-tree-component>
			<div class="setup-content">
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="editSCPolicyAssociation_button_#7120" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
				  		<button id="editSCPolicyAssociation_button_#6333" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button>
				  	</fmt:bundle>
				</div>
			</div>
			</form>

	</div>
</fmt:bundle>