<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.addSubclientPolicy" bundle="collections" />
	</h1>
</div>
<div data-ng-controller="createSubClientPolicyController as createSCPCtrl">
	<div class="serverMessage" ng-class="createSCPCtrl.policyServerMessage.type"
		data-ng-bind="createSCPCtrl.policyServerMessage.message"></div>
	<form name="createSUbclientPolicyForm" data-cv-submit="createSCPCtrl.createPolicy()"
		data-cv-validate="true" novalidate autocomplete="off">
		<div class="setup-content noPadding">
		<div class="global-options remove-border-padding">
			<label for="policyName"><cv:msg key="label.name"
					bundle="collections" /> <input type="text" name="policyName"
				data-ng-model="createSCPCtrl.policyData.name" id="policyName"
				data-ng-change="createSCPCtrl.inputAlertFlags.subclientPolicyName = false"
				autofocus /> <span class="help-block"
				data-ng-if="createSCPCtrl.inputAlertFlags.subclientPolicyName"><cv:msg
						key="error.subclientPolicyName" bundle="collections" /></span> <span
				class="help-block" data-ng-if="false"><cv:msg
						key="error.duplicateSubclientPolicyName" bundle="collections" /></span>
			</label>
		</div>
		<div class="global-options remove-border-padding">
			<label for="primaryStorage" class="select-label"><cv:msg
					key="label.agent" bundle="collections" /> <select
				data-ng-disabled="createSCPCtrl.policyData.iDataAgent.id" id="primaryStorage"
				name="primaryStorage" data-ng-model="createSCPCtrl.policyData.iDataAgent"
				data-ng-options="iDataAgent.name for iDataAgent in createSCPCtrl.iDataAgentOptions"
				data-ng-change="createSCPCtrl.selectIDataAgent(createSCPCtrl.policyData.iDataAgent);createSCPCtrl.inputAlertFlags.iDataAgent=false">
					<option value="" selected hidden><cv:msg
							key="placeholder.selectiDataAgent" bundle="collections" /></option>
			</select> <span class="help-block" data-ng-if="createSCPCtrl.inputAlertFlags.iDataAgent"><cv:msg
						key="error.iDataAgent" bundle="collections" /></span> </label>
		</div>
		<div>
			<uib-accordion close-others="true" class="text-left">
			<div uib-accordion-group is-disabled="!createSCPCtrl.policyData.iDataAgent.id"
				is-open="createSCPCtrl.accordionStatus.subclients">
				<uib-accordion-heading> <i class="glyphicon"
					data-ng-class="{'glyphicon-chevron-down': createSCPCtrl.accordionStatus.subclients, 'glyphicon-chevron-right': !createSCPCtrl.accordionStatus.subclients}"></i>
				<cv:msg key="label.subclient" bundle="collections" /> <a
					data-ng-if="createSCPCtrl.accordionStatus.subclients"
					class="pull-right accordion-heading-action-link"
					data-ng-click="$event.stopPropagation();$event.preventDefault();createSCPCtrl.createSubclient()"><cv:msg
						key="action.addSubclient" bundle="collections" /></a> </uib-accordion-heading>
				<div class="subclientsFSCP">
					<cv-grid cv-grid-options="createSCPCtrl.gridOptions"></cv-grid>
				</div>
				<span class="help-block"
					data-ng-if="createSCPCtrl.inputAlertFlags.storagePolicyForDefault"><cv:msg
						key="error.storagePolicy" bundle="collections" /></span>
			</div>
			</uib-accordion>
		</div>
		</div>
		<!-- Association -->
		<div>
			<uib-accordion close-others="true" class="text-left">
			<div uib-accordion-group is-disabled="!createSCPCtrl.policyData.iDataAgent.id"
				is-open="createSCPCtrl.accordionStatus.associations">
				<uib-accordion-heading> <i class="glyphicon"
					data-ng-class="{'glyphicon-chevron-down': createSCPCtrl.accordionStatus.associations, 'glyphicon-chevron-right': !createSCPCtrl.accordionStatus.associations}"></i>
				<cv:msg key="label.association" bundle="users" /> </uib-accordion-heading>
					<div class="row">
						<div class="col-md-12">
							<span>
								<input type="checkbox" name="dissociateBackupSet" id="dissociateBackupSet" data-ng-model="createSCPCtrl.policyData.dissociateBackupsets" />
	                   		<label class="checkbox-label" for="dissociateBackupSet"><cv:msg key="label.dissociateBackupSet" bundle="collections"/>
	                   			<cv-help-component help-text='<cv:msg key="helpText.dissociateBackupSet" bundle="collections"/>'></cv-help-component>
	                   		</label>
							</span>		
						</div>
					</div>
				<cv-entity-selection-tree-component
					id="SubclientPolicyAssociations"
					data-ng-if="createSCPCtrl.associations"
					data-tree-options="createSCPCtrl.modal.associationsTreeParams">
				</cv-entity-selection-tree-component>
			</div>
			</uib-accordion>
		</div>
		<div class="setup-content">
		<div class="button-container">
			<button id="createSubclientPolicy_button_#4654" type="button" 
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="cancel()">
				<cv:msg key="action.cancel" bundle="profiles" />
			</button>
			<button id="createSubclientPolicy_button_#7190" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<cv:msg key="action.save" bundle="profiles" />
			</button>
			</div>
		</div>
	</form>
</div>