import { policyModule } from 'common/js/modules';

var subclientPolicyServiceMod = policyModule;
subclientPolicyServiceMod.service('subclientPolicyService', [
	'$http',
	'$q',
	function($http, $q) {
		this.getSubclientPoliciesList = function() {
			return $http.get('subclientPolicies.do', {});
		};
		this.renameSubclientPolicy = function(id, name) {
			return $http.post('renameSubclientPolicy.do?subclientPolicyId=' + id + '&subclientPolicyName=' + name);
		};
		this.getSubclientPolicyDetails = function(profileId) {
			return $http.get('subclientpolicyDetail.do?subClientPolicyId=' + profileId);
		};
		this.deleteSubclientPolicy = function(params) {
			return $http.post('deleteSubclientPolicy.do', params);
		};
		this.getSubclientPolicyAssociation = function(profileId, rootEntityType, rootEntityId, idaType) {
			return $http.get(
				'subclientPolicyAssociation.do?subClientPolicyId=' +
					profileId +
					'&idaType=' +
					idaType +
					'&rootEntityType=' +
					rootEntityType +
					'&rootEntityId=' +
					rootEntityId
			);
		};
		this.editAssociation = function(associationItems, subclientPolicyId, subclientPolicyName, dissociateBackupsets) {
			var params = {
				genericEntity: associationItems,
				subclientPolicyId: subclientPolicyId,
				subclientPolicyName: subclientPolicyName,
				dissociateBackupsets: dissociateBackupsets
			};
			return $http.post('editAssociation.do', params);
		};
		this.addSubclient = function(subclientPolicyId, subclientPolicyName, subclient) {
			var params = {
				subclientPolicyId: subclientPolicyId,
				subclientPolicyName: subclientPolicyName,
				subclient: subclient
			};
			return $http.post('addSubclientToSubclientPolicy.do', params);
		};
		this.createSubclientPolicy = function(policyName, iDataAgent, subclients, associations, dissociateBackupsets) {
			var params = {
				subclientPolicyName: policyName,
				iDataAgent: iDataAgent,
				subclients: subclients,
				associations: associations,
				dissociateBackupsets: dissociateBackupsets
			};
			return $http.post('createSubclientpolicy.do', params);
		};
	}
]);

export default subclientPolicyServiceMod;
