import 'adminConsole/js/factories/cvEntitySelectionTreeComponent.factory.js';

import { policyModule } from 'common/js/modules';

var subclientPolicyAssocFact = policyModule;

subclientPolicyAssocFact.factory('subclientPolicyAssocFactory', [
	'cvUtil',
	'cvEntitySelectionTreeComponent',
	function(cvUtil, cvEntitySelectionTreeComponent) {
		var factory = {};

		factory.processSubClientAssociations = function(response, parent) {
			var children = [],
				nodes = [],
				noChildNode = false,
				forceDisableFlag = false,
				entityType = _.get(parent, 'entity.entityTypeName');

			var hasClientGroupAncestor = entityType == 'CLIENT_GROUP_ENTITY' || parent.hasClientGroupAncestor;

			if (response.data) {
				if (entityType == 'ALL_CLIENTS' || entityType == 'CLIENT_GROUP_ENTITY') {
					if (angular.isArray(response.data.clients)) {
						nodes = cvUtil.sortAscending(response.data.clients, 'clientName');
					}
					forceDisableFlag = true;
				} else if (entityType === 'ALL_CLIENT_GROUPS_ENTITY') {
					if (angular.isArray(response.data.clientGroups)) {
						nodes = cvUtil.sortAscending(response.data.clientGroups, 'clientGroupName');
					}
				} else if (entityType === 'CLIENT_ENTITY') {
					if (angular.isArray(response.data.backupSets)) {
						nodes = cvUtil.sortAscending(response.data.backupSets, 'backupsetName');
					}
					if (_.get(parent, 'parentNode.entity.entityTypeName') === 'CLIENT_GROUP_ENTITY') {
						forceDisableFlag = true;
					}
					noChildNode = true;
				}

				if (angular.isArray(nodes)) {
					for (var i = 0, len = nodes.length; i < len; i++) {
						var childNode = nodes[i];

						var currentEntity = {};
						if (entityType == 'ALL_CLIENTS' || entityType == 'CLIENT_GROUP_ENTITY') {
							currentEntity.clientId = childNode.clientId;
							currentEntity.clientName = childNode.clientName;
							currentEntity.entityTypeName = 'CLIENT_ENTITY';
							currentEntity.label = childNode.clientName;
							currentEntity.entityId = childNode.clientId;
						} else if (entityType === 'ALL_CLIENT_GROUPS_ENTITY') {
							currentEntity.clientGroupId = childNode.clientGroupId;
							currentEntity.clientGroupName = childNode.clientGroupName;
							currentEntity.entityTypeName = 'CLIENT_GROUP_ENTITY';
							currentEntity.label = childNode.clientGroupName;
							currentEntity.entityId = childNode.clientGroupId;
						} else if (entityType === 'CLIENT_ENTITY') {
							currentEntity.backupsetId = childNode.backupsetId;
							currentEntity.backupsetName = childNode.backupsetName;
							currentEntity.entityTypeName = 'BACKUPSET_ENTITY';
							currentEntity.label = childNode.backupsetName;
							currentEntity.entityId = childNode.backupsetId;
							currentEntity.applicationId = childNode.applicationId;
							currentEntity.clientId = childNode.clientId;
							currentEntity.instanceId = childNode.instanceId;
						}

						children.push({
							ItemId: cvEntitySelectionTreeComponent.frameTreeNodeId(currentEntity, currentEntity.entityTypeName),
							ItemName: currentEntity.label,
							parentNode: parent,
							entity: currentEntity,
							forceDisable: forceDisableFlag,
							hasClientGroupAncestor: hasClientGroupAncestor,
							noChild: noChildNode
						});
					}
				}
			}
			return children;
		};

		factory.isSelectable = function() {
			return false;
		};

		return factory;
	}
]);

export default subclientPolicyAssocFact;
