import 'modules/policies/subclientPolicy/js/services/subclientPolicies.svc.js';
import 'modules/policies/subclientPolicy/js/controllers/createSubclientPolicy.ctrl.js';
import 'modules/policies/subclientPolicy/js/factory/subclientPolicy.factory.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'modules/policies/subclientPolicy/js/constants/subclientPolicyConstant.js';

import { getSubclientPolicyGridColumns } from 'modules/policies/subclientPolicy/js/controllers/subclientPolicies.column.template.js';

import { policyModule } from 'common/js/modules';

var subclientPolicyMod = policyModule;
var controllers = {};

controllers.subclientPolicyListController = [
	'$scope',
	'ENTITY_TYPES',
	'subclientPolicyFactory',
	'$state',
	'$http',
	'subclientPolicyService',
	'cvTableOptions',
	'cvLoc',
	'cvUtil',
	'$uibModal',
	'SUBCLIENT_POLICY_IDATA_AGENT',
	'uiGridConstants',
	'cvPermissionFactory',
	'$compile',
	'cvBreadcrumbsTabsFactory',
	function(
		$scope,
		ENTITY_TYPES,
		subclientPolicyFactory,
		$state,
		$http,
		subclientPolicyService,
		cvTableOptions,
		cvLoc,
		cvUtil,
		$modal,
		SUBCLIENT_POLICY_IDATA_AGENT,
		uiGridConstants,
		cvPermissionFactory,
		$compile,
		cvBreadcrumbsTabsFactory
	) {
		var self = this;
		$scope.serverMessage = cvUtil.infoMsgLoc('Loading');

		let _setupBreadCrumbs = () => {
			let breadCrumbs = [];

			breadCrumbs.push({
				title: cvLoc('label.nav.policies'),
				link: '#nav/policies'
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		_setupBreadCrumbs();

		$scope.getIdaType = function(idaTypeName) {
			return SUBCLIENT_POLICY_IDATA_AGENT[idaTypeName];
		};

		$scope.getIdaValue = function(idaTypeName) {
			switch (idaTypeName) {
				case 'MAC':
				case 'UNIX':
					return SUBCLIENT_POLICY_IDATA_AGENT.UNIXFS;
				case 'WINDOWS':
					return SUBCLIENT_POLICY_IDATA_AGENT.WINFS;
			}
			return -1;
		};

		$scope.getIdaLabel = function(idaValue) {
			switch (parseInt(idaValue)) {
				case SUBCLIENT_POLICY_IDATA_AGENT.UNIXFS:
					return cvLoc('label.unixFileSystem');
				case SUBCLIENT_POLICY_IDATA_AGENT.WINFS:
					return cvLoc('label.windowsFileSystem');
			}
			return '';
		};

		/* GRID CONTSTRUCTION */
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(globalGridOptions, {
			data: 'subClientPolicyList',
			showGridFooter: true,
			columnDefs: [
				{
					field: 'subclientPolicyEntity.subclientPolicyName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('column.name'),
					enableHiding: false,
					cellTemplate:
						'<div class="crop">\
								<a class="" title="{{row.entity.subclientPolicyEntity.subclientPolicyName}}" data-ng-href="#/subclientPolicyDetail/{{row.entity.subclientPolicyEntity.subclientPolicyId}}">{{row.entity.subclientPolicyEntity.subclientPolicyName}}</a>\
								</div>'
				},
				{
					field: 'idaType',
					displayName: cvLoc('column.iDataAgent'),
					minWidth: 150,
					width: '40%',
					filter: {
						type: uiGridConstants.filter.SELECT,
						disableCancelFilterButton: false,
						selectOptions: self.idaTypesList
					},
					filterHeaderTemplate:
						'<div class="ui-grid-filter-container" data-ng-repeat="colFilter in col.filters">' +
						'<select class="ui-grid-filter-select" data-ng-model="colFilter.term" data-ng-options="option.type as option.name for option in grid.appScope.idaTypes">' +
						'</div>',
					cellTemplate: '<div class="crop" data-ng-bind="grid.appScope.getIdaType(row.entity.idaType)"></div>'
				},
				{
					name: 'action',
					displayName: cvLoc('header.actions'),
					enableHiding: false,
					enableFiltering: false,
					enableSorting: false,
					minWidth: 90,
					width: '10%',
					cellTemplate:
						'<div class="btn-group" uib-dropdown data-ng-if="row.entity.showDelete == true || row.entity.showEdit== true"><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li data-ng-if="row.entity.showEdit"><a href="" class="ui-grid-action-items" ng-click="">' +
						cvLoc('action.edit') +
						'</a></li><li data-ng-if="row.entity.showDelete"><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteSCPolicy(row.entity.subclientPolicyEntity.subclientPolicyId,row.entity.subclientPolicyEntity.subclientPolicyName)"">' +
						cvLoc('action.delete') +
						'</a></li></ul></div>'
				}
			]
		});

		$scope.gridOptions = {
			cvPageLinks: [
				{
					label: cvLoc('action.add'),
					onclick: createSubClientPolicy
				}
			],
			cvGridTitle: cvLoc('label.subclientPolicies'),
			cvTableName: 'subclientPolicyTable',
			cvSearchFields: ['subclientPolicyEntity.subclientPolicyName', 'idaType'],
			cvOnGridEmpty: {
				message: cvLoc('label.noSubclientPolicy')
			},
			gridOptions: globalGridOptions
		};

		var computePermittedActions = function(entity) {
			var actionsToOverride = [
				{
					DELETE: {
						show: entity.showDelete,
						onClick: () =>
							$scope.deleteSCPolicy(
								entity.subclientPolicyEntity.subclientPolicyId,
								entity.subclientPolicyEntity.subclientPolicyName
							)
					}
				}
			];

			return cvPermissionFactory.updateAndGetCommonActionsList(
				actionsToOverride,
				false,
				angular.copy(cvPermissionFactory.commonPermittedList)
			);
		};

		var setPermittedOptions = function(entity) {
			entity.permittedOptions = {
				entityType: ENTITY_TYPES.SUBCLIENT_POLICY_ENTITY,
				entity: angular.copy(entity),
				entityId: entity.subclientPolicyEntity.subclientPolicyId,
				entityName: entity.subclientPolicyEntity.subclientPolicyName,
				appendToBody: true,
				permittedActionList: computePermittedActions(entity)
			};
		};

		var getSubclientPolicies = function(options) {
			subclientPolicyService
				.getSubclientPoliciesList('all', false, 'all')
				.success(function(data) {
					$scope.serverMessage = cvUtil.emptyMsg();
					if (data && data.length > 0) {
						for (var i = 0; i < data.length; i++) {
							data[i].showDelete = true;
							data[i].showEdit = false;
							data[i].parent = '#/subclientPolicies/';
							data[i].agentVal = $scope.getIdaValue(data[i].idaType);
							setPermittedOptions(data[i]);
						}
						options.success(data);
					} else {
						options.success([]);
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
					$scope.getPoliciesFinished = true;
				});
		};

		var onGridDataBound = function(dataItem, row) {
			var permittedOptions = dataItem.permittedOptions;
			var id = permittedOptions.entityId;
			$scope[`permittedOptions${id}`] = permittedOptions;
			var template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			row.find('.permittedActions').html($compile(template)($scope));
		};

		$scope.kendogridOptions = {
			gridTitle: cvLoc('label.subclientPolicies'),
			tableName: 'subclientPolicyTable',
			enablePaging: true,
			pageSize: 20,
			url: getSubclientPolicies,
			usePageToolbar: true,
			gridToolbarMenu: [
				{
					label: cvLoc('action.add'),
					onSelect: createSubClientPolicy
				}
			],
			gridEmptyMessage: cvLoc('label.noSubclientPolicy'),
			columns: getSubclientPolicyGridColumns(
				{ cvLoc },
				{ getIdaLabel: $scope.getIdaLabel, SUBCLIENT_POLICY_IDATA_AGENT }
			),
			onGridDataBound
		};

		function createSubClientPolicy() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/policies/subclientPolicy/partials/createSubclientPolicy.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$log',
					'$uibModalInstance',
					'$state',
					'cvLoc',
					'$stateParams',
					'cvUtil',
					'$location',
					'$rootScope',
					function($scope, $log, $modalInstance, $state, cvLoc, $stateParams, cvUtil, $location, $rootScope) {
						$scope.cancel = function() {
							$modalInstance.dismiss();
						};
						$scope.close = function() {
							$modalInstance.close();
						};
					}
				]
			});
		}

		$scope.deleteSCPolicy = function(id, name) {
			var subclientPolicyEntity = {
				subclientPolicyId: parseInt(id),
				subclientPolicyName: name
			};
			subclientPolicyFactory.deleteSubclientPolicy(subclientPolicyEntity);
		};
	}
];

subclientPolicyMod.controller(controllers);

export default subclientPolicyMod;
