export const getSubclientPolicyGridColumns = (serviceVars, helperFunctions) => ({
	...getSubclientPolicyNameColumn(serviceVars.cvLoc),
	...getAgentColumn(serviceVars.cvLoc, helperFunctions.getIdaLabel, helperFunctions.SUBCLIENT_POLICY_IDATA_AGENT),
	...getActionsColumn(serviceVars.cvLoc)
});

const getSubclientPolicyNameColumn = cvLoc => ({
	'subclientPolicyEntity.subclientPolicyName': {
		title: cvLoc('column.name'),
		width: '45%',
		template: getSubclientPolicyNameTemplate()
	}
});

const getAgentColumn = (cvLoc, getIdaLabel, filterObject) => ({
	agentVal: {
		title: cvLoc('column.iDataAgent'),
		width: '45%',
		filterType: 'checkboxmultiselect',
		data: [
			{
				label: cvLoc('label.unixFileSystem'),
				value: filterObject.UNIXFS
			},
			{
				label: cvLoc('label.windowsFileSystem'),
				value: filterObject.WINFS
			}
		],
		template: getAgentTemplate.bind(undefined, getIdaLabel)
	}
});

const getActionsColumn = cvLoc => ({
	actions: {
		title: cvLoc('header.actions'),
		template: '<div class="permittedActions"></div>',
		sortable: false,
		disableColumnFilter: true,
		disableViewFiltering: true,
		width: '10%'
	}
});

const getSubclientPolicyNameTemplate = () =>
	`<div class="crop"><a href="\\#/subclientPolicyDetail/#:subclientPolicyEntity.subclientPolicyId#">#:subclientPolicyEntity.subclientPolicyName#</a></div>`;

const getAgentTemplate = (getIdaLabel, rowItem) => `<div class="crop">${getIdaLabel(rowItem.agentVal)}</div>`;
