<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<div class="panel">
	<div class="panel-body">
		<h4 class="modal-underline"><cv:msg key="label.auxCopyOptions" bundle="schedule"/></h4>
				
		<div class="form-group">
			<div class="col-sm-5">
				<label><cv:msg key="label.noOfReaders" bundle="schedule" /></label>
			</div>
			
			<div class="col-sm-7">
				<input type="radio" id="noOfStreams" name="noOfStreams" data-ng-value="false" data-ng-model="astpCtrl.scheduleModel.useMaximumStreams">
				<label for="noOfStreams"><cv:msg key="label.noOfStreams" bundle="oracle"/></label>				
				<input type="number" id="streams" name="streams" min="1" max="1000" required 
								data-ng-model="astpCtrl.scheduleModel.maxNumberOfStreams">
			</div>
			
			<div class="col-sm-offset-5 col-sm-7">
				<input type="radio" id="allowMaximum" name="allowMaximum" data-ng-value="true" data-ng-model="astpCtrl.scheduleModel.useMaximumStreams">
				<label for="allowMaximum"><cv:msg key="label.allowMaximum" bundle="schedule" /></label>
			</div>
		</div>
		
		<div class="form-group"> <!-- START NEW MEDIA -->
		    <div class="col-sm-12">
		        <input type="checkbox" id="startNewMedia" name="startNewMedia" data-ng-model="astpCtrl.scheduleModel.startNewMedia">
		    	<label for="startNewMedia"><cv:msg key="label.startNewMedia" bundle="schedule"/></label>
		    </div>
		</div>
		
		<div class="form-group"> <!-- MARK MEDIA FULL ON SUCCESS -->
		    <div class="col-sm-12">
		        <input type="checkbox" id="markMediaFullOnSuccess" name="markMediaFullOnSuccess" data-ng-model="astpCtrl.scheduleModel.markMediaFullOnSuccess">
		    	<label for="markMediaFullOnSuccess"><cv:msg key="label.markMediaFullOnSuccess" bundle="schedule"/></label>
		    </div>
		</div>	
		
		<div class="form-group"> <!-- USE MOST RECENT FULL BACKUP FOR AUX COPY -->
		    <div class="col-sm-12">
		        <input type="checkbox" id="useMostRecentBackupForAuxCopy" name="useMostRecentBackupForAuxCopy" data-ng-model="astpCtrl.scheduleModel.useMostRecentBackupForAuxcopy">
		    	<label for="useMostRecentBackupForAuxCopy"><cv:msg key="label.useMostRecentBackupForAuxCopy" bundle="schedule"/></label>
		    </div>
		</div>	
		<div class="form-group"> <!-- WAIT FOR ALL PARALLEL COPY RESOURCES -->
		    <div class="col-sm-12">
		        <input type="checkbox" id="waitForAllParallelCopyResources" name="waitForAllParallelCopyResources" data-ng-model="astpCtrl.scheduleModel.waitForAllParallelCopyResources">
		    	<label for="waitForAllParallelCopyResources"><cv:msg key="label.waitForAllParallelCopyResources" bundle="schedule"/></label>
		    </div>
		</div>	
		<div class="form-group"> <!-- USE SCALABLE RESOURCE ALLOCATION -->
		    <div class="col-sm-12">
		        <input type="checkbox" id="useScalableResourceAllocation" name="useScalableResourceAllocation" data-ng-model="astpCtrl.scheduleModel.useScallableResourceManagement">
		    	<label for="useScalableResourceAllocation"><cv:msg key="label.useScalableResourceAllocation" bundle="schedule"/></label>
		    </div>
		</div>	
		
		<div class="form-group"> <!-- SKIP JOBS THAT FAILED DATA VERIFICATION -->
		    <div class="col-sm-12">
		        <input type="checkbox" id="skipJobsThatFailedDataVerification" name="skipJobsThatFailedDataVerification" data-ng-model="astpCtrl.scheduleModel.ignoreDataVerificationFailedJobs">
		    	<label for="skipJobsThatFailedDataVerification"><cv:msg key="label.skipJobsThatFailedDataVerification" bundle="schedule"/></label>
		    </div>
		</div>	
	</div>
</div>