import 'adminConsole/js/controllers/clientGroups.ctrl.js';

import { policyModule } from 'common/js/modules';

var schedulePolicyMod = policyModule;

schedulePolicyMod.filter('showAllAgentsAsString', [
	'cvLoc',
	'smartClientGroupFactory',
	function(cvLoc, smartClientGroupFactory) {
		return function(taskDetail) {
			if (taskDetail.task.policyType === 'DATA_PROTECTION' && taskDetail.task.taskType == 'SCHEDULE_POLICY') {
				if (!taskDetail.appGroup.hasOwnProperty('appGroups') && !taskDetail.appGroup.hasOwnProperty('appTypes')) {
					return cvLoc('label.treenode.allAgents');
				} else {
					return smartClientGroupFactory.getReadableAgentNamesForAllNodes(taskDetail.appGroup);
				}
			}
			return cvLoc('NOT_APPLICABLE');
		};
	}
]);

export default schedulePolicyMod;
