import { policyModule } from 'common/js/modules';

var schedulePolicyMod = policyModule;

schedulePolicyMod.filter('backupLevelFilter', [
	'cvLoc',
	function(cvLoc) {
		return function(backupLevel) {
			switch (backupLevel) {
				case 'NONE':
					return cvLoc('None');
				case 'FULL':
					return cvLoc('Full');
				case 'INCREMENTAL':
					return cvLoc('Incremantal');
				case 'DIFFERENTIAL':
					return cvLoc('Differential');
				case 'SYNTHETIC_FULL':
					return cvLoc('Synthetic Full');
				case 'ASR':
					return cvLoc('asr');
				case 'TRANSACTION_LOG':
					return cvLoc('transaction_log');
				case 'PRE_SELECT':
					return cvLoc('pre_select');
				case 'QR_SNAPSHOT':
					return cvLoc('qr_snapshot');
				case 'QR_CREATE_QR_VOLUME':
					return cvLoc('qr_create_qr_volume');
				case 'QR_INCREMENTALLY_UPDATE_QR_VOLUME':
					return cvLoc('qr_incrementally_update_qr_volume');
				case 'SRM_ANALYSIS':
					return cvLoc('srm_analysis');
				case 'SRM_DISCOVERY':
					return cvLoc('srm_discovery');
				case 'MINING':
					return cvLoc('mining');
				case 'DATA_VERIFICATION':
					return cvLoc('data_verification');
				case 'STUBBING':
					return cvLoc('label.cleanup');
				default:
					return '';
			}
		};
	}
]);

export default schedulePolicyMod;
