import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyDetails.factory.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'modules/policies/schedulePolicies/js/controllers/editSchedulePolicyAssociations.ctrl.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'modules/policies/schedulePolicies/js/services/schedulePolicy.svc.js';
import 'modules/policies/schedulePolicies/js/filters/backupLevel.filter.js';
import 'modules/policies/schedulePolicies/js/filters/showAllAgentsAsString.filter.js';
import 'modules/policies/schedulePolicies/js/filters/scheduleType.filter.js';
import 'modules/policies/schedulePolicies/js/filters/schedulePolicyAgentType.filter.js';
import 'modules/policies/schedulePolicies/js/filters/associatedScheduleName.filter.js';
import { policyModule } from 'common/js/modules';

var app = policyModule;

app.controller('schedulePolicyDetailsController', [
	'cvLoc',
	'cvUtil',
	'$uibModal',
	'schedulePolicyDetailsFactory',
	'cvTableOptions',
	'cvToaster',
	'$stateParams',
	'securityFactory',
	'cvBreadcrumbsTabsFactory',
	'$dialogs',
	'schedulePolicyService',
	'schedulePolicyFactory',
	'$state',
	'$filter',
	'$location',
	'cvEntitySelectionTreeComponent',
	'cvStoragePolicySelectionTreeComponent',
	'ddbVerificationTreeComponent',
	'AppTypes',
	function(
		cvLoc,
		cvUtil,
		$modal,
		schedulePolicyDetailsFactory,
		cvTableOptions,
		cvToaster,
		$stateParams,
		securityFactory,
		cvBreadcrumbsTabsFactory,
		$dialogs,
		schedulePolicyService,
		schedulePolicyFactory,
		$state,
		$filter,
		$location,
		cvEntitySelectionTreeComponent,
		cvStoragePolicySelectionTreeComponent,
		ddbVerificationTreeComponent,
		AppTypes
	) {
		var taskId = $stateParams.taskId,
			self = this;

		self.model = {
			status: false,
			entityType: 'SCHEDULE_POLICY_ENTITY',
			genericEntity: {
				schedulePolicyId: taskId
			},
			formattedSecurityAssociations: undefined,
			serverMessage: cvUtil.emptyMsg()
		};

		cvBreadcrumbsTabsFactory.addBreadCrumbs({
			title: cvLoc('label.schedulePolicies'),
			link: '#/schedulePolicies'
		});

		self.toggleSchedulePolicyStatus = function() {
			self.model.serverMessage = cvUtil.emptyMsg();

			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					schedulePolicyDetailsFactory
						.toggleSchedulePolicyStatus(taskId, !self.model.status)
						.success(function() {
							self.model.status = !self.model.status;
						})
						.error(showErrorMessage);
				}
			};

			if (!self.model.status) {
				$dialogs.confirm(
					cvLoc('label.confirmDisableSchedulePolicy'),
					cvLoc('label.confirmDisableSchedulePolicyText'),
					callBackFunctions
				);
			} else {
				callBackFunctions.yesFunction();
			}
		};

		self.deleteAssociatedSchedule = function(subTaskId, subTaskName) {
			if (self.schedules.length < 2) {
				genericErrorHandler(cvLoc('label.associatedScheduleDeleteError'));
			} else {
				$dialogs.confirm(
					cvLoc('label.confirmDelete'),
					cvLoc('label.confirmDeleteAssociatedSchedule', '<b>' + subTaskName + '</b>'),
					{
						noFunction: function() {},
						yesFunction: function() {
							schedulePolicyService
								.deleteAssociatedSchedule(taskId, subTaskId)
								.success(function() {
									cvToaster.showSuccessMessage({
										ttl: '10000', //10 sec
										message: cvLoc('label.associatedScheduleDeleted')
									});
									$state.forceReload();
								})
								.error(genericErrorHandler);
						}
					}
				);
			}
		};

		self.runAssociatedSchedule = function(entity) {
			var subTaskName = entity.subTask.subTask.subtaskName,
				subTaskId = entity.subTask.subTask.subtaskId,
				taskName = self.schedulePolicyDetails.task.taskName;

			schedulePolicyService
				.runSchedule(subTaskId, subTaskName, taskId, taskName)
				.success(function(jobIdList) {
					if (jobIdList) {
						var responseContent;
						if (jobIdList.length == 1) {
							var jobId = jobIdList[0];
							responseContent =
								cvLoc('label.jobStarted', jobId) +
								'  <a target="_blank" href="' +
								'#/jobs/' +
								jobId +
								'">' +
								cvLoc('notification.viewJobs') +
								'</a>';
						} else if (jobIdList.length > 1) {
							responseContent =
								cvLoc('label.jobsStarted') +
								'. ' +
								'<a target="_blank" href="#/activeJobs" >' +
								cvLoc('notification.viewJobs') +
								'</a>';
						}
						cvToaster.showSuccessMessage({
							ttl: '10000', //10 sec
							message: responseContent
						});
					} else {
						genericErrorHandler(false);
					}
				})
				.error(genericErrorHandler);
		};

		self.isAgentTypeSupported = function() {
			return self.schedulePolicyDetails && self.schedulePolicyDetails.task.policyType == 'DATA_PROTECTION';
		};

		self.editAgentType = function() {
			self.model.serverMessage = cvUtil.emptyMsg();
			schedulePolicyDetailsFactory.modifyAgentType(self.schedulePolicyDetails, self.schedulePolicyDetails.appGroup);
		};

		self.addSchedule = function() {
			var callBackFunction = function(subTask) {
				return schedulePolicyService
					.addScheduleToPolicy({
						taskId: taskId,
						scheduleOptions: angular.toJson(subTask)
					})
					.success(function() {
						cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.scheduleAddedSuccess'));
						$state.forceReload();
					});
			};

			var inputParams = {
				task: {
					taskId: taskId,
					isSystemCreated: self.schedulePolicyDetails.task.taskFlags.isSystem,
					policyType: self.schedulePolicyDetails.task.policyType,
					taskType: self.schedulePolicyDetails.task.taskType
				},
				schedules: self.schedules,
				callBackFunction: callBackFunction
			};

			if (self.isAgentTypeSupported()) {
				inputParams.selectedAgents = self.schedulePolicyDetails.appGroup;
			}

			schedulePolicyFactory.addScheduleToPolicy(inputParams);
		};

		self.editSchedule = function(schedule) {
			schedulePolicyFactory.editSchedule({
				taskId: taskId,
				subTaskId: schedule.subTask.subTaskId
			});
		};

		self.editAssociation = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/policies/schedulePolicies/partials/editSchedulePolicyAssociations.jsp',
				backdrop: 'static',
				controller: 'editSchedulePolicyAssociationsController as editAssociationsCtrl',
				resolve: {
					params: function() {
						return {
							taskInfo: angular.copy(self.schedulePolicyDetails)
						};
					}
				}
			});
			modalInstance.result.then(function(data) {
				$state.forceReload();
			});
		};

		self.deleteSchedulePolicy = function() {
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmDeleteSchedulePolicy', '<b>' + self.schedulePolicyDetails.task.taskName + '</b>'),
				{
					noFunction: function() {},
					yesFunction: function() {
						schedulePolicyFactory
							.deleteSchedulePolicy(taskId)
							.success(function() {
								cvToaster.showSuccessMessage({
									ttl: '10000', //10 sec
									message: cvLoc('label.schedulePolicyDeleted')
								});
								$location.path('schedulePolicies');
							})
							.error(function(e) {
								cvToaster.showErrorMessage({
									ttl: '10000',
									message: e ? e : cvLoc('generic_error')
								});
							});
					}
				}
			);
		};

		self.isEntitySelectionTreeVisible = function() {
			return (
				(self.policyType == 'DATA_PROTECTION' || self.policyType == 'CONTENT_INDEX_SUBCLIENT') &&
				self.schedulePolicyDetails.associations.length > 0
			);
		};

		self.isStoragePolicySelectionTreeVisible = function() {
			return (
				(self.policyType == 'SINGLE_INSTANCING' ||
					self.policyType == 'AUX_COPY' ||
					self.policyType == 'CONTENT_INDEX') &&
				self.schedulePolicyDetails.associations.length > 0
			);
		};

		function initialize(taskInfo) {
			self.schedulePolicyDetails = taskInfo;
			self.policyType = self.schedulePolicyDetails.task.policyType;
			self.schedules = taskInfo.subTasks || [];
			initializeSchedulesGridColumns(self.schedules);

			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			angular.extend(globalGridOptions, {
				data: self.schedules,
				columnDefs: schedulePolicyDetailsFactory.getSchedulesGridColumnDefs(self.policyType)
			});

			self.gridOptions = {
				cvPageLinks: [
					{
						label: cvLoc('Add'),
						onclick: self.addSchedule
					}
				],
				cvGridTitle: cvLoc('header.schedules'),
				cvIsPageTitle: true,
				cvTableName: 'schedulesTable',
				cvSearchFields: ['scheduleName', 'backupLevelName'],
				cvAppScope: self,
				cvHasColumnFilter: false,
				gridOptions: globalGridOptions
			};

			initializeSecurityAssociations();
			loadAssociationsList();
			self.model.status = self.schedulePolicyDetails.task.taskFlags.disabled;
			self.changeNameObj = {
				id: taskId,
				name: self.schedulePolicyDetails.task.taskName
			};
		}

		function initializeSecurityAssociations() {
			var securityAssociations = self.schedulePolicyDetails.task.securityAssociations;
			self.model.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(securityAssociations);
		}

		function showErrorMessage(errorMessage) {
			if (errorMessage && angular.isString(errorMessage)) {
				self.model.serverMessage = cvUtil.errMsg(errorMessage);
			} else if (errorMessage && angular.isString(errorMessage.data)) {
				self.model.serverMessage = cvUtil.errMsg(errorMessage.data);
			} else {
				self.model.serverMessage = cvUtil.errMsgLoc('generic_error');
			}
		}

		function loadAssociationsList() {
			var taskInfo = self.schedulePolicyDetails;
			self.assassociationsTree = [];
			if (taskInfo.associations && taskInfo.associations.length && taskInfo.task.policyType) {
				var policyType = taskInfo.task.policyType,
					associations = taskInfo.associations;

				if (policyType == 'DATA_PROTECTION') {
					self.model.associationsTreeParams = cvEntitySelectionTreeComponent.populateTreeParams(
						taskInfo.associations,
						'summary'
					);
				} else if (policyType == 'DATA_VERIFICATION') {
					self.model.ddbAssociationsTreeParams = ddbVerificationTreeComponent.populateTreeParams(
						taskInfo.associations,
						'summary'
					);
				} else if (policyType == 'AUX_COPY' || policyType == 'CONTENT_INDEX' || policyType == 'SINGLE_INSTANCING') {
					self.model.associationsTreeParams = cvStoragePolicySelectionTreeComponent.populateTreeParams(
						taskInfo.associations,
						'summary'
					);
				} else if (policyType == 'CONTENT_INDEX_SUBCLIENT') {
					self.model.associationsTreeParams = cvEntitySelectionTreeComponent.populateTreeParams(
						taskInfo.associations,
						'summary'
					);
					self.model.associationsTreeParams.hideClientGroups = true;
					self.model.associationsTreeParams.filterClientsByAgentId = AppTypes.EXCHANGE_MAILBOX; // To load only the clients having 'Exchange Mailbox'
				}
			}
		}

		function genericErrorHandler(error) {
			cvToaster.showErrorMessage({
				ttl: '10000',
				message: error ? error : cvLoc('generic_error')
			});
		}

		function initializeSchedulesGridColumns(schedules) {
			schedules.forEach(function(schedule) {
				if (self.policyType == 'DATA_PROTECTION') {
					let backupLevel = _.get(schedule, 'options.backupOpts.backupLevel', 'INCREMENTAL');
					schedule.backupLevelName = $filter('backupLevelFilter')(backupLevel);
				}
				schedule.scheduleName = $filter('associatedScheduleName')(schedule);
			});
		}

		schedulePolicyService
			.loadAssociatedSchedules(taskId)
			.success(initialize)
			.error(showErrorMessage);
	}
]);

export default app;
