import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyType.factory.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'modules/policies/schedulePolicies/js/services/schedulePolicy.svc.js';
import 'modules/policies/schedulePolicies/js/controllers/selectScheduleToRun.ctrl.js';
import 'modules/policies/schedulePolicies/js/filters/schedulePolicyAgentType.filter.js';
import 'modules/policies/schedulePolicies/js/filters/showAllAgentsAsString.filter.js';
import 'modules/policies/schedulePolicies/js/filters/showScheduleOrPolicyName.filter.js';
import 'modules/policies/schedulePolicies/js/filters/scheduleType.filter.js';

import { policyModule } from 'common/js/modules';

var schedulePolicyMod = policyModule;

schedulePolicyMod.controller('schedulePolicyController', [
	'cvLoc',
	'cvUtil',
	'$uibModal',
	'schedulePolicyFactory',
	'cvTableOptions',
	'cvToaster',
	'uiGridConstants',
	'$state',
	'$dialogs',
	'$filter',
	'schedulePolicyType',
	'$scope',
	'schedulePolicyService',
	'cvBreadcrumbsTabsFactory',
	function(
		cvLoc,
		cvUtil,
		$modal,
		schedulePolicyFactory,
		cvTableOptions,
		cvToaster,
		uiGridConstants,
		$state,
		$dialogs,
		$filter,
		schedulePolicyType,
		$scope,
		schedulePolicyService,
		cvBreadcrumbsTabsFactory
	) {
		var self = this;
		let _setupBreadCrumbs = () => {
			let breadCrumbs = [];

			breadCrumbs.push({
				title: cvLoc('label.nav.policies'),
				link: '#nav/policies'
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		_setupBreadCrumbs();
		var columnDefs = [
			{
				field: 'scheduleOrPolicyName',
				sort: {
					direction: 'asc',
					priority: 0
				},
				cellTooltip: true,
				displayName: cvLoc('label.name'),
				headerCellClass: highlightFilteredHeader,
				cellTemplate:
					'<a class="crop" ui-sref="schedulePolicyDetails({taskId: row.entity.task.taskId})" data-ng-if="row.entity.task.taskType==\'SCHEDULE_POLICY\'" title="{{row.entity.scheduleOrPolicyName}}" data-ng-bind="row.entity.scheduleOrPolicyName"></a>' +
					'<a class="crop" data-ng-click="grid.appScope.editSchedule(row.entity)" data-ng-if="row.entity.task.taskType==\'SCHEDULE\'" title="{{row.entity.scheduleOrPolicyName}}" data-ng-bind="row.entity.scheduleOrPolicyName"></a>',
				width: '30%'
			},
			{
				field: 'task.policyFilterType',
				displayName: cvLoc('Type'),
				width: '20%',
				filter: {
					type: uiGridConstants.filter.SELECT,
					term: '',
					selectOptions: self.schedulePolicyTypeList
				},
				headerCellClass: highlightFilteredHeader,
				filterHeaderTemplate:
					'<div ng-repeat="colFilter in col.filters"><isteven-multi-select input-model="grid.appScope.schedulePolicyTypeList" helper-elements="filter all none reset" button-label="label" item-label="label" tick-property="selected" class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter" on-close="grid.appScope.parseIStevenOutputForPolicyTypeFilters(colFilter, grid.appScope.schedulePolicyTypeList, grid.columns)" translation="grid.appScope.localLang"></isteven-multi-select></div>',
				cellTemplate:
					'<span class="crop" title="{{row.entity.policyTypeName}}"  data-ng-bind="row.entity.policyTypeName"></span>'
			},
			{
				field: 'agents.allAgents',
				displayName: cvLoc('agentType'),
				headerCellClass: highlightFilteredHeader,
				filter: {
					type: uiGridConstants.filter.SELECT,
					term: '',
					selectOptions: self.agentTypeColumnFilters
				},
				filterHeaderTemplate:
					'<div ng-repeat="colFilter in col.filters"><isteven-multi-select input-model="grid.appScope.agentTypeColumnFilters" selection-mode="single" helper-elements="filter" button-label="label" item-label="label" tick-property="selected" class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter" on-close="grid.appScope.parseIStevenOutputForAgentTypeFilters(colFilter, grid.appScope.agentTypeColumnFilters, grid.columns)" translation="grid.appScope.localLang"></isteven-multi-select></div>',
				cellTemplate:
					'<span class="crop" uib-tooltip="{{row.entity.agents.allAgents}}" data-ng-bind="row.entity.agents.displayName"></span>',
				width: '15%'
			},
			{
				field: 'task.taskFlags.disabled',
				displayName: cvLoc('label.status'),
				enableCellEditOnFocus: true,
				headerCellClass: highlightFilteredHeader,
				filter: {
					type: uiGridConstants.filter.SELECT,
					selectOptions: self.statusFilter
				},
				filterHeaderTemplate:
					'<div class="ui-grid-filter-container ng-scope" data-ng-repeat="colFilter in col.filters">' +
					'<select data-ng-model="colFilter.term" data-ng-options="option.value as option.label for option in grid.appScope.statusFilter" >' +
					'</select>' +
					'</div>',
				cellTemplate:
					'<div class="center-grid-element">' +
					'<span ng-if="row.entity.task.taskFlags.disabled" ng-click="grid.appScope.enableDisableScheduleOrSchedulePolicy(row)"><input type="checkbox"/><label/></span>' +
					'<span ng-if="!row.entity.task.taskFlags.disabled" ng-click="grid.appScope.enableDisableScheduleOrSchedulePolicy(row)"><input type="checkbox" checked/><label/></span>' +
					'</div>',
				width: '15%'
			},
			{
				field: 'task.associatedObjects',
				displayName: cvLoc('label.associatedObjects'),
				headerCellClass: 'text-center',
				cellTemplate: '<span class="crop text-center" data-ng-bind="row.entity.task.associatedObjects"></span>',
				width: '15%'
			},
			{
				width: '20%',
				field: 'action',
				displayName: cvLoc('label.actions'),
				enableFiltering: false,
				enableSorting: false,
				enableHiding: false,
				cellTemplate:
					'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
					'<li><a data-ng-if="row.entity.task.taskType==\'SCHEDULE\'" class="crop" data-ng-click="grid.appScope.runSchedule(row.entity)">' +
					cvLoc('action.run') +
					'</a></li>' +
					'<li><a data-ng-if="row.entity.task.taskType==\'SCHEDULE_POLICY\'" class="crop" data-ng-click="grid.appScope.runScheduleAssociatedToPolicy(row.entity)">' +
					cvLoc('action.run') +
					'</a></li>' +
					'<li><span class="crop"><a class="crop" href="#jobs?schedulePolicyId={{row.entity.task.taskId}}&activeJobs=0&showAdminJobs=true&view=allJobs">' +
					cvLoc('label.viewJobs') +
					'</a></span></li>' +
					'<li><a class="crop" data-ng-click="grid.appScope.deleteSchedulePolicy(row.entity)">' +
					cvLoc('action.deleteSchedule') +
					'</a></li></ul></div>'
			}
		];

		self.statusFilter = [
			{
				label: cvLoc('enabled.true'),
				value: 'false'
			},
			{
				label: cvLoc('enabled.false'),
				value: 'true'
			}
		];

		self.runScheduleAssociatedToPolicy = function(entity) {
			var taskId = entity.task.task.taskId,
				taskName = entity.task.task.taskName,
				policyType = entity.task.policyType;

			schedulePolicyService
				.loadAssociatedSchedules(taskId)
				.success(function(taskInfo) {
					var schedules = taskInfo.subTasks || [];

					var modalInstance = $modal.open({
						templateUrl: appUtil.appRoot + 'modules/policies/schedulePolicies/partials/selectScheduleToRun.jsp',
						backdrop: 'static',
						controller: 'selectScheduleToRunController as selectScheduleCtrl',
						resolve: {
							params: function() {
								return {
									schedules: schedules,
									taskId: taskId,
									taskName: taskName,
									policyType: policyType
								};
							}
						}
					});
				})
				.error(genericErrorHandler);
		};

		self.runSchedule = function(entity) {
			var subTaskName = entity.subTasks[0].subTask.subTaskName,
				subTaskId = entity.subTasks[0].subTask.subTaskId,
				taskId = entity.task.task.taskId,
				taskName = '';

			schedulePolicyService
				.runSchedule(subTaskId, subTaskName, taskId, taskName)
				.success(function(jobIdList) {
					if (jobIdList) {
						var responseContent;
						if (jobIdList.length == 1) {
							var jobId = jobIdList[0];
							responseContent =
								cvLoc('label.jobStarted', jobId) +
								'  <a target="_blank" href="' +
								'#/jobs/' +
								jobId +
								'">' +
								cvLoc('notification.viewJobs') +
								'</a>';
						} else if (jobIdList.length > 1) {
							responseContent =
								cvLoc('label.jobsStarted') +
								'. ' +
								'<a target="_blank" href="#/activeJobs" >' +
								cvLoc('notification.viewJobs') +
								'</a>';
						}
						cvToaster.showSuccessMessage({
							ttl: '10000', //10 sec
							message: responseContent
						});
					}
				})
				.error(genericErrorHandler);
		};

		self.deleteSchedulePolicy = function(taskInfo) {
			var taskId = taskInfo.task.taskId,
				taskName = $filter('showScheduleOrPolicyName')(taskInfo);

			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmDeleteSchedulePolicy', '<b>' + taskName + '</b>'),
				{
					noFunction: function() {},
					yesFunction: function() {
						schedulePolicyFactory
							.deleteSchedulePolicy(taskId)
							.success(function() {
								cvToaster.showSuccessMessage({
									ttl: '10000', //10 sec
									message: cvLoc('label.schedulePolicyDeleted')
								});
								removeTaskInfoFromView(taskInfo);
							})
							.error(genericErrorHandler);
					}
				}
			);
		};

		self.parseIStevenOutputForPolicyTypeFilters = function(colFilter, inputModelList, gridColumns) {
			colFilter.listTerm = [];
			for (var i = 0; i < inputModelList.length; i++) {
				if (inputModelList[i].selected) {
					colFilter.listTerm.push(inputModelList[i].value);
				}
			}
			colFilter.term = colFilter.listTerm.join(',');
		};

		self.parseIStevenOutputForAgentTypeFilters = function(colFilter, inputModelList, gridColumns) {
			var selectedItems = inputModelList.filter(input => input.selected);
			if (selectedItems && selectedItems.length > 0) {
				colFilter.term = selectedItems[0].value;
			}
		};

		self.localLang = cvUtil.getIStevenLocLabels();
		$scope.$watch('gridOptions.cvIsViewOpen', function(val) {
			if (val) {
				self.localLang.nothingSelected = cvLoc('label.nothingSelected');
			}
		});

		self.editSchedule = function(schedule) {
			schedulePolicyFactory.editSchedule({
				taskId: _.get(schedule, 'task.taskId', 0),
				subTaskId: _.get(schedule, 'subTasks[0].subTask.subTaskId', 0)
			});
		};

		self.enableDisableScheduleOrSchedulePolicy = function(data) {
			var isDisabled = _.get(data, 'entity.task.taskFlags.disabled');
			schedulePolicyService
				.toggleStatus({
					taskId: _.get(data, 'entity.task.taskId'),
					opType: isDisabled ? 'ENABLE' : 'DISABLE'
				})
				.success(function() {
					var taskFlags = _.get(data, 'entity.task.taskFlags');
					taskFlags.disabled = !taskFlags.disabled;
				})
				.error(showErrorMessage);
		};

		self.enablePolicies = function() {
			var taskIds = self.selectedPolicies.map(policy => policy.task.taskId);
			schedulePolicyService
				.performMultipleOperations(taskIds, 'ENABLE')
				.success(function() {
					cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.scheduleEnabledSuccess'));
					$state.forceReload();
				})
				.error(genericErrorHandler);
		};

		self.disablePolicies = function() {
			var taskIds = self.selectedPolicies.map(policy => policy.task.taskId);
			schedulePolicyService
				.performMultipleOperations(taskIds, 'DISABLE')
				.success(function() {
					cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.scheduleDisabledSuccess'));
					$state.forceReload();
				})
				.error(genericErrorHandler);
		};

		self.deletePolicies = function() {
			var taskIds = [],
				displayString = '',
				policiesToDelete = '',
				delimitter = '';

			for (var i = 0; i < self.selectedPolicies.length; i++) {
				taskIds.push(self.selectedPolicies[i].task.taskId);
				displayString += delimitter;
				displayString += self.selectedPolicies[i].scheduleOrPolicyName;
				delimitter = ', ';
			}
			policiesToDelete = displayString;
			if (self.selectedPolicies.length >= 2) {
				policiesToDelete = '';
				policiesToDelete += self.selectedPolicies[0].scheduleOrPolicyName;
				policiesToDelete += cvLoc('label.more', self.selectedPolicies.length - 1);
			}

			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc(
					'label.confirmDeletePolicies',
					'<span class="pageDetailColumn" title="' + displayString + '"><b>' + policiesToDelete + '</b></span>'
				),
				{
					noFunction: function() {},
					yesFunction: function() {
						schedulePolicyService
							.performMultipleOperations(taskIds, 'DELETE')
							.success(function() {
								cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.scheduleDeletedSuccess'));
								$state.forceReload();
							})
							.error(genericErrorHandler);
					}
				}
			);
		};

		function genericErrorHandler(err) {
			cvToaster.showErrorMessage({
				ttl: '10000',
				message: err ? err : cvLoc('generic_error')
			});
		}

		function initializeSchedulePoliciesGrid(taskInfo) {
			self.schedulePolicies = taskInfo;
			self.showAddOption = true;
			initializeColumns(taskInfo);
			self.agentTypeColumnFilters = schedulePolicyFactory.getColumnFiltersForAgents(taskInfo);
			initColumnFiltersForSchedulePolicyType(taskInfo);
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

			angular.extend(globalGridOptions, {
				data: self.schedulePolicies,
				columnDefs: columnDefs,
				enableRowSelection: true,
				enableSelectAll: true,
				enableRowHeaderSelection: true,
				selectWithCheckboxOnly: true,
				multiSelect: true,
				onRegisterApi: function(gridApi) {
					self.gridApi = gridApi;
					self.refreshGrid = function() {
						gridApi.core.notifyDataChange(uiGridConstants.dataChange.ALL);
					};
					gridApi.selection.on.rowSelectionChangedBatch($scope, function(row) {
						self.showMultiSelectOptions = gridApi.selection.getSelectedRows().length > 0;
						self.showAddOption = gridApi.selection.getSelectedRows().length == 0;
						self.selectedPolicies = gridApi.selection.getSelectedRows();
					});

					gridApi.grid.rows.forEach(function(row) {
						if (row.entity.selected) {
							row.isSelected = true;
						}
					});
					gridApi.selection.on.rowSelectionChanged($scope, function(row) {
						row.entity.selected = row.isSelected;
						self.showMultiSelectOptions = gridApi.selection.getSelectedRows().length > 0;
						self.showAddOption = gridApi.selection.getSelectedRows().length == 0;
						self.selectedPolicies = gridApi.selection.getSelectedRows();
					});
				}
			});

			self.gridOptions = {
				cvPageLinks: [
					{
						label: cvLoc('Add'),
						show: 'showAddOption',
						onclick: schedulePolicyFactory.addSchedulePolicy
					},
					{
						label: cvLoc('action.enable'),
						show: 'showMultiSelectOptions',
						onclick: function() {
							self.enablePolicies();
						}
					},
					{
						label: cvLoc('action.disable'),
						show: 'showMultiSelectOptions',
						onclick: function() {
							self.disablePolicies();
						}
					},
					{
						label: cvLoc('action.delete'),
						show: 'showMultiSelectOptions',
						onclick: function() {
							self.deletePolicies();
						}
					}
				],
				cvGridTitle: cvLoc('label.schedulePolicies'),
				cvIsPageTitle: true,
				cvAppScope: self,
				cvServerMessage: self.serverMessage,
				cvOnGridEmpty: {
					message: cvLoc('label.noSchedulePoliciesFound')
				},
				cvTableName: 'schedulePoliciesTable',
				cvSearchFields: ['scheduleOrPolicyName', 'policyTypeName', 'agents.displayName', 'task.associatedObjects'],
				cvGridCssClass: {
					'users-grid': true
				},
				gridOptions: globalGridOptions
			};
		}

		function initializeColumns(taskInfo) {
			//if we use filters directly in cv-grid columnDefs, search will not work.
			//as we need to specify which field to search for (in gridOptions.cvSearchFields)

			for (var i = 0; i < taskInfo.length; i++) {
				taskInfo[i].agents = {
					displayName: $filter('schedulePolicyAgentType')(taskInfo[i]),
					allAgents: $filter('showAllAgentsAsString')(taskInfo[i])
				};
				taskInfo[i].scheduleOrPolicyName = $filter('showScheduleOrPolicyName')(taskInfo[i]);
				taskInfo[i].policyTypeName = $filter('scheduleType')(taskInfo[i]);
			}
		}

		function showErrorMessage(errorMessage) {
			self.serverMessage = cvUtil.errMsgWrapper(errorMessage);
			self.serverMessage.ttl = 10000; //10 seconds
			cvToaster.showErrorMessage(self.serverMessage);
		}

		function removeTaskInfoFromView(taskInfo) {
			var $index = self.gridOptions.gridOptions.data.indexOf(taskInfo);
			self.gridOptions.gridOptions.data.splice($index, 1);
			self.refreshGrid();
		}

		function initColumnFiltersForSchedulePolicyType(taskInfo) {
			var scheduleOrPolicyTypes = [];
			taskInfo.forEach(function(taskDetail) {
				var value, label;
				if (taskDetail.task.taskType == 'SCHEDULE') {
					if (angular.isDefined(schedulePolicyFactory.scheduleTypesMap)) {
						label =
							schedulePolicyFactory.scheduleTypesMap[_.get(taskDetail, 'subTasks[0].subTask.operationType', false)];
						value = label ? taskDetail.subTasks[0].subTask.operationType : false;
					}
				} else if (taskDetail.task.taskType == 'SCHEDULE_POLICY') {
					label = schedulePolicyType[taskDetail.task.policyType];
					if (taskDetail.task.policyType == 'CONTENT_INDEX') {
						value = 'CONTENT_OFFLINE_INDEXING';
					} else {
						value = taskDetail.task.policyType;
					}
				}
				taskDetail.task.policyFilterType = value ? taskDetail.policyTypeName + ' ' + value : '';
				if (value && label && !_.find(scheduleOrPolicyTypes, { value: value })) {
					const formattedValue = `${_.replace(value, /_/g, ' ').toLowerCase()}`;
					const formattedLabel = formattedValue === label.toLowerCase() ? label : `${label}  (${formattedValue})`;
					scheduleOrPolicyTypes.push({
						value: value,
						label: formattedLabel
					});
				}
			});

			self.schedulePolicyTypeList = cvUtil.sortAscending(scheduleOrPolicyTypes, 'label');
			self.schedulePolicyTypeList.forEach(obj => (obj.selected = false));
		}

		function highlightFilteredHeader(row, rowRenderIndex, col, colRenderIndex) {
			var cssClass = '';
			if (col.filters[0].term) {
				cssClass = 'header-filtered';
			}

			if (col.field == 'task.taskFlags.disabled') {
				cssClass += ' text-center';
			}

			return cssClass;
		}

		schedulePolicyFactory.loadTaskOperationTypes().then(function() {
			schedulePolicyFactory
				.loadSchedulePolicies()
				.success(initializeSchedulePoliciesGrid)
				.error(showErrorMessage);
		}, showErrorMessage);
	}
]);

export default schedulePolicyMod;
