import { policyModule } from 'common/js/modules';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/factory/ddbVerificationTreeComponent.factory.js';
import 'modules/policies/schedulePolicies/js/services/schedulePolicy.svc.js';
import 'common/js/common.js';
import 'common/js/tableOptions.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'adminConsole/js/directives/cv-entity-selection-tree-component.js';
import 'adminConsole/js/directives/cv-storage-policy-selection-tree-component.js';
import 'adminConsole/js/factories/cvEntitySelectionTreeComponent.factory.js';

var app = policyModule;

app.controller('editSchedulePolicyAssociationsController', [
	'cvToaster',
	'cvUtil',
	'cvLoc',
	'schedulePolicyFactory',
	'schedulePolicyService',
	'params',
	'$uibModalInstance',
	'cvEntitySelectionTreeComponent',
	'cvStoragePolicySelectionTreeComponent',
	'ddbVerificationTreeComponent',
	'AppTypes',
	function(
		cvToaster,
		cvUtil,
		cvLoc,
		schedulePolicyFactory,
		schedulePolicyService,
		params,
		$modal,
		cvEntitySelectionTreeComponent,
		cvStoragePolicySelectionTreeComponent,
		ddbVerificationTreeComponent,
		AppTypes
	) {
		var self = this;
		self.associationsTree = [];
		self.associations = [];
		//To list associations in 'Edit associations' modal
		function listAssociations() {
			self.initialSelection = params.taskInfo.associations;
			self.policyType = params.taskInfo.task.policyType;
			if (
				self.policyType == 'SINGLE_INSTANCING' ||
				self.policyType == 'CONTENT_INDEX' ||
				self.policyType == 'AUX_COPY'
			) {
				self.storagePolicyTreeParams = cvStoragePolicySelectionTreeComponent.populateTreeParams(
					params.taskInfo.associations
				);
				self.storagePolicyTreeParams.noExclusions = self.policyType != 'AUX_COPY'; //Exclusions are allowed only for 'Auxiliary copy' policy
				self.storagePolicyTreeParams.isSelectable = function(node) {
					if (
						node.entity.entityTypeName == 'STORAGE_POLICY_COPY_ENTITY' ||
						(node.entity.entityTypeName == 'STORAGE_POLICY_ENTITY' && self.policyType != 'AUX_COPY')
					) {
						node.noChild = true;
					}
					return node.entity.entityTypeName != 'STORAGE_POLICIES_ENTITY';
				};
			} else if (self.policyType == 'CONTENT_INDEX_SUBCLIENT') {
				self.contentIndexingTreeParams = cvEntitySelectionTreeComponent.populateTreeParams(
					params.taskInfo.associations
				);
				self.contentIndexingTreeParams.hideClientGroups = true;
				self.contentIndexingTreeParams.filterClientsByAgentId = AppTypes.EXCHANGE_MAILBOX; // To load only the clients having 'Exchange Mailbox'
			} else if (self.policyType == 'DATA_PROTECTION') {
				self.dataProtectionTreeParams = cvEntitySelectionTreeComponent.populateTreeParams(params.taskInfo.associations);
			} else if (self.policyType == 'DATA_VERIFICATION') {
				self.dataVerificationTreeParams = ddbVerificationTreeComponent.populateTreeParams(params.taskInfo.associations);
			}
		}
		listAssociations();

		// To save associations
		self.saveAssociations = function() {
			var selectedAssociationsList = [];
			if (self.policyType == 'CONTENT_INDEX_SUBCLIENT') {
				params.taskInfo.associations = cvEntitySelectionTreeComponent.getAssociations(self.contentIndexingTreeParams);
			} else if (
				self.policyType == 'SINGLE_INSTANCING' ||
				self.policyType == 'CONTENT_INDEX' ||
				self.policyType == 'AUX_COPY'
			) {
				params.taskInfo.associations = cvStoragePolicySelectionTreeComponent.getAssociations(
					self.storagePolicyTreeParams
				);
			} else if (self.policyType == 'DATA_PROTECTION') {
				params.taskInfo.associations = cvEntitySelectionTreeComponent.getAssociations(self.dataProtectionTreeParams);
			} else if (self.policyType === 'DATA_VERIFICATION') {
				params.taskInfo.associations = schedulePolicyFactory.getAssociationsFromAdvancedTree(
					self.dataVerificationTreeParams
				);
			}

			schedulePolicyService
				.saveAssociations(params.taskInfo)
				.success(function(data) {
					$modal.close(selectedAssociationsList);
					cvToaster.showSuccessMessage({
						ttl: '10000', //10 sec
						message: cvLoc('label.associationsModified')
					});
				})
				.error(function(errorMsg) {
					self.serverMessage = cvUtil.errMsg(errorMsg);
				});
		};
		self.isStoragePolicyTreeRequired = function() {
			return (
				self.policyType == 'SINGLE_INSTANCING' || self.policyType == 'AUX_COPY' || self.policyType == 'CONTENT_INDEX'
			);
		};

		self.cancel = function() {
			$modal.dismiss();
		};
	}
]);
