import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/factory/ddbVerificationTreeComponent.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyType.factory.js';
import 'modules/policies/schedulePolicies/js/services/schedulePolicy.svc.js';
import 'adminConsole/js/directives/cv-entity-selection-tree-component.js';
import 'adminConsole/js/directives/cv-agent-dropdown-tree.js';
import 'modules/policies/schedulePolicies/js/filters/associatedScheduleName.filter.js';
import 'modules/policies/schedulePolicies/js/controllers/addScheduleToPolicy.ctrl.js';
import 'adminConsole/js/directives/cv-storage-policy-selection-tree-component.js';
import { policyModule } from 'common/js/modules';

var app = policyModule;

app.controller('addSchedulePolicyController', [
	'$uibModal',
	'$uibModalInstance',
	'schedulePolicyType',
	'cvLoc',
	'cvUtil',
	'cvToaster',
	'schedulePolicyFactory',
	'schedulePolicyService',
	'$dialogs',
	'$state',
	'ddbVerificationTreeComponent',
	'AppTypes',
	function(
		$modal,
		$modalInstance,
		schedulePolicyType,
		cvLoc,
		cvUtil,
		cvToaster,
		schedulePolicyFactory,
		schedulePolicyService,
		$dialogs,
		$state,
		ddbVerificationTreeComponent,
		AppTypes
	) {
		var self = this,
			previousPolicyType = 'DATA_PROTECTION';

		self.model = {
			task: {
				taskId: 0,
				taskName: '',
				taskType: 'SCHEDULE_POLICY',
				policyType: 'DATA_PROTECTION'
			},
			schedulePolicyTypes: schedulePolicyType.getSchedulePolicyTypes(),
			accordionStatus: {
				schedulesTab: true,
				associationsTab: false
			},
			associationsTree: [],
			agentTypeTree: {},
			serverMessage: cvUtil.emptyMsg(),
			schedules: [],
			associationsTreeParams: {
				initialSelections: [],
				initialExclusions: [],
				result: {},
				mode: 'edit'
			},
			ddbAssociationsTreeParams: {
				initialSelections: [],
				initialExclusions: [],
				result: {},
				mode: 'edit',
				loadRootNodes: ddbVerificationTreeComponent.loadRootNodes,
				loadChildren: ddbVerificationTreeComponent.loadDDBAssociations,
				processChildren: ddbVerificationTreeComponent.processDDBAssociations
			}
		};

		self.updateAssociationsTreeForPolicyType = function() {
			var callBackFunctions = {
				noFunction: resetPolicyTypeDropdown,
				yesFunction: updateAssociations
			};

			if (self.model.schedules.length > 0) {
				$dialogs.confirm(
					cvLoc('label.confirmChangePolicyType'),
					cvLoc('label.confirmChangePolicyTypeText'),
					callBackFunctions
				);
			} else {
				callBackFunctions.yesFunction();
			}
		};

		self.isStoragePolicySupported = function() {
			return (
				self.model.associationsTree &&
				(self.model.task.policyType === 'SINGLE_INSTANCING' || self.model.task.policyType === 'CONTENT_INDEX')
			);
		};

		self.isDataProtectionSelected = function() {
			return self.model.associationsTree && self.model.task.policyType === 'DATA_PROTECTION';
		};

		self.isDataVerificationSelected = function() {
			return self.model.associationsTree && self.model.task.policyType === 'DATA_VERIFICATION';
		};

		self.isAuxCopySelected = function() {
			return self.model.associationsTree && self.model.task.policyType === 'AUX_COPY';
		};

		self.isContentIndexingSelected = function() {
			return self.model.associationsTree && self.model.task.policyType === 'CONTENT_INDEX_SUBCLIENT';
		};

		self.addSchedule = function(scheduleToBeEdited) {
			var agents = [];
			if (self.isDataProtectionSelected()) {
				agents = self.model.agentTypeTree.getSelectedNodes();
				if (angular.isArray(agents) && agents.length == 0) {
					self.model.serverMessage = cvUtil.errMsgLoc('error.selectAgents');
					return;
				}
				agents = formatSelectedAgentNodes(agents);
			}
			schedulePolicyFactory
				.addScheduleToPolicy({
					task: self.model.task,
					schedules: self.model.schedules,
					scheduleToBeEdited: scheduleToBeEdited,
					selectedAgents: agents
				})
				.then(function(subTask) {
					self.model.accordionStatus.schedulesTab = true;
					if (angular.isUndefined(scheduleToBeEdited)) {
						self.model.schedules.push(subTask);
					} else {
						angular.extend(scheduleToBeEdited, subTask);
					}
				});
		};

		self.editSchedule = function(scheduleToBeEdited) {
			self.addSchedule(scheduleToBeEdited);
		};

		self.saveSchedulePolicy = function() {
			var request = schedulePolicyFactory.createSchedulePolicyRequest(self.model);
			if (schedulePolicyFactory.isRequestValid(request, self.model)) {
				schedulePolicyService
					.addSchedulePolicy({
						schedulePolicyInfo: angular.toJson(request)
					})
					.success(function(data) {
						$modalInstance.close();
						$state.forceReload();
						cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.schedulePolicyCreationSuccess'));
					})
					.error(showErrorMessage);
			}
		};

		self.deleteSchedulePattern = function($scheduleIndex) {
			self.model.schedules.splice($scheduleIndex, 1);
		};

		self.clearErrorMessage = function() {
			self.model.serverMessage = cvUtil.emptyMsg();
		};

		self.close = function() {
			$modalInstance.dismiss();
		};

		function loadStoragePolicies() {
			self.model.associationsTreeParams.noExclusions = self.model.task.policyType != 'AUX_COPY'; //Exclusions are allowed only for 'Auxiliary copy' policy
			self.model.associationsTreeParams.isSelectable = function(node) {
				return node.entity.entityTypeName != 'STORAGE_POLICIES_ENTITY';
			};
		}

		function loadDDBEngines() {
			self.model.associationsTree = undefined;
			var storagePolicyId = 0,
				storagePolicyCopyId = 0;
			schedulePolicyService
				.getDDBEngines(storagePolicyId, storagePolicyCopyId)
				.success(function(DDBEngines) {
					self.model.associationsTree = schedulePolicyFactory.constructTreeNodesForDDBEngines(DDBEngines.engines);
					self.model.associationsTree[0].hideCheckbox = true;
				})
				.error(showErrorMessage);
		}

		function loadContentIndexingClients() {
			self.model.associationsTreeParams.hideClientGroups = true;
			self.model.associationsTreeParams.filterClientsByAgentId = AppTypes.EXCHANGE_MAILBOX; // To load only the clients having 'Exchange Mailbox'
		}

		function showErrorMessage(errorMessage) {
			var message = '';
			if (errorMessage && angular.isString(errorMessage)) {
				message = cvUtil.errMsg(errorMessage);
			} else if (errorMessage && angular.isString(errorMessage.data)) {
				message = cvUtil.errMsg(errorMessage.data);
			} else {
				message = cvUtil.errMsgLoc('generic_error');
			}
			self.model.serverMessage = message;
		}

		function updateAssociations() {
			if (
				self.model.task.policyType === 'AUX_COPY' ||
				self.model.task.policyType === 'SINGLE_INSTANCING' ||
				self.model.task.policyType === 'CONTENT_INDEX'
			) {
				loadStoragePolicies();
			} else if (self.model.task.policyType === 'DATA_VERIFICATION') {
				loadDDBEngines();
			} else if (self.model.task.policyType === 'CONTENT_INDEX_SUBCLIENT') {
				loadContentIndexingClients();
			}
			self.model.schedules = [];
			previousPolicyType = self.model.task.policyType;
		}

		function resetPolicyTypeDropdown() {
			self.model.task.policyType = previousPolicyType;
		}

		function formatSelectedAgentNodes(agentsList) {
			var agentIds = {
				appGroups: [],
				appTypes: []
			};
			if (agentsList && agentsList.length > 0) {
				agentsList.forEach(function(agent) {
					if (agent.isAppGroup) {
						agentIds.appGroups.push({
							appGroupId: agent.value,
							appGroupName: agent.label
						});
					} else {
						agentIds.appTypes.push({
							appTypeId: agent.value,
							appTypeName: agent.label
						});
					}
				});
			}
			return agentIds;
		}
	}
]);

export default app;
