<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1 data-ng-bind="svmMappingCtrl.modalTitle"></h1>
</div>
<form cv-hide-api class="bootstrap-wrapper" name="svmMappingForm" id="svmMappingForm" data-cv-submit="svmMappingCtrl.saveMappings()">
	<div class="form-group">
		<div class="col-xs-12">
			<span data-ng-if="svmMappingCtrl.serverMessage.message" class="{{svmMappingCtrl.serverMessage.type}} serverMessage margin-left-0">{{svmMappingCtrl.serverMessage.message}}</span>
		</div>
	</div>
	<div data-ng-show="svmMappingCtrl.currentCopyDefaultVaultReplica === true" class="form-group">
		<label class="col-xs-12 col-sm-5"><cv:msg key="label.snapVendor" bundle="profiles"/></label>
		<span class="col-xs-12 col-sm-7">
			<select id="snapVendor" name="snapVendor" data-ng-change="svmMappingCtrl.vendorTypeChanged()"  data-ng-model="svmMappingCtrl.selectedVendor" data-ng-options="vendor.id as vendor.name for vendor in svmMappingCtrl.snapVendors"></select>
		</span>
	</div>
	<div class="form-group">
		<label class="col-xs-12 col-sm-5" for="sourceSVM" data-ng-bind="svmMappingCtrl.sourceLabel"></label>
		<span class="col-xs-12 col-sm-7">
			<isteven-multi-select
				input-model="svmMappingCtrl.sourceSVM"
				output-model="svmMappingCtrl.sourceSVMSelected"
				button-label="name"
				item-label="name"
				tick-property="selected"
				selection-mode="single"
				class="isteven-multi-select"
				id="sourceSVM"
				name="sourceSVM"
				directive-id="sourceSVM"
				search-property="name"
				max-height="400px"
				group-property="header"
				helper-elements="filter">
			</isteven-multi-select>
		</span>
	</div>

	<div class="form-group">
		<label class="col-xs-12 col-sm-5" for="targetSVM" data-ng-bind="svmMappingCtrl.destLabel"></label>
		<span class="col-xs-12 col-sm-7">
			<isteven-multi-select
				input-model="svmMappingCtrl.targetSVM"
				output-model="svmMappingCtrl.targetSVMSelected"
				button-label="name"
				item-label="name"
				tick-property="selected"
				selection-mode="single"
				class="isteven-multi-select"
				id="targetSVM"
				name="targetSVM"
				directive-id="targetSVM"
				search-property="name"
				max-height="400px"
				group-property="header"
				helper-elements="filter">
			</isteven-multi-select>
		</span>
	</div>

	<div class="form-group">
		<button type="button" class="btn margin-left-15 margin-top-10" data-ng-click="svmMappingCtrl.addMappingPair()">
			<cv:msg key="action.add" bundle="profiles"/>
		</button>
	</div>

	<div class="padding-left-15 padding-right-15">
		<cv-kendo-grid class="storage-mapping-grid" cv-grid-options="svmMappingCtrl.mappingGridInfo"></cv-kendo-grid>
	</div>

	<div class="button-container">
		<button type="button" class="btn btn-default" data-ng-click="svmMappingCtrl.cancel()">
			<cv:msg key="Cancel" bundle="messages"/>
		</button>
		<button type="submit" class="btn btn-primary cvBusyOnAjax">
			<cv:msg key="Save" bundle="messages"/>
		</button>
	</div>
</form>