<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<label data-ng-bind="createOffice365PlanCtrl.getAppBasedModes.headerTile">  </label>
		<cv-help-component help-text='{{createOffice365PlanCtrl.getAppBasedModes.helpInfo}}'></cv-help-component>
	</h1>
</div>
<div class="setup-content">
	<div class="bootstrap-wrapper">
		<form
			name="addExchangeArchivingPlanForm"
			novalidate
			data-cv-submit="createOffice365PlanCtrl.create()"
			autocomplete="off"
		>
			<div class="panel panel-default">
				<div class="padding-left-15 padding-right-15" data-ng-if="createOffice365PlanCtrl.isOffice365SaaSTenant">
					<div class="form-group row">
						<label class="col-xs-12 col-md-5" for="planName"><cv:msg
								key="label.profileName" bundle="profiles" /></label>
						<div class="col-xs-12 col-md-7">
							<div class="input-group">
								<span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
									data-ng-bind="createOffice365PlanCtrl.office365PlanPrefix"></span>
								<input type="text" name="planName"
									autofocus required
									placeholder='&nbsp;&nbsp;<cv:msg key="placeholder.planName" bundle="office365"/>'
									data-ng-class="{'has-error': cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)}"
									data-ng-model="createOffice365PlanCtrl.saas_planName"
									id="planName" />
							</div>
							<div class="help-block"
								data-ng-show="cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)">
								<i class="ion-alert-circled"></i>
								<cv:msg key="error.noProfileName" bundle="profiles" />
							</div>
						</div>
					</div>	
				</div>
				<div class="padding-left-15 padding-right-15" data-ng-if="!createOffice365PlanCtrl.isOffice365SaaSTenant">
					<div class="form-group row">
						<label class="col-xs-12 col-md-5" for="planName"><cv:msg key="label.profileName" bundle="profiles"/></label>
						<div class="col-xs-12 col-md-7">
							<input
								type="text"
								name="planName"
								autofocus
								required
								data-ng-class="{'has-error': cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)}"
								data-ng-model="createOffice365PlanCtrl.planInfo.summary.plan.planName"
								id="planName"
							/>
							<div
								class="help-block"
								data-ng-show="cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)"
							>
								<i class="ion-alert-circled"></i>
								<cv:msg key="error.noProfileName" bundle="profiles" />
							</div>
						</div>
					</div>
					<div class="form-group text-left" ng-if="createOffice365PlanCtrl.getAppBasedModes.showArchive">
						<cv-toggle
							toggle-label="{{ 'label.enableBackuponArchiveMailbox' | cvLoc }}"
							value="createOffice365PlanCtrl.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.archiveMailbox"
							toggle-model="createOffice365PlanCtrl.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.archiveMailbox"
						></cv-toggle>
					</div>
				</div>
			</div>
			<div class="panel panel-default" ng-if="createOffice365PlanCtrl.getAppBasedModes.showRetention">
				<div class="panel-body">
					<h4><cv:msg key="label.retentionSettings" bundle="profiles" /></h4>
					<cv-exchange-plan-retention
						data-retention-policy="createOffice365PlanCtrl.planInfo.office365Info.o365CloudOffice.caRetention.detail.cloudAppPolicy.retentionPolicy"
						data-is-archiving-mailbox="true"
						data-is-office365-plan="true"
					></cv-exchange-plan-retention>
				</div>
			</div>
			<div class="panel panel-default" data-ng-if="!createOffice365PlanCtrl.isOffice365SaaSTenant && createOffice365PlanCtrl.getAppBasedModes.showSearch">
				<div class="panel-body">
					<h4 class="margin-bottom-20">
						<cv:msg key="label.searchSettings" bundle="profiles" />
						<cv-help-component
							help-text='<cv:msg key="label.applicableOnlyForExchange" bundle="profiles"/>'
						></cv-help-component>
					</h4>

					<cv-exchange-plan-content-indexing
						data-content-index-props="createOffice365PlanCtrl.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps"
						data-ee-policy="createOffice365PlanCtrl.planInfo.eePolicy"
						data-is-edit="false"
						data-show-data="createOffice365PlanCtrl.showData"
					></cv-exchange-plan-content-indexing>
				</div>
			</div>
			<div class="button-container">
				<button
					id="createOffice365Plan_button_#1195"
					type="button"
					class="btn btn-default cvBusyOnAjax"
					data-ng-click="createOffice365PlanCtrl.cancel()"
				>
					<cv:msg key="action.cancel" bundle="profiles" />
				</button>
				<button id="createOffice365Plan_button_#0103" type="submit" class="btn btn-primary cvBusyOnAjax">
					<cv:msg key="action.save" bundle="profiles" />
				</button>
			</div>
		</form>
	</div>
</div>
