<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div data-ng-if="!exchangePlanDetailsController.planLoaded"
	class="ajax-loader-container">
	<span data-cv-loading-spinner data-ng-model="loader"></span>
</div>
<div data-ng-if="exchangePlanDetailsController.planLoaded">
	<div class="row">
		<div class="col-md-12">
			<cv-changename class="float-left" data-obj="exchangePlanDetailsController.changeNameObj" data-ng-if="exchangePlanDetailsController.canEdit == true" data-service-method="renamePlan.do"></cv-changename>
			<h1 class='page-title' data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.summary.plan.planName}}</h1>
			<a	class="page-action-item pull-right" href="" data-ng-if="exchangePlanDetailsController.canDelete" data-ng-click="exchangePlanDetailsController.deletePlan()">
				<cv:msg key="action.delete" bundle="profiles" />
			</a>
		</div>
	</div>
	<cv-tab-nav ng-if="exchangePlanDetailsController.hasTabs"></cv-tab-nav>
	<div class="row">
		<div class="col-md-6">
			<!-- Archive Mailbox Types Tile -->
			<cv-tile-component data-ng-if="exchangePlanDetailsController.plan.originalPlanInfo.summary.subtype === 'ExchangeUser'" data-ac-id="journalMailboxPlanDetails-label_archiveMailboxTypes-exchange" data-title="<cv:msg key="label.archive" bundle="exchange" />">
				<ul class="list-style-secondary">
					<li class="group" data-ng-repeat="type in exchangePlanDetailsController.mailboxTypes track by type.key">
						<span class="pageDetailColumn"> {{type.displayName}} </span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy[type.key]"
								toggle-model="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy[type.key]"
								on-click="exchangePlanDetailsController.saveArchiveData(data, type.key)"></cv-toggle>
							<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy[type.key]	}}</span>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="exchangePlanDetailsController.canEdit == true" data-ng-click="exchangePlanDetailsController.plan.openEditArchiveSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
			<!-- End - Archive Mailbox Types Tile -->
			<!-- General Tile -->
			<cv-tile-component	data-ng-if="exchangePlanDetailsController.plan.originalPlanInfo.summary.subtype === 'ExchangeJournal'" data-title="<cv:msg key="header.general" bundle="exchange" />">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn">
							<cv:msg key="label.deleteArchivedMessagesAfterSuccess" bundle="exchange" />
						</span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.deleteArchivedMessages"
								toggle-model="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.deleteArchivedMessages"
								on-click="exchangePlanDetailsController.journalGeneralPropSave(data, 'deleteArchivedMessages')"></cv-toggle>
							<span data-ng-if="exchangePlanDetailsController.canEdit == false">
							{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.deleteArchivedMessages ? 'true' : 'false'}}</span>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="exchangePlanDetailsController.canEdit == true" data-ng-click="exchangePlanDetailsController.plan.openEditGeneralSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
			<!-- End General Tile -->
			<!--  Start Retention Tile -->
			<cv-exchange-plan-retention-tile data-can-edit="exchangePlanDetailsController.canEdit" data-plan="exchangePlanDetailsController.plan" data-is-archive-mailbox="exchangePlanDetailsController.isArchiveMailbox"></cv-exchange-plan-retention-tile>
 			<!-- End Retention Tile -->

			<!-- Cleanup Messages Tile -->
			<cv-tile-component  data-ng-if="exchangePlanDetailsController.plan.originalPlanInfo.summary.subtype === 'ExchangeUser'" data-ac-id="journalMailboxPlanDetails-label_cleanupMessages-exchange" data-title=" <cv:msg key="label.cleanup" bundle="exchange" />">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn">	<cv:msg key="label.customCleanupSettings" bundle="exchange" /> </span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.enableMessageRules"
								toggle-model="exchangePlanDetailsController.plan.planInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.enableMessageRules"
								on-click="exchangePlanDetailsController.plan.openEditCleanupMessagesModal(data, 'enableMessageRules')"></cv-toggle>
							<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.enableMessageRules ? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
					<li class="group" data-ng-if="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.enableMessageRules">
						<span class="pageDetailColumn"><cv:msg key="label.cleanupMessagesOlderThan" bundle="exchange" /></span>
						<span>
							<cv-tile-edit value="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.collectMsgsDaysAfterValueLabel" enable-inlineedit="true" edit-func="exchangePlanDetailsController.saveInlineEdit()">
								<input type="text" data-ng-model="exchangePlanDetailsController.plan.planInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.collectMsgsDaysAfter"/>
							</cv-tile-edit>
						</span>
					</li>
					<li class="group" data-ng-if="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.enableMessageRules">
						<span class="pageDetailColumn reduceLetterSpace">
							 <cv:msg key="label.cleanupMessagesLargerThan" bundle="exchange" />
						</span>
						<span>
							<cv-tile-edit value="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.collectMsgsLargerThanValueLabel" enable-inlineedit="true" edit-func="exchangePlanDetailsController.saveInlineEdit()">
								<input type="text" data-ng-model="exchangePlanDetailsController.plan.planInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.collectMsgsLargerThan"/>
							</cv-tile-edit>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="exchangePlanDetailsController.canEdit == true && exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.enableMessageRules == true" data-ng-click="exchangePlanDetailsController.plan.openEditCleanupMessagesModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
			<!-- End Cleanup Messages -->
		</div>
		<div class="col-md-6">
			<!-- Security tile Start -->
			<cv-security-component entity-type='exchangePlanDetailsController.entityType'
				generic-entity='exchangePlanDetailsController.genericEntity'
				associations='exchangePlanDetailsController.formattedSecurityAssociations'
				associations-loaded='exchangePlanDetailsController.associationsLoaded' show-edit='exchangePlanDetailsController.canEdit' hide-inherited-associations='exchangePlanDetailsController.isTenantAdmin'></cv-security-component>
			<!-- Security tile End -->
			<!-- Search Tile -->
			<cv-tile-component data-ng-if="exchangePlanDetailsController.plan.originalPlanInfo.summary.subtype === 'ExchangeUser'" data-title=" <cv:msg key="label.search" bundle="profiles" />">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.contentSearch" bundle="exchange" /></span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex"
								on-click="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration = false;	exchangePlanDetailsController.openEditSearchSettingsModal(data, 'enableContentIndex')"></cv-toggle>
								<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					 </li>
					 <li class="group"  ng-if="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex && exchangePlanDetailsController.showExactSearch">
						<span class="pageDetailColumn"><cv:msg key="label.enableExactSearch" bundle="exchange"></cv:msg></span>
							<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableExactSearch"
								toggle-model="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableExactSearch"
								on-click="exchangePlanDetailsController.openEditSearchSettingsModal(data, 'enableExactSearch')"></cv-toggle>
								<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{::exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
					<li class="group"  ng-if="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex">
						<span class="pageDetailColumn"><cv:msg key="label.enablePreviewGeneration" bundle="exchange" /></span>
 						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration"
								toggle-model="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration"
								on-click=" exchangePlanDetailsController.openEditSearchSettingsModal(data, 'enablePreviewGeneration')"></cv-toggle>
								<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					 </li>
 					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.entitySearch" bundle="exchange" /></span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch"
								toggle-model="exchangePlanDetailsController.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch"
								on-click="exchangePlanDetailsController.openEditSearchSettingsModal(data, 'enableEntitySearch')"></cv-toggle>
								<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="exchangePlanDetailsController.canEdit == true && (exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch == true || exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration == true)"
					data-ng-click="exchangePlanDetailsController.plan.openEditExchUserSearchSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
			<cv-tile-component data-ng-if="exchangePlanDetailsController.plan.originalPlanInfo.summary.subtype === 'ExchangeJournal'" data-title=" <cv:msg key="label.search" bundle="profiles" />">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.contentSearch" bundle="exchange" /></span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enableContentIndex"
								on-click="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enablePreviewGeneration = false;	exchangePlanDetailsController.openEditSearchSettingsModal(data, 'enableContentIndex')"></cv-toggle>
								<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enableContentIndex? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
 					</li>
					<li class="group"  ng-if="exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enableContentIndex">
						<span class="pageDetailColumn"><cv:msg key="label.enablePreviewGeneration" bundle="exchange" /></span>
 						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enablePreviewGeneration"
								toggle-model="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enablePreviewGeneration"
								on-click="exchangePlanDetailsController.openEditSearchSettingsModal(data, 'enablePreviewGeneration')"></cv-toggle>
								<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enablePreviewGeneration? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
 					</li>
 					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.entitySearch" bundle="exchange" /></span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="exchangePlanDetailsController.canEdit == true" value="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enableEntitySearch"
								toggle-model="exchangePlanDetailsController.plan.planInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enableEntitySearch"
								on-click="exchangePlanDetailsController.openEditSearchSettingsModal(data,'enableEntitySearch')"></cv-toggle>
								<span data-ng-if="exchangePlanDetailsController.canEdit == false">{{exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enableEntitySearch? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="exchangePlanDetailsController.canEdit == true && (exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enableEntitySearch == true || exchangePlanDetailsController.plan.originalPlanInfo.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.enablePreviewGeneration == true)"
					data-ng-click="exchangePlanDetailsController.plan.openEditExchJournalSearchSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
			<!-- Search Tile -->
		</div>
	</div>
	<!-- End Content Indexing Tile -->
</div>
