<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>;
</script>
<div class="bootstrap-wrapper form-horizontal">
	<cv-plain-accordion accordion-label="label.recoverableItems" collapsed="false" disable-collapse="true">
		<div class="panel panel-default">
			<div class="padding-left-15 padding-right-15">
				<div class="form-group">
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-name="{{ 'label.includeVersionsFolder' | cvLoc }}"
								toggle-label="{{ 'label.includeVersionsFolder' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeVersionsFolder"
							></cv-toggle>
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-name="{{ 'label.includeDiscoveryHoldsFolder' | cvLoc }}"
								toggle-label="{{ 'label.includeDiscoveryHoldsFolder' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeDiscoveryHoldsFolder"
							></cv-toggle>
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-name="{{ 'label.includePurgesFolder' | cvLoc }}"
								toggle-label="{{ 'label.includePurgesFolder' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includePurgesFolder"
							></cv-toggle>
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-name="{{ 'label.includeDeletionsFolder' | cvLoc }}"
								toggle-label="{{ 'label.includeDeletionsFolder' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.backupDeletedItemRetention"
							></cv-toggle>
						</label>
					</div>
				</div>
			</div>
		</div>
	</cv-plain-accordion>
	<cv-plain-accordion accordion-label="{{ exchangeEditModalController.showData.accordianTitle }}">
		<div class="panel panel-default">
			<div class="padding-left-15 padding-right-15">
				<div class="form-group col-xs-12">
					<label>
						<cv-toggle
							toggle-label="{{ exchangeEditModalController.showData.labelCustomArchiveSettings }}"
							value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.showArchiveCustomSettings"
							toggle-model="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.showArchiveCustomSettings"
							on-click="exchangeEditModalController.toggleCustomArchiveSettings(data)"
						></cv-toggle>
					</label>
				</div>
				<div
					class="form-group"
					ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.showArchiveCustomSettings"
				>
					<label class="col-xs-8"><cv:msg key="label.includeMessagesOlderThan" bundle="exchange"/></label>
					<div class="col-xs-4">
						<input
							type="number"
							id="includeMsgsOlderThan"
							name="includeMsgsOlderThan"
							required="required"
							min="0"
							data-ng-model="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeMsgsOlderThan"
							data-ng-change="exchangeEditModalController.confirmArchiveRuleChange()"
						/>
						{{ 'label.days' | cvLoc }}
						<div class="help-block" data-ng-show="cv.exchangeForm.needsAttention(exchangeForm.includeMsgsOlderThan)">
							{{ 'error.validDays' | cvLoc }}
						</div>
					</div>
				</div>
				<div
					class="form-group"
					ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.showArchiveCustomSettings"
				>
					<label class="col-xs-8"><cv:msg key="label.includeMessagesLargerThan" bundle="exchange"/></label>
					<div class="col-xs-4">
						<input
							type="number"
							id="includeMsgsLargerThan"
							name="includeMsgsLargerThan"
							required="required"
							min="0"
							data-ng-model="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeMsgsLargerThan"
						/>
						{{ 'labelKB' | cvLoc }}
						<div class="help-block" data-ng-show="cv.exchangeForm.needsAttention(exchangeForm.includeMsgsLargerThan)">
							{{ 'error.validDays' | cvLoc }}
						</div>
					</div>
				</div>
				<div
					class="form-group"
					ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.showArchiveCustomSettings"
				>
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-label="{{ 'label.includeOnlyMessagesThatContainAttachments' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeOnlyMsgsWithAttachemts"
							></cv-toggle>
						</label>
					</div>
				</div>
			</div>
		</div>
	</cv-plain-accordion>
	<cv-plain-accordion accordion-label="label.filters">
		<uib-tabset justified="true" active="defaultTab">
			<uib-tab heading="Folder filters">
				<fieldset class="toggle-inner-links">
					<div id="backup-content-wrapper">
						<div class="content-checkboxes">
							<div id="backup-content-folders">
								<div class="content-header clearfix">
									<h4>
										<cv:msg key="label.includeFolders" bundle="profiles" />
										<cv-help-component
											help-text='<cv:msg key="label.includeFolderFilterHelpText" bundle="profiles"/>'
										></cv-help-component>
									</h4>
									<div class="content-header-actions">
										<span
											class="page-action-item"
											data-ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter.folderPatternsSelected.length > 0"
										>
											<a
												href=""
												data-ng-click="exchangeEditModalController.removeFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter', 'exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter'], '', true)"
											>
												<span><cv:msg key="label.removeAll" bundle="profiles"/></span>
											</a>
										</span>
									</div>
								</div>
								<div class="peopleInfos ownerInfo content-to-backup">
									<div class="cv-modal-wrapper O365-modal  select-mode interactive-install-link no-margin">
										<label class="cv-label filter-label" for="includefolderName"
											><cv:msg key="label.customFolderName" bundle="profiles"
										/></label>
										<div class="cv-inline-wrapper filter-name-input-wrapper">
											<input class="display-inline filter-input" type="text" list="includeFolder"
											name="includefolderName" id="includefolderName"
											data-ng-model="exchangeEditModalController.includeFolderName" placeholder="<cv:msg
												key="label.enterFolderName"
												bundle="profiles"
											/>">
											<datalist id="includeFolder">
												<option
													data-ng-repeat="data in exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter.folderPatternsAvailable"
												>
													{{ data }}
												</option>
											</datalist>
											<i
												class="k-icon k-i-plus cursor-pointer"
												id="filter-buttons"
												title="Add"
												ng-click="exchangeEditModalController.addFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter', 'exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter'], 'includeFolderName')"
											></i>
											<i
												class="k-icon k-i-close cursor-pointer"
												id="filter-buttons"
												title="Remove"
												ng-click="exchangeEditModalController.includeFolderName = ''"
											></i>
										</div>
									</div>
									<ul
										class="users-list limit-modal-height"
										data-ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter.folderPatternsSelected.length > 0"
									>
										<li
											data-ng-repeat="includeFolder in exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter.folderPatternsSelected"
											title="{{ includeFolder }}"
										>
											<span class="content-library-folder content-library-folder">
												<label
													for="windows-{{ includeFolder }}"
													class="ellipsis-parent ellipsis-content"
													data-ng-if="includeFolder === '*'"
												>
													<span data-ng-if="includeFolder === '*'"><cv:msg key="label.all" bundle="exchange"/></span>
												</label>
												<span data-ng-if="includeFolder !== '*'">
													<span>
														<label
															for="windows-{{ includeFolder }}"
															class="ellipsis-parent ellipsis-content name-break-all"
														>
															<span ng-bind="includeFolder"></span>
														</label>
													</span>
													<span class="delete-row"
														><a
															href=""
															data-ng-click="exchangeEditModalController.removeFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter', 'exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter'], includeFolder, false)"
															title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{ includeFile }}"
															><span class="k-icon k-i-close"></span></a
													></span>
												</span>
											</span>
										</li>
									</ul>
									<label
										data-ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter.folderPatternsSelected.length === 0"
										class="users-list limit-modal-height"
									>
										<span class="content-library-folder content-library-folder">
											<label for="windows-{{ includeFolder }}" class="ellipsis-parent ellipsis-content">
												<span><cv:msg key="label.all" bundle="exchange"/></span>
											</label>
										</span>
									</label>
								</div>
							</div>
							<div id="exclude-folders">
								<div class="content-header clearfix">
									<h4><cv:msg key="label.excludeFolders" bundle="profiles" /></h4>
									<div class="content-header-actions">
										<span
											class="page-action-item"
											data-ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter.folderPatternsSelected.length > 0"
										>
											<a
												href=""
												data-ng-click="exchangeEditModalController.removeFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter','exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter'], '', true)"
											>
												<span><cv:msg key="label.removeAll" bundle="profiles"/></span>
											</a>
										</span>
									</div>
								</div>
								<div class="peopleInfos ownerInfo content-to-backup">
									<div class="cv-modal-wrapper O365-modal select-mode interactive-install-link no-margin">
										<label class="cv-label filter-label" for="excludefolderName"
											><cv:msg key="label.customFolderName" bundle="profiles"
										/></label>
										<div class="cv-inline-wrapper filter-name-input-wrapper">
											<input class="display-inline filter-input" type="text" list="excludeFolder"
											name="excludefolderName" id="excludefolderName"
											data-ng-model="exchangeEditModalController.excludeFolderName" placeholder="<cv:msg
												key="label.enterFolderName"
												bundle="profiles"
											/>">
											<datalist id="excludeFolder">
												<option
													data-ng-repeat="data in exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter.folderPatternsAvailable"
												>
													{{ data }}
												</option>
											</datalist>
											<i
												class="k-icon k-i-plus cursor-pointer"
												id="filter-buttons"
												title="Add"
												ng-click="exchangeEditModalController.addFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter','exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter'], 'excludeFolderName')"
											></i>
											<i
												class="k-icon k-i-close cursor-pointer"
												id="filter-buttons"
												title="Remove"
												ng-click="exchangeEditModalController.excludeFolderName = ''"
											></i>
										</div>
									</div>
									<ul
										class="users-list limit-modal-height"
										ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter.folderPatternsSelected.length > 0"
									>
										<li
											data-ng-repeat="excludeFolder in exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter.folderPatternsSelected"
											title="{{ excludeFolder }}"
										>
											<span class="content-library-folder content-library-folder">
												<label
													for="windows-{{ excludeFolder }}"
													class="ellipsis-parent ellipsis-content"
													data-ng-if="excludeFolder === '*'"
												>
													<span data-ng-if="excludeFolder === '*'"><cv:msg key="label.all" bundle="exchange"/></span>
												</label>
												<span data-ng-if="excludeFolder !== '*'">
													<span>
														<label
															for="windows-{{ excludeFolder }}"
															class="ellipsis-parent ellipsis-content name-break-all"
														>
															<span ng-bind="excludeFolder"></span>
														</label>
													</span>
													<span class="delete-row"
														><a
															href=""
															data-ng-click="exchangeEditModalController.removeFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter','exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeFolderFilter'], excludeFolder, false)"
															title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{ excludeFolder }}"
															><span class="k-icon k-i-close"></span></a
													></span>
												</span>
											</span>
										</li>
									</ul>
									<label
										data-ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeFolderFilter.folderPatternsSelected.length === 0"
										class="users-list limit-modal-height"
									>
										<span class="k-icon k-i-cancel-outline error"></span>
										<span><cv:msg key="label.none" bundle="profiles"/></span>
									</label>
								</div>
							</div>
						</div>
					</div>
				</fieldset>
			</uib-tab>
			<uib-tab heading="Message filters">
				<fieldset class="toggle-inner-links">
					<div id="backup-content-wrapper">
						<div class="content-checkboxes">
							<div id="backup-content-folders">
								<div class="content-header clearfix">
									<h4>
										<cv:msg key="label.excludeMessagesTypes" bundle="profiles" />
									</h4>
									<div class="content-header-actions">
										<span
											class="page-action-item"
											data-ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter.folderPatternsSelected.length > 0"
										>
											<a
												href=""
												data-ng-click="exchangeEditModalController.removeFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter'], '', true)"
											>
												<span><cv:msg key="label.removeAll" bundle="profiles"/></span>
											</a>
										</span>
									</div>
								</div>
								<div class="peopleInfos ownerInfo content-to-backup">
									<div class="cv-modal-wrapper O365-modal select-mode interactive-install-link no-margin">
										<label class="cv-label filter-label" for="excludeMessageName"
											><cv:msg key="label.messageTypes" bundle="profiles"
										/></label>
										<div class="cv-inline-wrapper filter-name-input-wrapper">
											<input class="display-inline filter-input" type="text" list="excludeMessage"
											name="excludeMessageName" id="excludeMessageName"
											data-ng-model="exchangeEditModalController.excludeMessageName" placeholder="<cv:msg
												key="label.enterMessageTypes"
												bundle="profiles"
											/>">
											<datalist id="excludeMessage">
												<option
													data-ng-repeat="data in exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter.folderPatternsAvailable"
												>
													{{ data }}
												</option>
											</datalist>
											<i
												class="k-icon k-i-plus cursor-pointer"
												id="filter-buttons"
												title="Add"
												ng-click="exchangeEditModalController.addFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter'], 'excludeMessageName')"
											></i>
											<i
												class="k-icon k-i-close cursor-pointer"
												id="filter-buttons"
												title="Remove"
												ng-click="exchangeEditModalController.excludeMessageName = ''"
											></i>
										</div>
									</div>
									<ul
										class="users-list limit-modal-height"
										ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter.folderPatternsSelected.length > 0"
									>
										<li
											data-ng-repeat="excludeMessageClass in exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter.folderPatternsSelected"
											title="{{ excludeMessageClass }}"
										>
											<span class="content-library-folder content-library-folder">
												<label
													for="windows-{{ excludeMessageClass }}"
													class="ellipsis-parent ellipsis-content"
													data-ng-if="excludeMessageClass === '*'"
												>
													<span data-ng-if="excludeMessageClass === '*'"
														><cv:msg key="label.all" bundle="exchange"
													/></span>
												</label>
												<span data-ng-if="excludeMessageClass !== '*'">
													<span>
														<label
															for="windows-{{ excludeMessageClass }}"
															class="ellipsis-parent ellipsis-content name-break-all"
														>
															<span ng-bind="excludeMessageClass"></span>
														</label>
													</span>
													<span class="delete-row"
														><a
															href=""
															data-ng-click="exchangeEditModalController.removeFilterValues(['exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter'], excludeMessageClass, false)"
															title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{ excludeFolder }}"
															><span class="k-icon k-i-close"></span></a
													></span>
												</span>
											</span>
										</li>
									</ul>
									<label
										data-ng-if="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.excludeMessageClassFilter.folderPatternsSelected.length === 0"
										class="users-list limit-modal-height"
									>
										<span class="k-icon k-i-cancel-outline error"></span>
										<span><cv:msg key="label.none" bundle="profiles"/></span>
									</label>
								</div>
							</div>
						</div>
					</div>
				</fieldset>
			</uib-tab>
			<!-- // file filter ends // -->
		</uib-tabset>
	</cv-plain-accordion>
	<cv-plain-accordion accordion-label="label.advancedArchiveOptions" ng-if="!exchangeEditModalController.isOffice365">
		<div class="panel panel-default">
			<div class="padding-left-15 padding-right-15">
				<div class="form-group">
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-name="{{ 'label.useExchangeRestriction' | cvLoc }}"
								toggle-label="{{ 'label.useExchangeRestriction' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.useExchangeRestriction"
							></cv-toggle>
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-name="{{ 'label.converstaionIndex' | cvLoc }}"
								toggle-label="{{ 'label.converstaionIndex' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.saveConversationMetaData"
							></cv-toggle>
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<label>
							<cv-toggle
								toggle-name="{{ 'label.collectCategories' | cvLoc }}"
								toggle-label="{{ 'label.collectCategories' | cvLoc }}"
								value="exchangeEditModalController.exchangeDetails.mbArchiving.detail.emailPolicy.archivePolicy.includeCategories"
							></cv-toggle>
						</label>
					</div>
				</div>
			</div>
		</div>
	</cv-plain-accordion>
</div>
