<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.editOverrideOptions" bundle="profiles"/></h1>
</div>
<form name="editOverrideSettingsForm" class="form-horizontal bootstrap-wrapper"
		data-cv-submit="saveOverrideSettings()" novalidate autocomplete="off">
	<div class="modal-body">
		<div data-ng-repeat="message in messages" class="{{message.type}} serverMessage text-center">{{message.message}}</div>
		<div class="form-group" data-ng-repeat="setting in model.settings" data-ng-if="!setting.hidden">
			<div class="col-xs-7">
				<span data-ng-bind-html="setting.label"></span>
				<span data-ng-switch="setting.model.overrideEntity">
					<span data-ng-switch-when="Must">
						<cv-help-component
							data-help-text="<cv:msg key="label.overrideOptionsHelpText.must" bundle="profiles"/>">
						</cv-help-component>
					</span>
					<span data-ng-switch-when="NotAllowed">
						<cv-help-component
							data-help-text="<cv:msg key="label.overrideOptionsHelpText.notAllowed" bundle="profiles"/>">
						</cv-help-component>
					</span>
					<span data-ng-switch-default>
						<cv-help-component
							data-help-text="<cv:msg key="label.overrideOptionsHelpText.optional" bundle="profiles"/>">
						</cv-help-component>
					</span>
				</span>
			</div>
			<div class="col-xs-5">
				<input type="checkbox" id="edit-override-checkbox-{{$id}}"
						data-ng-model="setting.model.definesEntity" data-ng-disabled="setting.disabled"/>
				<label for="edit-override-checkbox-{{$id}}">
					<cv:msg key="label.overrideBaseSettings" bundle="profiles"></cv:msg>
				</label>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button id="editOverrideSettings_button_#3216" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"> 
			<cv:msg key="action.cancel" bundle="profiles"/>
		</button>
		<button id="editOverrideSettings_button_#0866" type="submit" class="btn btn-primary cvBusyOnAjax"> 
			<cv:msg key="action.save" bundle="profiles"/>
		</button>
	</div>
</form>