<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div data-ng-if="model.readOnly">
	<ul class="list-style-secondary">
		<li class="group" data-ng-if="model.selectedTargetApp">
			<span class="pageDetailColumn"><cv:msg key="label.targetApp" bundle="ediscovery"/></span>
			<span class="pageDetailColumn">{{model.selectedTargetApp}}</span>
		</li>
		<li class="group">
			<span class="pageDetailColumn"><cv:msg key="label.analyticsEngine" bundle="ediscovery" /></span>
			<span class="pageDetailColumn">{{model.ediscoveryInfo.analyticsIndexServer.clientName}}</span>
		</li>
	</ul>
</div>
<div data-ng-if="!model.readOnly">
	<div class="form-group">
		<label class="col-xs-12 col-lg-3 col-md-3"><cv:msg key="label.indexServer" bundle="exchange" /></label>
		<div class="col-xs-11 col-lg-8 col-md-8">
			<isteven-multi-select
				input-model="model.indexServers"
				output-model="model.selectedIndexServers"
				button-label="indexServerClientName"
				item-label="indexServerClientName"
				selection-mode="single"
				tick-property="selected"
				translation="model.localLang"
				helper-elements="filter"
				search-property="indexServerClientName"
				min-search-length="1"
				is-required="true">
			</isteven-multi-select>
			<input type="text" ng-model="model.selectedIndexServers" name="selectedIndexServers" style="display:none" required />

			<div class="help-block" data-ng-if="submitCtrl.needsAttention(formCtrl.selectedIndexServers) && formCtrl.selectedIndexServers.$error.required">
				<i class="ion-alert-circled" ></i>
				<cv:msg key="error.noIndexServer" bundle="profiles" />
			</div>
		</div>
		<div class="col-xs-1 padding-top-5 padding-left-20">
			<a>
				<span class="k-icon k-i-plus-outline cursor-pointer" data-ng-click="model.addIndexServer()"></span>
			</a>
		</div>
	</div>
</div>
