<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="col-xs-12 no-padding">
	<label data-ng-class="model.labelPosition">
          <cv:msg key="label.taskDetail.entities" bundle="ediscovery"/>
     </label>
     <div data-ng-class="model.controlPosition" class="entity-wrapper entity-selection-element">
          <cv-tile-component data-ng-if="!model.readOnly" loader="model.entityListLoader">
               <cv-entity-multi-select
                    data-ng-if="model.entityList.length > 0"
                    entity-list="model.entityList"
                    selected-entities="model.multiSelectEntities"
                    selection-mode="multiple"
                    read-only="model.readOnly"
                    on-entities-select="model.onEntitiesSelected(entities)"></cv-entity-multi-select>
               <input type="text" ng-model="model.multiSelectEntities[0]" name="entitiesSelected" style="display:none" required />
               <span class="help-block padding-top-10" data-ng-if="submitCtrl.needsAttention(formCtrl.entitiesSelected)">
                    <i class="ion-alert-circled"></i>
                    <cv:msg key="error.selectEntity" bundle="ediscovery" />
               </span>
          </cv-tile-component>
          <isteven-multi-select
               data-ng-if="model.readOnly"
               input-model="model.entityList"
               output-model=""
               button-label="displayName"
               item-label="displayName"
               tick-property="selected"
               directive-id="entities"
               name="entities"
               max-labels="3"
               translation="model.entitiesText"
               helper-elements="{{model.helperElements}}"
               disable-property="disabled"
               group-property="msGroup">
          </isteven-multi-select>    
     </div>
</div>
<div class="col-xs-12 no-padding margin-top-15">
     <cv-plain-accordion accordion-label="label.classification" data-ng-if="!model.readOnly">
          <div class="padding-top-10">
               <label data-ng-class="model.labelPosition"><cv:msg key="label.classifiermanager.classifiers" bundle="ediscovery"/></label>
               <div data-ng-class="model.controlPosition" class="entity-wrapper entity-selection-element">
                    <isteven-multi-select
                         input-model="model.classifiersList"
                         output-model="model.classifiersSelected"
                         button-label="displayName"
                         item-label="displayName"
                         tick-property="selected"
                         directive-id="classifiers"
                         max-labels="3"
                         translation="model.entitiesText"
                         helper-elements="{{model.helperElements}}"
                         is-disabled="model.readOnly"
                         min-search-length="3"
                         search-property="displayName"
                         output-properties="entityId"
                         group-property="msGroup"
                         on-close="model.onClassifiersClosed()">
                    </isteven-multi-select>
               </div>
          </div>
     </cv-plain-accordion>
     <div data-ng-if="model.readOnly">
          <label data-ng-class="model.labelPosition"><cv:msg key="label.classifiermanager.classifiers" bundle="ediscovery"/></label>
          <div data-ng-class="model.controlPosition" class="entity-wrapper entity-selection-element">
               <isteven-multi-select
                    input-model="model.classifiersList"
                    output-model="model.classifiersSelected"
                    button-label="displayName"
                    item-label="displayName"
                    tick-property="selected"
                    directive-id="classifiers"
                    max-labels="3"
                    translation="model.entitiesText"
                    helper-elements="{{model.helperElements}}"
                    is-disabled="model.readOnly"
                    min-search-length="3"
                    search-property="displayName"
                    output-properties="entityId"
                    group-property="msGroup"
                    on-close="model.onClassifiersClosed()">
               </isteven-multi-select>
          </div>
     </div>
</div>