<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="row bootstrap-wrapper" data-ng-controller="createVsaProfileBackupTabController">
<div class="setup-title">
	<h1 data-ng-if="vsaSetupState">
		<cv:msg key="label.createVsaBackupPlan" bundle="profiles" />
		<cv-help-component help-text="<cv:msg key="label.addServerPlanHelpText" bundle="profiles" />"></cv-help-component>
	</h1>
	<h1 data-ng-if="!vsaSetupState">
		<cv:msg key="label.backup" bundle="profiles" />
	</h1>
</div>
	<div class="setup-content" data-ng-if="false">
		<p class="{{planExistedMessage.type}} serverMessage">{{planExistedMessage.message}}</p>
		<p class="text-center"><a data-ng-click="goToCreatePlan()" data-ng-hide="showCreatePlanForm || !showPlanSkip || !skipForSetup"> <cv:msg key="label.CreateNewPlan" bundle="profiles" /></a></p>
		<div data-ng-hide="showCreatePlanForm || !showPlanSkip || !skipForSetup" class="button-container centered">
			<button id="createVsaPlanBackup_button_#5491" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="label.continue" bundle="profiles" /></button> 
		</div>
	</div>
	<div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
		<form data-ng-show="!skipForSetup || showPlanSkip===false || showCreatePlanForm" class="form-horizontal bootstrap-wrapper" name="addVsaPLanBackupForm" data-cv-submit="saveStorage()" novalidate autocomplete="off">
			<!-- // name // -->
			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-lg-3" for="planName"><cv:msg key="label.profileName" bundle="profiles" /></label>
						<div class="col-xs-12 col-lg-6">
							<input type="text" name="planName" data-ng-model="globalTemplate.name" id="planName" data-autoselect="{{autoSelect}}" data-ng-focus="serverMessage.message=''" autofocus />
						</div>
					</div>
				</div>
			</div>
			<div class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</div>
			<div data-ng-if="showGrid" class="global-options remove-border-padding text-left list-group">
				<cv-grid cv-grid-options="gridOptions"></cv-grid>
			</div>
			<!-- // Storage guts now live in vsaPlanStorageTemplate.jsp  //  -->
			<cv-tile-component data-ac-id="label_plan_storage-profiles" extra-class="no-tile boundary" data-title='<cv:msg key="label.plan.storage" bundle="profiles" />'>
				<cv-vsa-plan-storage-component data-ng-model="storage.model" storages="globalTemplate.storages"
					 ctrl="storage.ctrl" available-storage-pools='storage.availableStoragePools'></cv-vsa-plan-storage-component>
			</cv-tile-component>
			<!-- RPO and SLA -->
			<cv-tile-component data-ac-id="label_sla-profiles" extra-class="no-tile boundary" data-title='<cv:msg key="label.rpo" bundle="profiles" />' data-help-text="<cv:msg key="info.help.rpo" bundle="profiles" />">
				<div class="panel panel-default">
					<div class="panel-body">
						<div class="form-group">
							<label class="col-xs-12 col-lg-3" for="rpo">
								<cv:msg key="label.backupFrequency" bundle="profiles" />
							</label>
							<div class="col-xs-12 col-lg-9">
								<input id="rpo" name="rpo" type="number" min="1" data-ng-model="globalTemplate.rpo" data-ng-change="updateSla()" data-ng-class="{'setup' : skipForSetup}" />
								<cv:msg key="label.hours" bundle="schedule" />
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-lg-3"><cv:msg key="label.backupWindow" bundle="profiles" /></label>
							<label class="col-xs-12 col-lg-9">
								<cv-backup-window-list data-cv-model="globalTemplate.backupWindow"></cv-backup-window-list>
							</label>
						</div>
					</div>
				</div>
			</cv-tile-component>
			<!-- // Schedule // -->
			<cv-tile-component data-ac-id="label_schedule-schedule" extra-class="no-tile boundary" data-title='<cv:msg key="label.schedule" bundle="schedule" />' data-ng-if="associatedSchedulesEnabled">
				<div>
					<ul class="list-style__row group" data-ng-repeat="schedule in globalTemplate.schedules track by $index">
						<li class="ellipsis-parent ellipsis-content"><a data-ng-click="editSchedule(schedule)">{{schedule.subTask.subTaskName}}<span data-ng-if="schedule.subTask.flags === slaFlag" class='parenthetical-text'>- <cv:msg key="label.rpoSchedule" bundle="profiles" />
						</span></a></li>
					</ul>
					<ul class="list-style__row group" data-ng-if="globalTemplate.schedules.length==0">
						<li class="ellipsis-parent ellipsis-content "><cv:msg key="error.noScheduleAdded" bundle="schedule" /></li>
					</ul>
				</div>
				<div class="page-details-box-links">
					<a href="" data-ng-click="addSchedule()"><cv:msg key="label.addSchedule" bundle="profiles" /></a>
				</div>
			</cv-tile-component>
			<div class="button-container" data-ng-hide="acSetupPlan">
				<button id="createVsaPlanBackup_button_#1692" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="skip()" data-ng-if="showPlanSkip && skipForSetup"><cv:msg key="action.skip" bundle="profiles" /></button> 
				<button id="createVsaPlanBackup_button_#3067" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<span data-ng-if="!showFinish || storage.availableStoragePools.length != 1"><cv:msg key="action.next" bundle="profiles" /></span>
					<span data-ng-if="showFinish && storage.availableStoragePools.length == 1"><cv:msg key="action.finish" bundle="profiles" /></span>
				</button>
			</div>
		</form>
	</div>
</div>